/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.util;

import io.getstream.client.config.AuthenticationHandlerConfiguration;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.crypto.spec.SecretKeySpec;
import org.tomitribe.auth.signatures.Signature;
import org.tomitribe.auth.signatures.Signer;

public class HttpSignatureHandler {
    public static final String X_API_KEY_HEADER = "X-Api-Key";
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final String DATE_HEADER = "Date";
    private final Signer signer;

    public HttpSignatureHandler(AuthenticationHandlerConfiguration authConfig) {
        this.signer = new Signer((Key)new SecretKeySpec(authConfig.getSecretKey().getBytes(), "HmacSHA256"), new Signature(authConfig.getApiKey(), "hmac-sha256", null, new String[]{DATE_HEADER}));
    }

    protected Signer getSigner() {
        return this.signer;
    }

    protected String getTodayDate() {
        SimpleDateFormat today = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        today.setTimeZone(TimeZone.getTimeZone("GMT"));
        return today.format(new Date());
    }
}

