/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.model.feeds;

import com.google.common.base.Optional;
import io.getstream.client.exception.InvalidFeedNameException;
import io.getstream.client.model.feeds.BaseFeed;
import io.getstream.client.model.feeds.Feed;
import io.getstream.client.model.feeds.FeedFactory;
import io.getstream.client.model.feeds.PersonalizedFeed;
import io.getstream.client.model.feeds.PersonalizedFeedImpl;
import io.getstream.client.repo.StreamPersonalizedRepository;
import io.getstream.client.repo.StreamRepository;
import java.util.regex.Pattern;

public final class BaseFeedFactory
implements FeedFactory {
    private static final Pattern FEED_SLUG_PATTERN = Pattern.compile("\\w+");
    private static final Pattern FEED_ID_PATTERN = Pattern.compile("[\\w-]+");
    private final StreamRepository streamRepository;
    private final Optional<StreamPersonalizedRepository> streamPersonalizedRepository;

    public BaseFeedFactory(StreamRepository streamRepository, Optional<StreamPersonalizedRepository> streamPersonalizedRepository) {
        this.streamRepository = streamRepository;
        this.streamPersonalizedRepository = streamPersonalizedRepository;
    }

    @Override
    public Feed createFeed(String feedSlug, String id) throws InvalidFeedNameException {
        if (FEED_SLUG_PATTERN.matcher(feedSlug).matches() && FEED_ID_PATTERN.matcher(id).matches()) {
            return new BaseFeed(this.streamRepository, feedSlug, id);
        }
        throw new InvalidFeedNameException("Either feedSlug or id are not valid. Feed slug only accept words, feed id accepts words and hyphens");
    }

    @Override
    public PersonalizedFeed createPersonalizedFeed(String feedSlug, String id) throws InvalidFeedNameException {
        if (!this.streamPersonalizedRepository.isPresent()) {
            throw new UnsupportedOperationException("Personalized feed not properly initialized.Please provide a working endpoint for Personalization.");
        }
        if (FEED_SLUG_PATTERN.matcher(feedSlug).matches() && FEED_ID_PATTERN.matcher(id).matches()) {
            return new PersonalizedFeedImpl((StreamPersonalizedRepository)this.streamPersonalizedRepository.get(), feedSlug, id);
        }
        throw new InvalidFeedNameException("Either feedSlug or id are not valid. Feed slug only accept words, feed id accepts words and hyphens");
    }
}

