/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.model.filters;

import java.util.List;

public class FeedFilter {
    public static final String PARAM_LIMIT = "limit";
    public static final String PARAM_OFFSET = "offset";
    public static final String PARAM_ID_GREATER_THAN = "id_gt";
    public static final String PARAM_ID_GREATER_THAN_EQUALS = "id_gte";
    public static final String PARAM_ID_LOWER_THAN = "id_lt";
    public static final String PARAM_ID_LOWER_THAN_EQUALS = "id_lte";
    public static final String PARAM_FEED_IDS = "filter";
    public static final String PARAM_RANKING = "ranking";
    private static final int DEFAULT_LIMIT = 25;
    private Integer limit = 25;
    private Integer offset = null;
    private String idGreaterThan = null;
    private String idGreaterThanEquals = null;
    private String idLowerThanEquals = null;
    private String idLowerThan = null;
    private String ranking = null;
    private List<String> feedIds = null;

    protected FeedFilter() {
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getIdGreaterThan() {
        return this.idGreaterThan;
    }

    public String getIdGreaterThanEquals() {
        return this.idGreaterThanEquals;
    }

    public String getIdLowerThanEquals() {
        return this.idLowerThanEquals;
    }

    public String getIdLowerThan() {
        return this.idLowerThan;
    }

    public List<String> getFeedIds() {
        return this.feedIds;
    }

    public String getRanking() {
        return this.ranking;
    }

    public static class Builder {
        protected final FeedFilter feedFilter = new FeedFilter();

        public FeedFilter build() {
            return this.feedFilter;
        }

        public Builder withLimit(int limit) {
            this.feedFilter.limit = limit;
            return this;
        }

        public Builder withOffset(int offset) {
            this.feedFilter.offset = offset;
            return this;
        }

        public Builder withIdGreaterThan(String idGreaterThan) {
            this.feedFilter.idGreaterThan = idGreaterThan;
            return this;
        }

        public Builder withIdGreaterThanEquals(String idGreaterThanEquals) {
            this.feedFilter.idGreaterThanEquals = idGreaterThanEquals;
            return this;
        }

        public Builder withIdLowerThanEquals(String idLowerThanEquals) {
            this.feedFilter.idLowerThanEquals = idLowerThanEquals;
            return this;
        }

        public Builder withIdLowerThan(String idLowerThan) {
            this.feedFilter.idLowerThan = idLowerThan;
            return this;
        }

        public Builder withRanking(String ranking) {
            this.feedFilter.ranking = ranking;
            return this;
        }

        public Builder withFeedIds(List<String> feeds) {
            this.feedFilter.feedIds = feeds;
            return this;
        }
    }
}

