/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.util;

import com.google.common.base.Preconditions;
import io.getstream.client.config.ClientConfiguration;
import io.getstream.client.exception.UriBuilderException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class EndpointUtil {
    private EndpointUtil() {
    }

    public static URI getPersonalizedEndpoint(ClientConfiguration streamClient) {
        String endpoint = streamClient.getPersonalizedFeedEndpoint();
        Preconditions.checkNotNull((Object)endpoint, (Object)"Personalized url cannot be null");
        try {
            if (endpoint.endsWith("/")) {
                return new URL(endpoint).toURI();
            }
            return new URL(endpoint.concat("/")).toURI();
        }
        catch (MalformedURLException e) {
            throw new UriBuilderException("Malformed personalized feed's URL.");
        }
        catch (URISyntaxException e) {
            throw new UriBuilderException("Malformed personalized feed's URL.");
        }
    }

    public static URI getBaseEndpoint(ClientConfiguration streamClient) throws UriBuilderException {
        if (null != streamClient.getDefaultEndpoint()) {
            try {
                return new URI(streamClient.getDefaultEndpoint());
            }
            catch (URISyntaxException e) {
                throw new UriBuilderException("Malformed GetStream.io base URL.");
            }
        }
        return streamClient.getRegion().getEndpoint();
    }
}

