/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.service;

import io.getstream.client.exception.StreamClientException;
import io.getstream.client.model.activities.BaseActivity;
import io.getstream.client.model.activities.NotificationActivity;
import io.getstream.client.model.beans.MarkedActivity;
import io.getstream.client.model.beans.StreamResponse;
import io.getstream.client.model.feeds.BaseFeed;
import io.getstream.client.model.filters.FeedFilter;
import io.getstream.client.repo.StreamRepository;
import io.getstream.client.service.AbstractActivityService;
import io.getstream.client.service.NotificationActivityService;
import java.io.IOException;

public class NotificationActivityServiceImpl<T extends BaseActivity>
extends AbstractActivityService<T>
implements NotificationActivityService<T> {
    public NotificationActivityServiceImpl(BaseFeed feed, Class type, StreamRepository streamRepository) {
        super(feed, type, streamRepository);
    }

    @Override
    public StreamResponse<NotificationActivity<T>> getActivities() throws IOException, StreamClientException {
        return this.streamRepository.getNotificationActivities(this.feed, this.type, new FeedFilter.Builder().build());
    }

    @Override
    public StreamResponse<NotificationActivity<T>> getActivities(FeedFilter filter, boolean markAsRead, boolean markAsSeen) throws IOException, StreamClientException {
        return this.streamRepository.getNotificationActivities(this.feed, this.type, filter, markAsRead, markAsSeen);
    }

    @Override
    public StreamResponse<NotificationActivity<T>> getActivities(FeedFilter filter, MarkedActivity markAsRead, MarkedActivity markAsSeen) throws IOException, StreamClientException {
        return this.streamRepository.getNotificationActivities(this.feed, this.type, new FeedFilter.Builder().build(), markAsRead, markAsSeen);
    }
}

