/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.service;

import io.getstream.client.exception.StreamClientException;
import io.getstream.client.model.activities.BaseActivity;
import io.getstream.client.model.beans.StreamActivitiesResponse;
import io.getstream.client.model.feeds.BaseFeed;
import io.getstream.client.repo.StreamRepository;
import java.io.IOException;
import java.util.List;

public abstract class AbstractActivityService<T extends BaseActivity> {
    protected Class<T> type;
    protected final BaseFeed feed;
    protected final StreamRepository streamRepository;

    public AbstractActivityService(BaseFeed feed, Class type, StreamRepository streamRepository) {
        this.type = type;
        this.feed = feed;
        this.streamRepository = streamRepository;
    }

    public T addActivity(T activity) throws IOException, StreamClientException {
        return this.streamRepository.addActivity(this.feed, activity);
    }

    public StreamActivitiesResponse<T> addActivities(List<T> activities) throws IOException, StreamClientException {
        return this.streamRepository.addActivities(this.feed, this.type, activities);
    }

    public StreamActivitiesResponse<T> updateActivities(List<T> activities) throws IOException, StreamClientException {
        return this.streamRepository.updateActivities(this.feed, this.type, activities);
    }

    public T addActivityToMany(List<String> targetIds, T activity) throws IOException, StreamClientException {
        return this.streamRepository.addActivityToMany(targetIds, activity);
    }
}

