/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import java.io.UnsupportedEncodingException;

public class JwtAuthenticationUtil {
    public static final String ALL = "*";

    public static String generateToken(String secretKey, String action, String resource, String feedId, String userId) {
        JWTCreator.Builder jwtBuilder = JWT.create();
        jwtBuilder = jwtBuilder.withClaim("action", action);
        jwtBuilder = jwtBuilder.withClaim("resource", resource);
        if (null != feedId) {
            jwtBuilder = jwtBuilder.withClaim("feed_id", feedId);
        }
        if (null != userId) {
            jwtBuilder = jwtBuilder.withClaim("user_id", userId);
        }
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secretKey);
            return jwtBuilder.sign(algorithm);
        }
        catch (UnsupportedEncodingException exc) {
            throw new IllegalStateException("Fatal error: JWT Algorithm unsupported.");
        }
    }
}

