/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.model.beans;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class Targets {
    private ImmutableList<String> newTargets;
    private ImmutableList<String> addedTargets;
    private ImmutableList<String> removedTargets;

    public Targets(List<String> newTargets, List<String> addedTargets, List<String> removedTargets) {
        if (!newTargets.isEmpty()) {
            this.newTargets = ImmutableList.copyOf(newTargets);
        }
        if (!addedTargets.isEmpty()) {
            this.addedTargets = ImmutableList.copyOf(addedTargets);
        }
        if (!removedTargets.isEmpty()) {
            this.removedTargets = ImmutableList.copyOf(removedTargets);
        }
    }

    public List<String> getNewTargets() {
        return this.newTargets;
    }

    public List<String> getAddedTargets() {
        return this.addedTargets;
    }

    public List<String> getRemovedTargets() {
        return this.removedTargets;
    }

    public static class Builder {
        private List<String> newTargets = new ArrayList<String>();
        private List<String> addedTargets = new ArrayList<String>();
        private List<String> removedTargets = new ArrayList<String>();

        public Builder setNewTargets(List<String> newTargets) {
            this.newTargets = newTargets;
            return this;
        }

        public Builder setAddedTargets(List<String> addedTargets) {
            this.addedTargets = addedTargets;
            return this;
        }

        public Builder setRemovedTargets(List<String> removedTargets) {
            this.removedTargets = removedTargets;
            return this;
        }

        public Builder addNewTarget(String target) {
            this.newTargets.add(target);
            return this;
        }

        public Builder addTargetToAdd(String target) {
            this.addedTargets.add(target);
            return this;
        }

        public Builder addTargetToRemove(String target) {
            this.removedTargets.add(target);
            return this;
        }

        public Targets build() {
            if (!(this.newTargets.isEmpty() || this.addedTargets.isEmpty() && this.removedTargets.isEmpty())) {
                throw new IllegalArgumentException("You can specify either new targets or added targets or removed targets or a combinations of added and removed targets.");
            }
            return new Targets(this.newTargets, this.addedTargets, this.removedTargets);
        }
    }
}

