/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.repo;

import io.getstream.client.exception.StreamClientException;
import io.getstream.client.model.activities.AggregatedActivity;
import io.getstream.client.model.activities.BaseActivity;
import io.getstream.client.model.activities.NotificationActivity;
import io.getstream.client.model.activities.UpdateTargetResponse;
import io.getstream.client.model.beans.FeedFollow;
import io.getstream.client.model.beans.FollowMany;
import io.getstream.client.model.beans.MarkedActivity;
import io.getstream.client.model.beans.StreamActivitiesResponse;
import io.getstream.client.model.beans.StreamResponse;
import io.getstream.client.model.beans.Targets;
import io.getstream.client.model.beans.UnfollowMany;
import io.getstream.client.model.feeds.BaseFeed;
import io.getstream.client.model.filters.FeedFilter;
import java.io.IOException;
import java.util.List;

public interface StreamRepository {
    public void deleteActivityById(BaseFeed var1, String var2) throws IOException, StreamClientException;

    public void deleteActivityByForeignId(BaseFeed var1, String var2) throws IOException, StreamClientException;

    public String getReadOnlyToken(BaseFeed var1);

    public void follow(BaseFeed var1, String var2, int var3) throws StreamClientException, IOException;

    public void followMany(BaseFeed var1, FollowMany var2, int var3) throws StreamClientException, IOException;

    public void unfollowMany(BaseFeed var1, UnfollowMany var2) throws StreamClientException, IOException;

    public void unfollow(BaseFeed var1, String var2, boolean var3) throws StreamClientException, IOException;

    public List<FeedFollow> getFollowing(BaseFeed var1, FeedFilter var2) throws StreamClientException, IOException;

    public List<FeedFollow> getFollowers(BaseFeed var1, FeedFilter var2) throws StreamClientException, IOException;

    public <T extends BaseActivity> StreamResponse<T> getActivities(BaseFeed var1, Class<T> var2, FeedFilter var3) throws IOException, StreamClientException;

    public <T extends BaseActivity> T addActivity(BaseFeed var1, T var2) throws StreamClientException, IOException;

    public <T extends BaseActivity> StreamActivitiesResponse<T> addActivities(BaseFeed var1, Class<T> var2, List<T> var3) throws StreamClientException, IOException;

    public <T extends BaseActivity> StreamActivitiesResponse<T> updateActivities(BaseFeed var1, Class<T> var2, List<T> var3) throws IOException, StreamClientException;

    public <T extends BaseActivity> UpdateTargetResponse<T> updateToTargets(BaseFeed var1, BaseActivity var2, Targets var3) throws StreamClientException, IOException;

    public <T extends BaseActivity> T addActivityToMany(List<String> var1, T var2) throws StreamClientException, IOException;

    public <T extends BaseActivity> StreamResponse<AggregatedActivity<T>> getAggregatedActivities(BaseFeed var1, Class<T> var2, FeedFilter var3) throws IOException, StreamClientException;

    public <T extends BaseActivity> StreamResponse<NotificationActivity<T>> getNotificationActivities(BaseFeed var1, Class<T> var2, FeedFilter var3) throws IOException, StreamClientException;

    public <T extends BaseActivity> StreamResponse<NotificationActivity<T>> getNotificationActivities(BaseFeed var1, Class<T> var2, FeedFilter var3, boolean var4, boolean var5) throws IOException, StreamClientException;

    public <T extends BaseActivity> StreamResponse<NotificationActivity<T>> getNotificationActivities(BaseFeed var1, Class<T> var2, FeedFilter var3, MarkedActivity var4, MarkedActivity var5) throws IOException, StreamClientException;

    public String getToken(BaseFeed var1);

    public void shutdown() throws IOException;
}

