/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.util;

import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoUtil {
    private static final Logger LOG = LoggerFactory.getLogger(InfoUtil.class);
    public static final String VERSION = "version";
    public static final String STREAM_JAVA_INFO = "/stream-java.info";

    public static Properties getProperties() {
        Properties properties = new Properties();
        try (InputStream inputStream = Resources.asByteSource((URL)InfoUtil.class.getResource(STREAM_JAVA_INFO)).openStream();){
            properties.load(inputStream);
        }
        catch (IOException e) {
            LOG.error("Failed to read the properties file /stream-java.infofrom the jar", (Throwable)e);
        }
        return properties;
    }
}

