/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client;

import io.getstream.core.StreamFiles;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.Token;
import io.getstream.core.utils.Auth;
import java.io.File;
import java.net.URL;
import java.util.concurrent.CompletableFuture;

public class FileStorageClient {
    private final String secret;
    private final StreamFiles files;

    FileStorageClient(String secret, StreamFiles files) {
        this.secret = secret;
        this.files = files;
    }

    public CompletableFuture<URL> upload(String fileName, byte[] content) throws StreamException {
        Token token = Auth.buildFilesToken(this.secret, Auth.TokenAction.WRITE);
        return this.files.upload(token, fileName, content);
    }

    public CompletableFuture<URL> upload(File content) throws StreamException {
        Token token = Auth.buildFilesToken(this.secret, Auth.TokenAction.WRITE);
        return this.files.upload(token, content);
    }

    public CompletableFuture<Void> delete(URL url) throws StreamException {
        Token token = Auth.buildFilesToken(this.secret, Auth.TokenAction.DELETE);
        return this.files.delete(token, url);
    }
}

