/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.cloud;

import io.getstream.cloud.CloudAggregatedFeed;
import io.getstream.cloud.CloudClient;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.models.Activity;
import io.getstream.core.models.EnrichedActivity;
import io.getstream.core.models.FeedID;
import io.getstream.core.models.NotificationGroup;
import io.getstream.core.options.ActivityMarker;
import io.getstream.core.options.EnrichmentFlags;
import io.getstream.core.options.Filter;
import io.getstream.core.options.Pagination;
import io.getstream.core.utils.DefaultOptions;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class CloudNotificationFeed
extends CloudAggregatedFeed {
    CloudNotificationFeed(CloudClient client, FeedID id) {
        super(client, id);
    }

    public CompletableFuture<List<NotificationGroup<Activity>>> getActivities() throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public CompletableFuture<List<NotificationGroup<Activity>>> getActivities(Pagination pagination) throws StreamException {
        return this.getActivities(pagination, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public CompletableFuture<List<NotificationGroup<Activity>>> getActivities(Filter filter) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_PAGINATION, filter, DefaultOptions.DEFAULT_MARKER);
    }

    public CompletableFuture<List<NotificationGroup<Activity>>> getActivities(ActivityMarker marker) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, marker);
    }

    public CompletableFuture<List<NotificationGroup<Activity>>> getActivities(Filter filter, ActivityMarker marker) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_PAGINATION, filter, marker);
    }

    public CompletableFuture<List<NotificationGroup<Activity>>> getActivities(Pagination pagination, ActivityMarker marker) throws StreamException {
        return this.getActivities(pagination, DefaultOptions.DEFAULT_FILTER, marker);
    }

    CompletableFuture<List<NotificationGroup<Activity>>> getActivities(Pagination pagination, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getClient().getActivities(this.getID(), pagination, filter, marker).thenApply(response -> {
            try {
                return (List)Serialization.deserializeContainer(response, NotificationGroup.class, Activity.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getCustomActivities(Class<T> type) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getCustomActivities(Class<T> type, Pagination pagination) throws StreamException {
        return this.getCustomActivities(type, pagination, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getCustomActivities(Class<T> type, Filter filter) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, filter, DefaultOptions.DEFAULT_MARKER);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getCustomActivities(Class<T> type, ActivityMarker marker) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, marker);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getCustomActivities(Class<T> type, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, filter, marker);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getCustomActivities(Class<T> type, Pagination pagination, ActivityMarker marker) throws StreamException {
        return this.getCustomActivities(type, pagination, DefaultOptions.DEFAULT_FILTER, marker);
    }

    <T> CompletableFuture<List<NotificationGroup<T>>> getCustomActivities(Class<T> type, Pagination pagination, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getClient().getActivities(this.getID(), pagination, filter, marker).thenApply(response -> {
            try {
                return (List)Serialization.deserializeContainer(response, NotificationGroup.class, type);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities() throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(Pagination pagination) throws StreamException {
        return this.getEnrichedActivities(pagination, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(Pagination pagination, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(pagination, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(Filter filter) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, filter, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(Filter filter, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, filter, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(ActivityMarker marker) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, marker, flags);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(Filter filter, ActivityMarker marker) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, filter, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(Filter filter, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, filter, marker, flags);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(Pagination pagination, ActivityMarker marker) throws StreamException {
        return this.getEnrichedActivities(pagination, DefaultOptions.DEFAULT_FILTER, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(Pagination pagination, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(pagination, DefaultOptions.DEFAULT_FILTER, marker, flags);
    }

    CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(Pagination pagination, Filter filter, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getClient().getEnrichedActivities(this.getID(), pagination, filter, marker, flags).thenApply(response -> {
            try {
                return (List)Serialization.deserializeContainer(response, NotificationGroup.class, EnrichedActivity.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, Pagination pagination) throws StreamException {
        return this.getEnrichedCustomActivities(type, pagination, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, Pagination pagination, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, pagination, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, Filter filter) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, filter, DefaultOptions.DEFAULT_MARKER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, Filter filter, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, filter, DefaultOptions.DEFAULT_MARKER, flags);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, ActivityMarker marker) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, marker, flags);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, filter, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, Filter filter, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, filter, marker, flags);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, Pagination pagination, ActivityMarker marker) throws StreamException {
        return this.getEnrichedCustomActivities(type, pagination, DefaultOptions.DEFAULT_FILTER, marker, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, Pagination pagination, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, pagination, DefaultOptions.DEFAULT_FILTER, marker, flags);
    }

    <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, Pagination pagination, Filter filter, ActivityMarker marker, EnrichmentFlags flags) throws StreamException {
        return this.getClient().getEnrichedActivities(this.getID(), pagination, filter, marker, flags).thenApply(response -> {
            try {
                return (List)Serialization.deserializeContainer(response, NotificationGroup.class, type);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }
}

