/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.getstream.core.models.Content;
import io.getstream.core.models.Feature;
import io.getstream.core.models.UserData;
import io.getstream.core.utils.Serialization;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
public class Engagement {
    private final String feedID;
    private final UserData userData;
    private final String label;
    private final Content content;
    private final Integer boost;
    private final Integer position;
    private final String location;
    private final List<Feature> features;
    private final Date trackedAt;

    private Engagement(Builder builder) {
        this.label = builder.label;
        this.content = builder.content;
        this.boost = builder.boost;
        this.position = builder.position;
        this.feedID = builder.feedID;
        this.location = builder.location;
        this.userData = builder.userData;
        this.features = builder.features;
        this.trackedAt = builder.trackedAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLabel() {
        return this.label;
    }

    public Content getContent() {
        return this.content;
    }

    public int getBoost() {
        return this.boost;
    }

    public int getPosition() {
        return this.position;
    }

    @JsonProperty(value="feed_id")
    public String getFeedID() {
        return this.feedID;
    }

    public String getLocation() {
        return this.location;
    }

    @JsonProperty(value="user_data")
    public UserData getUserData() {
        return this.userData;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    @JsonProperty(value="tracked_at")
    public Date getTrackedAt() {
        return this.trackedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Engagement that = (Engagement)o;
        return Objects.equals(this.label, that.label) && Objects.equals(this.content, that.content) && Objects.equals(this.boost, that.boost) && Objects.equals(this.position, that.position) && Objects.equals(this.feedID, that.feedID) && Objects.equals(this.location, that.location) && Objects.equals(this.userData, that.userData) && Objects.equals(this.features, that.features) && Objects.equals(this.trackedAt, that.trackedAt);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.content, this.boost, this.position, this.feedID, this.location, this.userData, this.features, this.trackedAt);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("label", (Object)this.label).add("content", (Object)this.content).add("boost", (Object)this.boost).add("position", (Object)this.position).add("feedID", (Object)this.feedID).add("location", (Object)this.location).add("userData", (Object)this.userData).add("features", this.features).add("trackedAt", (Object)this.trackedAt).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private String label;
        private Content content;
        private Integer boost;
        private Integer position;
        private String feedID;
        private String location;
        private UserData userData;
        private List features;
        private Date trackedAt;

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder content(Content content) {
            this.content = content;
            return this;
        }

        public Builder boost(int boost) {
            this.boost = boost;
            return this;
        }

        public Builder position(int position) {
            this.position = position;
            return this;
        }

        @JsonProperty(value="feed_id")
        public Builder feedID(String feedID) {
            this.feedID = feedID;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        @JsonProperty(value="user_data")
        public Builder userData(UserData userData) {
            this.userData = userData;
            return this;
        }

        public Builder features(List features) {
            this.features = features;
            return this;
        }

        @JsonProperty(value="tracked_at")
        public Builder trackedAt(Date trackedAt) {
            this.trackedAt = trackedAt;
            return this;
        }

        @JsonIgnore
        public Builder fromEngagement(Engagement engagement) {
            this.label = engagement.label;
            this.content = engagement.content;
            this.boost = engagement.boost;
            this.position = engagement.position;
            this.feedID = engagement.feedID;
            this.location = engagement.location;
            this.userData = engagement.userData;
            this.features = engagement.features;
            this.trackedAt = engagement.trackedAt;
            return this;
        }

        @JsonIgnore
        public <T> Builder fromCustomEngagement(T custom) {
            return this.fromEngagement(Serialization.convert(custom, Engagement.class));
        }

        public Engagement build() {
            Preconditions.checkNotNull((Object)this.feedID, (Object)"Engagement 'feedID' field required");
            Preconditions.checkNotNull((Object)this.userData, (Object)"Engagement 'userData' field required");
            Preconditions.checkNotNull((Object)this.label, (Object)"Engagement 'label' field required");
            Preconditions.checkNotNull((Object)this.content, (Object)"Engagement 'content' field required");
            return new Engagement(this);
        }
    }
}

