/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.getstream.core.models.Content;
import io.getstream.core.models.Feature;
import io.getstream.core.models.UserData;
import io.getstream.core.utils.Serialization;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
public class Impression {
    private final String feedID;
    private final UserData userData;
    private final List<Content> contentList;
    private final String position;
    private final String location;
    private final List<Feature> features;
    private final Date trackedAt;

    private Impression(Builder builder) {
        this.position = builder.position;
        this.feedID = builder.feedID;
        this.location = builder.location;
        this.userData = builder.userData;
        this.contentList = builder.contentList;
        this.features = builder.features;
        this.trackedAt = builder.trackedAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPosition() {
        return this.position;
    }

    @JsonProperty(value="feed_id")
    public String getFeedID() {
        return this.feedID;
    }

    public String getLocation() {
        return this.location;
    }

    @JsonProperty(value="user_data")
    public UserData getUserData() {
        return this.userData;
    }

    @JsonProperty(value="content_list")
    public List<Content> getContentList() {
        return this.contentList;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    @JsonProperty(value="tracked_at")
    public Date getTrackedAt() {
        return this.trackedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Impression that = (Impression)o;
        return Objects.equals(this.position, that.position) && Objects.equals(this.feedID, that.feedID) && Objects.equals(this.location, that.location) && Objects.equals(this.userData, that.userData) && Objects.equals(this.contentList, that.contentList) && Objects.equals(this.features, that.features) && Objects.equals(this.trackedAt, that.trackedAt);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.feedID, this.location, this.userData, this.contentList, this.features, this.trackedAt);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("position", (Object)this.position).add("feedID", (Object)this.feedID).add("location", (Object)this.location).add("userData", (Object)this.userData).add("contentList", this.contentList).add("features", this.features).add("trackedAt", (Object)this.trackedAt).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private String position;
        private String feedID;
        private String location;
        private UserData userData;
        private List<Content> contentList;
        private List features;
        private Date trackedAt;

        public Builder position(String position) {
            this.position = position;
            return this;
        }

        @JsonProperty(value="feed_id")
        public Builder feedID(String feedID) {
            this.feedID = feedID;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        @JsonProperty(value="user_data")
        public Builder userData(UserData userData) {
            this.userData = userData;
            return this;
        }

        @JsonProperty(value="user_data")
        public Builder contentList(List<Content> contentList) {
            this.contentList = contentList;
            return this;
        }

        public Builder features(List features) {
            this.features = features;
            return this;
        }

        @JsonProperty(value="tracked_at")
        public Builder trackedAt(Date trackedAt) {
            this.trackedAt = trackedAt;
            return this;
        }

        @JsonIgnore
        public Builder fromImpression(Impression impression) {
            this.position = impression.position;
            this.feedID = impression.feedID;
            this.location = impression.location;
            this.userData = impression.userData;
            this.contentList = impression.contentList;
            this.features = impression.features;
            this.trackedAt = impression.trackedAt;
            return this;
        }

        @JsonIgnore
        public <T> Builder fromCustomImpression(T custom) {
            return this.fromImpression(Serialization.convert(custom, Impression.class));
        }

        public Impression build() {
            Preconditions.checkNotNull((Object)this.feedID, (Object)"Impression 'feedID' field required");
            Preconditions.checkNotNull((Object)this.userData, (Object)"Impression 'userData' field required");
            return new Impression(this);
        }
    }
}

