/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.options;

import com.google.common.collect.Lists;
import io.getstream.core.http.Request;
import io.getstream.core.options.RequestOption;
import java.util.List;

public final class EnrichmentFlags
implements RequestOption {
    private final List<OpEntry> ops = Lists.newArrayList();

    public EnrichmentFlags withOwnReactions() {
        this.ops.add(new OpEntry(OpType.OWN_REACTIONS, true));
        return this;
    }

    public EnrichmentFlags withRecentReactions() {
        this.ops.add(new OpEntry(OpType.RECENT_REACTIONS, true));
        return this;
    }

    public EnrichmentFlags withReactionCounts() {
        this.ops.add(new OpEntry(OpType.REACTION_COUNTS, true));
        return this;
    }

    public EnrichmentFlags withOwnChildren() {
        this.ops.add(new OpEntry(OpType.OWN_CHILDREN, true));
        return this;
    }

    @Override
    public void apply(Request.Builder builder) {
        for (OpEntry op : this.ops) {
            builder.addQueryParameter(op.type, Boolean.toString(op.value));
        }
    }

    private static final class OpEntry {
        String type;
        boolean value;

        OpEntry(OpType type, boolean value) {
            this.type = type.toString();
            this.value = value;
        }
    }

    static enum OpType {
        OWN_CHILDREN("with_own_children"),
        OWN_REACTIONS("with_own_reactions"),
        REACTION_COUNTS("with_reaction_counts"),
        RECENT_REACTIONS("with_recent_reactions");

        private String operator;

        private OpType(String operator) {
            this.operator = operator;
        }

        public String toString() {
            return this.operator;
        }
    }
}

