/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client;

import io.getstream.client.Client;
import io.getstream.client.Feed;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.models.Activity;
import io.getstream.core.models.EnrichedActivity;
import io.getstream.core.models.FeedID;
import io.getstream.core.options.EnrichmentFlags;
import io.getstream.core.options.Filter;
import io.getstream.core.options.Pagination;
import io.getstream.core.options.Ranking;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.DefaultOptions;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class FlatFeed
extends Feed {
    FlatFeed(Client client, FeedID id) {
        super(client, id);
    }

    public CompletableFuture<List<Activity>> getActivities() throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, null);
    }

    public CompletableFuture<List<Activity>> getActivities(String ranking) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, ranking);
    }

    public CompletableFuture<List<Activity>> getActivities(Filter filter) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_PAGINATION, filter, null);
    }

    public CompletableFuture<List<Activity>> getActivities(Pagination pagination) throws StreamException {
        return this.getActivities(pagination, DefaultOptions.DEFAULT_FILTER, null);
    }

    public CompletableFuture<List<Activity>> getActivities(Filter filter, String ranking) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_PAGINATION, filter, ranking);
    }

    public CompletableFuture<List<Activity>> getActivities(Pagination pagination, String ranking) throws StreamException {
        return this.getActivities(pagination, DefaultOptions.DEFAULT_FILTER, ranking);
    }

    CompletableFuture<List<Activity>> getActivities(Pagination pagination, Filter filter, String ranking) throws StreamException {
        RequestOption[] requestOptionArray;
        if (ranking == null) {
            RequestOption[] requestOptionArray2 = new RequestOption[3];
            requestOptionArray2[0] = pagination;
            requestOptionArray2[1] = filter;
            requestOptionArray = requestOptionArray2;
            requestOptionArray2[2] = DefaultOptions.DEFAULT_MARKER;
        } else {
            RequestOption[] requestOptionArray3 = new RequestOption[4];
            requestOptionArray3[0] = pagination;
            requestOptionArray3[1] = filter;
            requestOptionArray3[2] = DefaultOptions.DEFAULT_MARKER;
            requestOptionArray = requestOptionArray3;
            requestOptionArray3[3] = new Ranking(ranking);
        }
        RequestOption[] options = requestOptionArray;
        return this.getClient().getActivities(this.getID(), options).thenApply(response -> {
            try {
                return Serialization.deserializeContainer(response, Activity.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, null);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, String ranking) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, ranking);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Filter filter) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, filter, null);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Pagination pagination) throws StreamException {
        return this.getCustomActivities(type, pagination, DefaultOptions.DEFAULT_FILTER, null);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Pagination pagination, String ranking) throws StreamException {
        return this.getCustomActivities(type, pagination, DefaultOptions.DEFAULT_FILTER, ranking);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Filter filter, String ranking) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, filter, ranking);
    }

    <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Pagination pagination, Filter filter, String ranking) throws StreamException {
        RequestOption[] requestOptionArray;
        if (ranking == null) {
            RequestOption[] requestOptionArray2 = new RequestOption[3];
            requestOptionArray2[0] = pagination;
            requestOptionArray2[1] = filter;
            requestOptionArray = requestOptionArray2;
            requestOptionArray2[2] = DefaultOptions.DEFAULT_MARKER;
        } else {
            RequestOption[] requestOptionArray3 = new RequestOption[4];
            requestOptionArray3[0] = pagination;
            requestOptionArray3[1] = filter;
            requestOptionArray3[2] = DefaultOptions.DEFAULT_MARKER;
            requestOptionArray = requestOptionArray3;
            requestOptionArray3[3] = new Ranking(ranking);
        }
        RequestOption[] options = requestOptionArray;
        return this.getClient().getActivities(this.getID(), options).thenApply(response -> {
            try {
                return Serialization.deserializeContainer(response, type);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities() throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, flags, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(String ranking) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, flags, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Filter filter) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, filter, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Filter filter, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, filter, flags, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Pagination pagination) throws StreamException {
        return this.getEnrichedActivities(pagination, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Pagination pagination, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(pagination, DefaultOptions.DEFAULT_FILTER, flags, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Filter filter, String ranking) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, filter, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Filter filter, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, filter, flags, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Pagination pagination, String ranking) throws StreamException {
        return this.getEnrichedActivities(pagination, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Pagination pagination, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedActivities(pagination, DefaultOptions.DEFAULT_FILTER, flags, ranking);
    }

    CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Pagination pagination, Filter filter, EnrichmentFlags flags, String ranking) throws StreamException {
        RequestOption[] requestOptionArray;
        if (ranking == null) {
            RequestOption[] requestOptionArray2 = new RequestOption[4];
            requestOptionArray2[0] = pagination;
            requestOptionArray2[1] = filter;
            requestOptionArray2[2] = flags;
            requestOptionArray = requestOptionArray2;
            requestOptionArray2[3] = DefaultOptions.DEFAULT_MARKER;
        } else {
            RequestOption[] requestOptionArray3 = new RequestOption[5];
            requestOptionArray3[0] = pagination;
            requestOptionArray3[1] = filter;
            requestOptionArray3[2] = flags;
            requestOptionArray3[3] = DefaultOptions.DEFAULT_MARKER;
            requestOptionArray = requestOptionArray3;
            requestOptionArray3[4] = new Ranking(ranking);
        }
        RequestOption[] options = requestOptionArray;
        return this.getClient().getEnrichedActivities(this.getID(), options).thenApply(response -> {
            try {
                return Serialization.deserializeContainer(response, EnrichedActivity.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, flags, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, flags, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Filter filter) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, filter, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Filter filter, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, filter, flags, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Pagination pagination) throws StreamException {
        return this.getEnrichedCustomActivities(type, pagination, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Pagination pagination, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, pagination, DefaultOptions.DEFAULT_FILTER, flags, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Pagination pagination, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, pagination, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Pagination pagination, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, pagination, DefaultOptions.DEFAULT_FILTER, flags, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Filter filter, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, filter, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Filter filter, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, filter, flags, ranking);
    }

    <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Pagination pagination, Filter filter, EnrichmentFlags flags, String ranking) throws StreamException {
        RequestOption[] requestOptionArray;
        if (ranking == null) {
            RequestOption[] requestOptionArray2 = new RequestOption[4];
            requestOptionArray2[0] = pagination;
            requestOptionArray2[1] = filter;
            requestOptionArray2[2] = flags;
            requestOptionArray = requestOptionArray2;
            requestOptionArray2[3] = DefaultOptions.DEFAULT_MARKER;
        } else {
            RequestOption[] requestOptionArray3 = new RequestOption[5];
            requestOptionArray3[0] = pagination;
            requestOptionArray3[1] = filter;
            requestOptionArray3[2] = flags;
            requestOptionArray3[3] = DefaultOptions.DEFAULT_MARKER;
            requestOptionArray = requestOptionArray3;
            requestOptionArray3[4] = new Ranking(ranking);
        }
        RequestOption[] options = requestOptionArray;
        return this.getClient().getActivities(this.getID(), options).thenApply(response -> {
            try {
                return Serialization.deserializeContainer(response, type);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }
}

