/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.getstream.core.models.Group;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NotificationGroup<T>
extends Group<T> {
    private final boolean seen;
    private final boolean read;

    @JsonCreator
    public NotificationGroup(@JsonProperty(value="group") String group, @JsonProperty(value="activities") List<T> activities, @JsonProperty(value="actor_count") int actorCount, @JsonProperty(value="created_at") @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.S", timezone="UTC") Date createdAt, @JsonProperty(value="updated_at") @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.S", timezone="UTC") Date updatedAt, @JsonProperty(value="is_seen") boolean isSeen, @JsonProperty(value="is_read") boolean isRead) {
        super(group, activities, actorCount, createdAt, updatedAt);
        this.seen = isSeen;
        this.read = isRead;
    }

    public boolean isSeen() {
        return this.seen;
    }

    public boolean isRead() {
        return this.read;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NotificationGroup that = (NotificationGroup)o;
        return this.seen == that.seen && this.read == that.read;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.seen, this.read);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("activities", this.getActivities()).add("actorCount", this.getActorCount()).add("createdAt", (Object)this.getCreatedAt()).add("updatedAt", (Object)this.getUpdatedAt()).add("isSeen", this.seen).add("isRead", this.read).toString();
    }
}

