/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.options;

import com.google.common.base.Preconditions;
import io.getstream.core.http.Request;
import io.getstream.core.options.RequestOption;
import java.util.Arrays;

public final class Crop
implements RequestOption {
    private final Type[] types;
    private final int width;
    private final int height;

    public Crop(int width, int height, Type ... types) {
        Preconditions.checkNotNull((Object)types, (Object)"Missing crop type");
        Preconditions.checkArgument((types.length > 0 ? 1 : 0) != 0, (Object)"Missing crop type");
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (Object)"Width should be a positive number");
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"Height should be a positive number");
        this.types = types;
        this.width = width;
        this.height = height;
    }

    public Crop(int width, int height) {
        this(width, height, Type.CENTER);
    }

    public Type[] getTypes() {
        return this.types;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public void apply(Request.Builder builder) {
        CharSequence[] cropTypes = (String[])Arrays.stream(this.types).map(type -> type.toString()).toArray(String[]::new);
        String types = String.join((CharSequence)",", cropTypes);
        builder.addQueryParameter("crop", types);
        builder.addQueryParameter("w", Integer.toString(this.width));
        builder.addQueryParameter("h", Integer.toString(this.height));
    }

    public static enum Type {
        TOP("top"),
        BOTTOM("bottom"),
        LEFT("left"),
        RIGHT("right"),
        CENTER("center");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

