/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.options;

import com.google.common.base.Preconditions;
import io.getstream.core.http.Request;
import io.getstream.core.options.RequestOption;

public final class Resize
implements RequestOption {
    private final Type type;
    private final int width;
    private final int height;

    public Resize(int width, int height, Type type) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"Missing resize type");
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (Object)"Width should be a positive number");
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"Height should be a positive number");
        this.type = type;
        this.width = width;
        this.height = height;
    }

    public Resize(int width, int height) {
        this(width, height, Type.CLIP);
    }

    public Type getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public void apply(Request.Builder builder) {
        builder.addQueryParameter("resize", this.type.toString());
        builder.addQueryParameter("w", Integer.toString(this.width));
        builder.addQueryParameter("h", Integer.toString(this.height));
    }

    public static enum Type {
        CLIP("clip"),
        CROP("crop"),
        SCALE("scale"),
        FILL("fill");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

