/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client;

import com.google.common.collect.Iterables;
import io.getstream.client.CollectionsClient$$Lambda$1;
import io.getstream.client.CollectionsClient$$Lambda$2;
import io.getstream.client.CollectionsClient$$Lambda$3;
import io.getstream.client.CollectionsClient$$Lambda$4;
import io.getstream.client.CollectionsClient$$Lambda$5;
import io.getstream.client.CollectionsClient$$Lambda$6;
import io.getstream.client.CollectionsClient$$Lambda$7;
import io.getstream.client.CollectionsClient$$Lambda$8;
import io.getstream.client.CollectionsClient$$Lambda$9;
import io.getstream.core.StreamCollections;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.Token;
import io.getstream.core.models.CollectionData;
import io.getstream.core.utils.Auth;
import io.getstream.core.utils.Serialization;
import io.getstream.core.utils.Streams;
import java.util.Collection;
import java.util.List;
import java8.util.J8Arrays;
import java8.util.concurrent.CompletableFuture;
import java8.util.stream.Collectors;
import java8.util.stream.StreamSupport;

public final class CollectionsClient {
    private final String secret;
    private final StreamCollections collections;

    CollectionsClient(String secret, StreamCollections collections) {
        this.secret = secret;
        this.collections = collections;
    }

    public <T> CompletableFuture<T> addCustom(String collection, T item) throws StreamException {
        return this.addCustom(null, collection, item);
    }

    public <T> CompletableFuture<T> addCustom(String userID, String collection, T item) throws StreamException {
        return this.add(userID, collection, Serialization.convert(item, CollectionData.class)).thenApply(CollectionsClient$$Lambda$1.lambdaFactory$(item));
    }

    public CompletableFuture<CollectionData> add(String collection, CollectionData item) throws StreamException {
        return this.add(null, collection, item);
    }

    public CompletableFuture<CollectionData> add(String userID, String collection, CollectionData item) throws StreamException {
        Token token = Auth.buildCollectionsToken(this.secret, Auth.TokenAction.WRITE);
        return this.collections.add(token, userID, collection, item);
    }

    public <T> CompletableFuture<T> updateCustom(String collection, T item) throws StreamException {
        return this.updateCustom(null, collection, item);
    }

    public <T> CompletableFuture<T> updateCustom(String userID, String collection, T item) throws StreamException {
        return this.update(userID, collection, Serialization.convert(item, CollectionData.class)).thenApply(CollectionsClient$$Lambda$2.lambdaFactory$(item));
    }

    public CompletableFuture<CollectionData> update(String collection, CollectionData item) throws StreamException {
        return this.update(null, collection, item);
    }

    public CompletableFuture<CollectionData> update(String userID, String collection, CollectionData item) throws StreamException {
        Token token = Auth.buildCollectionsToken(this.secret, Auth.TokenAction.WRITE);
        return this.collections.update(token, userID, collection, item);
    }

    public <T> CompletableFuture<Void> upsertCustom(String collection, Iterable<T> items) throws StreamException {
        CollectionData[] custom = (CollectionData[])Streams.stream(items).map(CollectionsClient$$Lambda$3.lambdaFactory$()).toArray(CollectionsClient$$Lambda$4.lambdaFactory$());
        return this.upsert(collection, custom);
    }

    public <T> CompletableFuture<Void> upsertCustom(String collection, T ... items) throws StreamException {
        CollectionData[] custom = (CollectionData[])J8Arrays.stream((Object[])items).map(CollectionsClient$$Lambda$5.lambdaFactory$()).toArray(CollectionsClient$$Lambda$6.lambdaFactory$());
        return this.upsert(collection, custom);
    }

    public CompletableFuture<Void> upsert(String collection, Iterable<CollectionData> items) throws StreamException {
        return this.upsert(collection, (CollectionData[])Iterables.toArray(items, CollectionData.class));
    }

    public CompletableFuture<Void> upsert(String collection, CollectionData ... items) throws StreamException {
        Token token = Auth.buildCollectionsToken(this.secret, Auth.TokenAction.WRITE);
        return this.collections.upsert(token, collection, items);
    }

    public <T> CompletableFuture<T> getCustom(Class<T> type, String collection, String id) throws StreamException {
        return this.get(collection, id).thenApply(CollectionsClient$$Lambda$7.lambdaFactory$(type));
    }

    public CompletableFuture<CollectionData> get(String collection, String id) throws StreamException {
        Token token = Auth.buildCollectionsToken(this.secret, Auth.TokenAction.READ);
        return this.collections.get(token, collection, id);
    }

    public <T> CompletableFuture<List<T>> selectCustom(Class<T> type, String collection, Iterable<String> ids) throws StreamException {
        return this.selectCustom(type, collection, (String[])Iterables.toArray(ids, String.class));
    }

    public <T> CompletableFuture<List<T>> selectCustom(Class<T> type, String collection, String ... ids) throws StreamException {
        return this.select(collection, ids).thenApply(CollectionsClient$$Lambda$8.lambdaFactory$(type));
    }

    public CompletableFuture<List<CollectionData>> select(String collection, Iterable<String> ids) throws StreamException {
        return this.select(collection, (String[])Iterables.toArray(ids, String.class));
    }

    public CompletableFuture<List<CollectionData>> select(String collection, String ... ids) throws StreamException {
        Token token = Auth.buildCollectionsToken(this.secret, Auth.TokenAction.READ);
        return this.collections.select(token, collection, ids);
    }

    public CompletableFuture<Void> delete(String collection, String id) throws StreamException {
        Token token = Auth.buildCollectionsToken(this.secret, Auth.TokenAction.DELETE);
        return this.collections.delete(token, collection, id);
    }

    public CompletableFuture<Void> deleteMany(String collection, Iterable<String> ids) throws StreamException {
        return this.deleteMany(collection, (String[])Iterables.toArray(ids, String.class));
    }

    public CompletableFuture<Void> deleteMany(String collection, String ... ids) throws StreamException {
        Token token = Auth.buildCollectionsToken(this.secret, Auth.TokenAction.DELETE);
        return this.collections.deleteMany(token, collection, ids);
    }

    static /* synthetic */ List lambda$selectCustom$8(Class type, List data) {
        return (List)StreamSupport.stream((Collection)data).map(CollectionsClient$$Lambda$9.lambdaFactory$(type)).collect(Collectors.toList());
    }

    static /* synthetic */ Object lambda$selectCustom$7(Class type, CollectionData item) {
        return Serialization.convert(item, type);
    }

    static /* synthetic */ Object lambda$getCustom$6(Class type, CollectionData data) {
        return Serialization.convert(data, type);
    }

    static /* synthetic */ CollectionData[] lambda$upsertCustom$5(int x$0) {
        return new CollectionData[x$0];
    }

    static /* synthetic */ CollectionData lambda$upsertCustom$4(Object item) {
        return CollectionData.buildFrom(item);
    }

    static /* synthetic */ CollectionData[] lambda$upsertCustom$3(int x$0) {
        return new CollectionData[x$0];
    }

    static /* synthetic */ CollectionData lambda$upsertCustom$2(Object item) {
        return CollectionData.buildFrom(item);
    }

    static /* synthetic */ Object lambda$updateCustom$1(Object item, CollectionData data) {
        return Serialization.convert(data, item.getClass());
    }

    static /* synthetic */ Object lambda$addCustom$0(Object item, CollectionData data) {
        return Serialization.convert(data, item.getClass());
    }
}

