/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import io.getstream.core.StreamBatch$$Lambda$1;
import io.getstream.core.StreamBatch$$Lambda$10;
import io.getstream.core.StreamBatch$$Lambda$11;
import io.getstream.core.StreamBatch$$Lambda$12;
import io.getstream.core.StreamBatch$$Lambda$13;
import io.getstream.core.StreamBatch$$Lambda$14;
import io.getstream.core.StreamBatch$$Lambda$15;
import io.getstream.core.StreamBatch$$Lambda$16;
import io.getstream.core.StreamBatch$$Lambda$17;
import io.getstream.core.StreamBatch$$Lambda$18;
import io.getstream.core.StreamBatch$$Lambda$2;
import io.getstream.core.StreamBatch$$Lambda$3;
import io.getstream.core.StreamBatch$$Lambda$4;
import io.getstream.core.StreamBatch$$Lambda$5;
import io.getstream.core.StreamBatch$$Lambda$6;
import io.getstream.core.StreamBatch$$Lambda$7;
import io.getstream.core.StreamBatch$$Lambda$8;
import io.getstream.core.StreamBatch$$Lambda$9;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.HTTPClient;
import io.getstream.core.http.Response;
import io.getstream.core.http.Token;
import io.getstream.core.models.Activity;
import io.getstream.core.models.EnrichedActivity;
import io.getstream.core.models.FeedID;
import io.getstream.core.models.FollowRelation;
import io.getstream.core.models.ForeignIDTimePair;
import io.getstream.core.models.UnfollowOperation;
import io.getstream.core.options.CustomQueryParameter;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.Request;
import io.getstream.core.utils.Routes;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import java8.util.J8Arrays;
import java8.util.concurrent.CompletableFuture;
import java8.util.concurrent.CompletionException;

public final class StreamBatch {
    private final String key;
    private final URL baseURL;
    private final HTTPClient httpClient;

    public StreamBatch(String key, URL baseURL, HTTPClient httpClient) {
        this.key = key;
        this.baseURL = baseURL;
        this.httpClient = httpClient;
    }

    public CompletableFuture<Void> addToMany(Token token, Activity activity, FeedID ... feeds) throws StreamException {
        Preconditions.checkNotNull((Object)activity, (Object)"Missing activity");
        Preconditions.checkNotNull((Object)feeds, (Object)"No feeds to add to");
        Preconditions.checkArgument((feeds.length > 0 ? 1 : 0) != 0, (Object)"No feeds to add to");
        final Activity data = activity;
        final String[] feedIDs = (String[])J8Arrays.stream((Object[])feeds).map(StreamBatch$$Lambda$1.lambdaFactory$()).toArray(StreamBatch$$Lambda$2.lambdaFactory$());
        try {
            byte[] payload = Serialization.toJSON(new Object(){
                public final Activity activity;
                public final String[] feeds;
                {
                    this.activity = data;
                    this.feeds = feedIDs;
                }
            });
            URL url = Routes.buildAddToManyURL(this.baseURL);
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0])).thenApply(StreamBatch$$Lambda$3.lambdaFactory$());
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> followMany(Token token, int activityCopyLimit, FollowRelation ... follows) throws StreamException {
        Preconditions.checkArgument((activityCopyLimit >= 0 ? 1 : 0) != 0, (Object)"Activity copy limit must be non negative");
        Preconditions.checkNotNull((Object)follows, (Object)"No feeds to follow");
        Preconditions.checkArgument((follows.length > 0 ? 1 : 0) != 0, (Object)"No feeds to follow");
        try {
            byte[] payload = Serialization.toJSON(follows);
            URL url = Routes.buildFollowManyURL(this.baseURL);
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new CustomQueryParameter("activity_copy_limit", Integer.toString(activityCopyLimit)))).thenApply(StreamBatch$$Lambda$4.lambdaFactory$());
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> unfollowMany(Token token, UnfollowOperation ... unfollows) throws StreamException {
        Preconditions.checkNotNull((Object)unfollows, (Object)"No feeds to unfollow");
        Preconditions.checkArgument((unfollows.length > 0 ? 1 : 0) != 0, (Object)"No feeds to unfollow");
        try {
            byte[] payload = Serialization.toJSON(unfollows);
            URL url = Routes.buildUnfollowManyURL(this.baseURL);
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0])).thenApply(StreamBatch$$Lambda$5.lambdaFactory$());
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<List<Activity>> getActivitiesByID(Token token, String ... activityIDs) throws StreamException {
        Preconditions.checkNotNull((Object)activityIDs, (Object)"No activities to get");
        Preconditions.checkArgument((activityIDs.length > 0 ? 1 : 0) != 0, (Object)"No activities to get");
        try {
            URL url = Routes.buildActivitiesURL(this.baseURL);
            return this.httpClient.execute(Request.buildGet(url, this.key, token, new CustomQueryParameter("ids", Joiner.on((String)",").join((Object[])activityIDs)))).thenApply(StreamBatch$$Lambda$6.lambdaFactory$());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivitiesByID(Token token, String ... activityIDs) throws StreamException {
        Preconditions.checkNotNull((Object)activityIDs, (Object)"No activities to get");
        Preconditions.checkArgument((activityIDs.length > 0 ? 1 : 0) != 0, (Object)"No activities to get");
        try {
            URL url = Routes.buildEnrichedActivitiesURL(this.baseURL);
            return this.httpClient.execute(Request.buildGet(url, this.key, token, new CustomQueryParameter("ids", Joiner.on((String)",").join((Object[])activityIDs)))).thenApply(StreamBatch$$Lambda$7.lambdaFactory$());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<List<Activity>> getActivitiesByForeignID(Token token, ForeignIDTimePair ... activityIDTimePairs) throws StreamException {
        Preconditions.checkNotNull((Object)activityIDTimePairs, (Object)"No activities to get");
        Preconditions.checkArgument((activityIDTimePairs.length > 0 ? 1 : 0) != 0, (Object)"No activities to get");
        SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        timestampFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        timestampFormat.setLenient(false);
        Object[] foreignIDs = (String[])J8Arrays.stream((Object[])activityIDTimePairs).map(StreamBatch$$Lambda$8.lambdaFactory$()).toArray(StreamBatch$$Lambda$9.lambdaFactory$());
        Object[] timestamps = (String[])J8Arrays.stream((Object[])activityIDTimePairs).map(StreamBatch$$Lambda$10.lambdaFactory$(timestampFormat)).toArray(StreamBatch$$Lambda$11.lambdaFactory$());
        try {
            URL url = Routes.buildActivitiesURL(this.baseURL);
            RequestOption[] options = new RequestOption[]{new CustomQueryParameter("foreign_ids", Joiner.on((String)",").join(foreignIDs)), new CustomQueryParameter("timestamps", Joiner.on((String)",").join(timestamps))};
            return this.httpClient.execute(Request.buildGet(url, this.key, token, options)).thenApply(StreamBatch$$Lambda$12.lambdaFactory$());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivitiesByForeignID(Token token, ForeignIDTimePair ... activityIDTimePairs) throws StreamException {
        Preconditions.checkNotNull((Object)activityIDTimePairs, (Object)"No activities to get");
        Preconditions.checkArgument((activityIDTimePairs.length > 0 ? 1 : 0) != 0, (Object)"No activities to get");
        SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        timestampFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        timestampFormat.setLenient(false);
        Object[] foreignIDs = (String[])J8Arrays.stream((Object[])activityIDTimePairs).map(StreamBatch$$Lambda$13.lambdaFactory$()).toArray(StreamBatch$$Lambda$14.lambdaFactory$());
        Object[] timestamps = (String[])J8Arrays.stream((Object[])activityIDTimePairs).map(StreamBatch$$Lambda$15.lambdaFactory$(timestampFormat)).toArray(StreamBatch$$Lambda$16.lambdaFactory$());
        try {
            URL url = Routes.buildEnrichedActivitiesURL(this.baseURL);
            RequestOption[] options = new RequestOption[]{new CustomQueryParameter("foreign_ids", Joiner.on((String)",").join(foreignIDs)), new CustomQueryParameter("timestamps", Joiner.on((String)",").join(timestamps))};
            return this.httpClient.execute(Request.buildGet(url, this.key, token, options)).thenApply(StreamBatch$$Lambda$17.lambdaFactory$());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> updateActivities(Token token, Activity ... activities) throws StreamException {
        Preconditions.checkNotNull((Object)activities, (Object)"No activities to update");
        Preconditions.checkArgument((activities.length > 0 ? 1 : 0) != 0, (Object)"No activities to update");
        try {
            final Activity[] data = activities;
            byte[] payload = Serialization.toJSON(new Object(){
                public final Activity[] activities;
                {
                    this.activities = data;
                }
            });
            URL url = Routes.buildActivitiesURL(this.baseURL);
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0])).thenApply(StreamBatch$$Lambda$18.lambdaFactory$());
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    static /* synthetic */ Void lambda$updateActivities$17(Response response) {
        try {
            return Serialization.deserializeError(response);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ List lambda$getEnrichedActivitiesByForeignID$16(Response response) {
        try {
            return Serialization.deserializeContainer(response, EnrichedActivity.class);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ String[] lambda$getEnrichedActivitiesByForeignID$15(int x$0) {
        return new String[x$0];
    }

    static /* synthetic */ String lambda$getEnrichedActivitiesByForeignID$14(SimpleDateFormat timestampFormat, ForeignIDTimePair pair) {
        return timestampFormat.format(pair.getTime());
    }

    static /* synthetic */ String[] lambda$getEnrichedActivitiesByForeignID$13(int x$0) {
        return new String[x$0];
    }

    static /* synthetic */ String lambda$getEnrichedActivitiesByForeignID$12(ForeignIDTimePair pair) {
        return pair.getForeignID();
    }

    static /* synthetic */ List lambda$getActivitiesByForeignID$11(Response response) {
        try {
            return Serialization.deserializeContainer(response, Activity.class);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ String[] lambda$getActivitiesByForeignID$10(int x$0) {
        return new String[x$0];
    }

    static /* synthetic */ String lambda$getActivitiesByForeignID$9(SimpleDateFormat timestampFormat, ForeignIDTimePair pair) {
        return timestampFormat.format(pair.getTime());
    }

    static /* synthetic */ String[] lambda$getActivitiesByForeignID$8(int x$0) {
        return new String[x$0];
    }

    static /* synthetic */ String lambda$getActivitiesByForeignID$7(ForeignIDTimePair pair) {
        return pair.getForeignID();
    }

    static /* synthetic */ List lambda$getEnrichedActivitiesByID$6(Response response) {
        try {
            return Serialization.deserializeContainer(response, EnrichedActivity.class);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ List lambda$getActivitiesByID$5(Response response) {
        try {
            return Serialization.deserializeContainer(response, Activity.class);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ Void lambda$unfollowMany$4(Response response) {
        try {
            return Serialization.deserializeError(response);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ Void lambda$followMany$3(Response response) {
        try {
            return Serialization.deserializeError(response);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ Void lambda$addToMany$2(Response response) {
        try {
            return Serialization.deserializeError(response);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ String[] lambda$addToMany$1(int x$0) {
        return new String[x$0];
    }

    static /* synthetic */ String lambda$addToMany$0(FeedID feed) {
        return feed.toString();
    }
}

