/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import io.getstream.core.StreamPersonalization$$Lambda$1;
import io.getstream.core.StreamPersonalization$$Lambda$2;
import io.getstream.core.StreamPersonalization$$Lambda$3;
import io.getstream.core.StreamPersonalization$$Lambda$4;
import io.getstream.core.StreamPersonalization$$Lambda$5;
import io.getstream.core.StreamPersonalization$$Lambda$6;
import io.getstream.core.StreamPersonalization$$Lambda$7;
import io.getstream.core.StreamPersonalization$$Lambda$8;
import io.getstream.core.StreamPersonalization$$Lambda$9;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.HTTPClient;
import io.getstream.core.http.Response;
import io.getstream.core.http.Token;
import io.getstream.core.options.CustomQueryParameter;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.Request;
import io.getstream.core.utils.Routes;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java8.util.concurrent.CompletableFuture;
import java8.util.concurrent.CompletionException;
import java8.util.stream.StreamSupport;

public final class StreamPersonalization {
    private final String key;
    private final URL baseURL;
    private final HTTPClient httpClient;

    StreamPersonalization(String key, URL baseURL, HTTPClient httpClient) {
        this.key = key;
        this.baseURL = baseURL;
        this.httpClient = httpClient;
    }

    public CompletableFuture<Map<String, Object>> get(Token token, String userID, String resource, Map<String, Object> params) throws StreamException {
        Preconditions.checkNotNull((Object)resource, (Object)"Resource can't be empty");
        Preconditions.checkArgument((!resource.isEmpty() ? 1 : 0) != 0, (Object)"Resource can't be empty");
        Preconditions.checkNotNull(params, (Object)"Missing params");
        try {
            URL url = Routes.buildPersonalizationURL(this.baseURL, resource + '/');
            RequestOption[] options = (RequestOption[])StreamSupport.stream(params.entrySet()).map(StreamPersonalization$$Lambda$1.lambdaFactory$()).toArray(StreamPersonalization$$Lambda$2.lambdaFactory$());
            return this.httpClient.execute(Request.buildGet(url, this.key, token, options)).thenApply(StreamPersonalization$$Lambda$3.lambdaFactory$(this));
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> post(Token token, String userID, String resource, Map<String, Object> params, final Map<String, Object> payload) throws StreamException {
        Preconditions.checkNotNull((Object)resource, (Object)"Resource can't be empty");
        Preconditions.checkArgument((!resource.isEmpty() ? 1 : 0) != 0, (Object)"Resource can't be empty");
        Preconditions.checkNotNull(params, (Object)"Missing params");
        Preconditions.checkNotNull(params, (Object)"Missing payload");
        try {
            byte[] jsonPayload = Serialization.toJSON(new Object(){
                public final Map<String, Object> data;
                {
                    this.data = payload;
                }
            });
            URL url = Routes.buildPersonalizationURL(this.baseURL, resource + '/');
            RequestOption[] options = (RequestOption[])StreamSupport.stream(params.entrySet()).map(StreamPersonalization$$Lambda$4.lambdaFactory$()).toArray(StreamPersonalization$$Lambda$5.lambdaFactory$());
            return this.httpClient.execute(Request.buildPost(url, this.key, token, jsonPayload, options)).thenApply(StreamPersonalization$$Lambda$6.lambdaFactory$());
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> delete(Token token, String userID, String resource, Map<String, Object> params) throws StreamException {
        Preconditions.checkNotNull((Object)resource, (Object)"Resource can't be empty");
        Preconditions.checkArgument((!resource.isEmpty() ? 1 : 0) != 0, (Object)"Resource can't be empty");
        Preconditions.checkNotNull(params, (Object)"Missing params");
        try {
            URL url = Routes.buildPersonalizationURL(this.baseURL, resource + '/');
            RequestOption[] options = (RequestOption[])params.entrySet().stream().map(StreamPersonalization$$Lambda$7.lambdaFactory$()).toArray(StreamPersonalization$$Lambda$8.lambdaFactory$());
            return this.httpClient.execute(Request.buildDelete(url, this.key, token, options)).thenApply(StreamPersonalization$$Lambda$9.lambdaFactory$());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    static /* synthetic */ Void lambda$delete$8(Response response) {
        try {
            return Serialization.deserializeError(response);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ RequestOption[] lambda$delete$7(int x$0) {
        return new RequestOption[x$0];
    }

    static /* synthetic */ CustomQueryParameter lambda$delete$6(Map.Entry entry) {
        return new CustomQueryParameter((String)entry.getKey(), entry.getValue().toString());
    }

    static /* synthetic */ Void lambda$post$5(Response response) {
        try {
            return Serialization.deserializeError(response);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ RequestOption[] lambda$post$4(int x$0) {
        return new RequestOption[x$0];
    }

    static /* synthetic */ CustomQueryParameter lambda$post$3(Map.Entry entry) {
        return new CustomQueryParameter((String)entry.getKey(), entry.getValue().toString());
    }

    static /* synthetic */ Map lambda$get$2(StreamPersonalization this_, Response response) {
        try {
            return Serialization.deserialize(response, new TypeReference<Map<String, Object>>(){});
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ RequestOption[] lambda$get$1(int x$0) {
        return new RequestOption[x$0];
    }

    static /* synthetic */ CustomQueryParameter lambda$get$0(Map.Entry entry) {
        return new CustomQueryParameter((String)entry.getKey(), entry.getValue().toString());
    }
}

