/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.getstream.core.KeepHistory;
import io.getstream.core.models.FollowRelation;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class UnfollowOperation {
    private final String source;
    private final String target;
    private final KeepHistory keepHistory;

    @JsonCreator
    public UnfollowOperation(@JsonProperty(value="feed_id") String source, @JsonProperty(value="target_id") String target, @JsonProperty(value="keep_history") KeepHistory keepHistory) {
        Preconditions.checkNotNull((Object)source, (Object)"UnfollowOperation 'source' field required");
        Preconditions.checkNotNull((Object)target, (Object)"UnfollowOperation 'target' field required");
        Preconditions.checkNotNull((Object)((Object)keepHistory), (Object)"UnfollowOperation 'keep history' field required");
        this.source = source;
        this.target = target;
        this.keepHistory = keepHistory;
    }

    public UnfollowOperation(FollowRelation follow, KeepHistory keepHistory) {
        Preconditions.checkNotNull((Object)follow, (Object)"UnfollowOperation 'follow' field required");
        Preconditions.checkNotNull((Object)((Object)keepHistory), (Object)"UnfollowOperation 'keep history' field required");
        this.source = follow.getSource();
        this.target = follow.getTarget();
        this.keepHistory = keepHistory;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public KeepHistory getKeepHistory() {
        return this.keepHistory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnfollowOperation that = (UnfollowOperation)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target) && Objects.equals((Object)this.keepHistory, (Object)that.keepHistory);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.target, this.keepHistory});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("target", (Object)this.target).add("keep_history", (Object)this.keepHistory).toString();
    }
}

