/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.utils;

import com.google.common.base.Joiner;
import io.getstream.core.models.FeedID;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public final class Routes {
    private static final String basePath = "/api/v1.0/";
    private static final String analyticsPath = "/analytics/v1.0/";
    private static final String personalizationPath = "/personalization/v1.0/";
    private static final String analyticsSubdomain = "analytics";
    private static final String personalizationSubdomain = "personalization";
    private static final String activitiesPath = "activities/";
    private static final String activityUpdatePath = "activity/";
    private static final String addToManyPath = "feed/add_to_many/";
    private static final String followManyPath = "follow_many/";
    private static final String unfollowManyPath = "unfollow_many/";
    private static final String collectionsPath = "collections/";
    private static final String filesPath = "files/";
    private static final String imagesPath = "images/";
    private static final String openGraphPath = "og/";
    private static final String reactionsPath = "reaction/";
    private static final String toTargetUpdatePath = "/activity_to_targets/";
    private static final String usersPath = "user/";

    private Routes() {
    }

    public static URL buildFeedURL(URL baseURL, FeedID feed, String path) throws MalformedURLException {
        return new URL(baseURL, basePath + Routes.feedPath(feed) + path);
    }

    public static URL buildEnrichedFeedURL(URL baseURL, FeedID feed, String path) throws MalformedURLException {
        return new URL(baseURL, basePath + Routes.enrichedFeedPath(feed) + path);
    }

    public static URL buildToTargetUpdateURL(URL baseURL, FeedID feed) throws MalformedURLException {
        return new URL(baseURL, basePath + Routes.feedTargetsPath(feed) + toTargetUpdatePath);
    }

    public static URL buildActivitiesURL(URL baseURL) throws MalformedURLException {
        return new URL(baseURL, "/api/v1.0/activities/");
    }

    public static URL buildEnrichedActivitiesURL(URL baseURL) throws MalformedURLException {
        return new URL(baseURL, basePath + Routes.enriched(activitiesPath));
    }

    public static URL buildCollectionsURL(URL baseURL, String path) throws MalformedURLException {
        return new URL(baseURL, "/api/v1.0/collections/" + path);
    }

    public static URL buildReactionsURL(URL baseURL) throws MalformedURLException {
        return new URL(baseURL, "/api/v1.0/reaction/");
    }

    public static URL buildReactionsURL(URL baseURL, String path) throws MalformedURLException {
        return new URL(baseURL, "/api/v1.0/reaction/" + path);
    }

    public static URL buildUsersURL(URL baseURL) throws MalformedURLException {
        return new URL(baseURL, "/api/v1.0/user/");
    }

    public static URL buildUsersURL(URL baseURL, String path) throws MalformedURLException {
        return new URL(baseURL, "/api/v1.0/user/" + path);
    }

    public static URL buildBatchCollectionsURL(URL baseURL) throws MalformedURLException {
        return new URL(baseURL, "/api/v1.0/collections/");
    }

    public static URL buildOpenGraphURL(URL baseURL) throws MalformedURLException {
        return new URL(baseURL, "/api/v1.0/og/");
    }

    public static URL buildFilesURL(URL baseURL) throws MalformedURLException {
        return new URL(baseURL, "/api/v1.0/files/");
    }

    public static URL buildImagesURL(URL baseURL) throws MalformedURLException {
        return new URL(baseURL, "/api/v1.0/images/");
    }

    public static URL buildPersonalizationURL(URL baseURL, String path) throws MalformedURLException {
        return Routes.buildSubdomainPath(baseURL, personalizationSubdomain, personalizationPath, path);
    }

    public static URL buildAnalyticsURL(URL baseURL, String path) throws MalformedURLException {
        return Routes.buildSubdomainPath(baseURL, analyticsSubdomain, analyticsPath, path);
    }

    public static URL buildActivityUpdateURL(URL baseURL) throws MalformedURLException {
        return new URL(baseURL, "/api/v1.0/activity/");
    }

    public static URL buildAddToManyURL(URL baseURL) throws MalformedURLException {
        return new URL(baseURL, "/api/v1.0/feed/add_to_many/");
    }

    public static URL buildFollowManyURL(URL baseURL) throws MalformedURLException {
        return new URL(baseURL, "/api/v1.0/follow_many/");
    }

    public static URL buildUnfollowManyURL(URL baseURL) throws MalformedURLException {
        return new URL(baseURL, "/api/v1.0/unfollow_many/");
    }

    private static URL buildSubdomainPath(URL baseURL, String subdomain, String apiPath, String path) throws MalformedURLException {
        try {
            URI baseURI = baseURL.toURI();
            Object[] parts = baseURI.getHost().split("\\.");
            if (parts.length > 2) {
                parts[0] = subdomain;
            }
            return new URI(baseURI.getScheme(), baseURI.getUserInfo(), Joiner.on((String)".").join(parts), baseURI.getPort(), baseURI.getPath() + apiPath + path, baseURI.getQuery(), null).toURL();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getReason());
        }
    }

    private static String feedPath(FeedID feed) {
        return String.format("feed/%s/%s", feed.getSlug(), feed.getUserID());
    }

    private static String feedTargetsPath(FeedID feed) {
        return String.format("feed_targets/%s/%s", feed.getSlug(), feed.getUserID());
    }

    private static String enrichedFeedPath(FeedID feed) {
        return String.format("enrich/feed/%s/%s", feed.getSlug(), feed.getUserID());
    }

    private static String enriched(String url) {
        return String.format("enrich/%s", url);
    }
}

