/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.api.interceptor;

import io.getstream.chat.android.client.logger.ChatLogLevel;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u0006*\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/getstream/chat/android/client/api/interceptor/HttpLoggingInterceptor;", "Lokhttp3/Interceptor;", "()V", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "bodyHasUnknownEncoding", "", "headers", "Lokhttp3/Headers;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "isProbablyUtf8", "Lokio/Buffer;", "stream-chat-android-client_release"})
public final class HttpLoggingInterceptor
implements Interceptor {
    private final TaggedLogger logger = ChatLogger.Companion.get("Http");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        String string2;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        ChatLogLevel level = this.logger.getLevel();
        Request request = chain.request();
        if (level == ChatLogLevel.NOTHING) {
            return chain.proceed(request);
        }
        RequestBody requestBody = request.body();
        Connection connection = chain.connection();
        String requestStartMessage = "--> " + request.method() + ' ' + request.url() + (connection != null ? " " + connection.protocol() : "");
        if (requestBody != null) {
            requestStartMessage = requestStartMessage + " (" + requestBody.contentLength() + "-byte body)";
        }
        this.logger.logI(requestStartMessage);
        if (requestBody == null) {
            this.logger.logI("--> END " + request.method());
        } else if (this.bodyHasUnknownEncoding(request.headers())) {
            this.logger.logI("--> END " + request.method() + " (encoded body omitted)");
        } else if (requestBody.isDuplex()) {
            this.logger.logI("--> END " + request.method() + " (duplex request body omitted)");
        } else if (requestBody.isOneShot()) {
            this.logger.logI("--> END " + request.method() + " (one-shot body omitted)");
        } else {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            MediaType contentType = requestBody.contentType();
            Object object = contentType;
            if (object == null || (object = object.charset(StandardCharsets.UTF_8)) == null) {
                Charset charset = StandardCharsets.UTF_8;
                object = charset;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
            }
            Object charset = object;
            this.logger.logI("");
            if (this.isProbablyUtf8(buffer)) {
                this.logger.logI(buffer.readString((Charset)charset));
                this.logger.logI("--> END " + request.method() + " (" + requestBody.contentLength() + "-byte body)");
            } else {
                this.logger.logI("--> END " + request.method() + " (binary " + requestBody.contentLength() + "-byte body omitted)");
            }
        }
        long startNs = System.nanoTime();
        Response response = null;
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            this.logger.logI("<-- HTTP FAILED: " + e);
            throw (Throwable)e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody = response.body();
        Intrinsics.checkNotNull((Object)responseBody);
        ResponseBody responseBody2 = responseBody;
        long contentLength = responseBody2.contentLength();
        String bodySize = contentLength != -1L ? contentLength + "-byte" : "unknown-length";
        StringBuilder stringBuilder = new StringBuilder().append("<-- ").append(response.code());
        CharSequence charSequence = response.message();
        boolean bl = false;
        if (charSequence.length() == 0) {
            string2 = "";
        } else {
            char c = ' ';
            String string3 = response.message();
            boolean bl2 = false;
            string2 = String.valueOf(c) + string3;
        }
        this.logger.logI(stringBuilder.append(string2).append(' ').append(response.request().url()).append(" (").append(tookMs).append("ms").append(", ").append(bodySize).append(" body").append(')').toString());
        if (!HttpHeaders.promisesBody((Response)response)) {
            this.logger.logI("<-- END HTTP");
        } else if (this.bodyHasUnknownEncoding(response.headers())) {
            this.logger.logI("<-- END HTTP (encoded body omitted)");
        } else {
            BufferedSource source = responseBody2.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.getBuffer();
            Long gzippedLength = null;
            if (StringsKt.equals((String)response.headers().get("Content-Encoding"), (String)"gzip", (boolean)true)) {
                gzippedLength = buffer.size();
                Closeable closeable = (Closeable)new GzipSource((Source)buffer.clone());
                boolean bl3 = false;
                boolean bl4 = false;
                Throwable throwable = null;
                try {
                    GzipSource gzippedResponseBody = (GzipSource)closeable;
                    boolean bl5 = false;
                    buffer = new Buffer();
                    long l = buffer.writeAll((Source)gzippedResponseBody);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            if (!this.isProbablyUtf8(buffer)) {
                this.logger.logI("");
                this.logger.logI("<-- END HTTP (binary " + buffer.size() + "-byte body omitted)");
                return response;
            }
            if (gzippedLength != null) {
                this.logger.logI("<-- END HTTP (" + buffer.size() + "-byte, " + gzippedLength + "-gzipped-byte body omitted)");
            } else {
                this.logger.logI("<-- END HTTP (" + buffer.size() + "-byte body omitted)");
            }
        }
        return response;
    }

    private final boolean bodyHasUnknownEncoding(Headers headers) {
        String string2 = headers.get("Content-Encoding");
        if (string2 == null) {
            return false;
        }
        String contentEncoding = string2;
        return !StringsKt.equals((String)contentEncoding, (String)"identity", (boolean)true) && !StringsKt.equals((String)contentEncoding, (String)"gzip", (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isProbablyUtf8(Buffer $this$isProbablyUtf8) {
        try {
            Buffer prefix = new Buffer();
            long byteCount = RangesKt.coerceAtMost((long)$this$isProbablyUtf8.size(), (long)64L);
            $this$isProbablyUtf8.copyTo(prefix, 0L, byteCount);
            int n = 0;
            int n2 = 16;
            while (n < n2 && !prefix.exhausted()) {
                void i;
                int codePoint = prefix.readUtf8CodePoint();
                if (Character.isISOControl(codePoint) && !Character.isWhitespace(codePoint)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (EOFException _) {
            return false;
        }
    }
}

