/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications;

import android.content.Context;
import android.content.SharedPreferences;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.call.Call;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.notifications.DeviceRegisteredListener;
import io.getstream.chat.android.client.notifications.handler.ChatNotificationHandler;
import io.getstream.chat.android.client.utils.Result;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lio/getstream/chat/android/client/notifications/PushTokenUpdateHandler;", "", "context", "Landroid/content/Context;", "handler", "Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;", "(Landroid/content/Context;Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;)V", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "prefs", "Landroid/content/SharedPreferences;", "value", "Lio/getstream/chat/android/client/notifications/PushTokenUpdateHandler$UserFirebaseToken;", "userFirebaseToken", "getUserFirebaseToken", "()Lio/getstream/chat/android/client/notifications/PushTokenUpdateHandler$UserFirebaseToken;", "setUserFirebaseToken", "(Lio/getstream/chat/android/client/notifications/PushTokenUpdateHandler$UserFirebaseToken;)V", "updateTokenIfNecessary", "", "firebaseToken", "", "Companion", "UserFirebaseToken", "stream-chat-android-client_release"})
public final class PushTokenUpdateHandler {
    private final TaggedLogger logger;
    private final SharedPreferences prefs;
    private final ChatNotificationHandler handler;
    private static final String PREFS_NAME = "stream_firebase_token_store";
    private static final String KEY_USER_ID = "user_id";
    private static final String KEY_FIREBASE_TOKEN = "firebase_token";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final UserFirebaseToken getUserFirebaseToken() {
        String key$iv;
        SharedPreferences $this$getNonNullString$iv;
        SharedPreferences sharedPreferences = this.prefs;
        String string2 = KEY_USER_ID;
        String defaultValue$iv = "";
        boolean $i$f$getNonNullString = false;
        String string3 = $this$getNonNullString$iv.getString(key$iv, defaultValue$iv);
        Intrinsics.checkNotNull((Object)string3);
        $this$getNonNullString$iv = this.prefs;
        key$iv = KEY_FIREBASE_TOKEN;
        defaultValue$iv = "";
        $i$f$getNonNullString = false;
        String string4 = $this$getNonNullString$iv.getString(key$iv, defaultValue$iv);
        Intrinsics.checkNotNull((Object)string4);
        return new UserFirebaseToken(string3, string4);
    }

    private final void setUserFirebaseToken(UserFirebaseToken value) {
        this.prefs.edit().putString(KEY_USER_ID, value.getUserId()).putString(KEY_FIREBASE_TOKEN, value.getFirebaseToken()).apply();
    }

    public final void updateTokenIfNecessary(@NotNull String firebaseToken) {
        Intrinsics.checkNotNullParameter((Object)firebaseToken, (String)"firebaseToken");
        Object object = ChatClient.Companion.instance().getCurrentUser();
        if (object == null || (object = ((User)object).getId()) == null) {
            object = "";
        }
        UserFirebaseToken userFirebaseToken = new UserFirebaseToken((String)object, firebaseToken);
        if (Intrinsics.areEqual((Object)this.getUserFirebaseToken(), (Object)userFirebaseToken) ^ true) {
            ChatClient.Companion.instance().addDevice(firebaseToken).enqueue((Call.Callback)new Call.Callback<Unit>(this, userFirebaseToken, firebaseToken){
                final /* synthetic */ PushTokenUpdateHandler this$0;
                final /* synthetic */ UserFirebaseToken $userFirebaseToken;
                final /* synthetic */ String $firebaseToken;

                public final void onResult(@NotNull Result<Unit> result) {
                    Intrinsics.checkNotNullParameter(result, (String)"result");
                    if (result.isSuccess()) {
                        PushTokenUpdateHandler.access$setUserFirebaseToken$p(this.this$0, this.$userFirebaseToken);
                        DeviceRegisteredListener deviceRegisteredListener = PushTokenUpdateHandler.access$getHandler$p(this.this$0).getDeviceRegisteredListener();
                        if (deviceRegisteredListener != null) {
                            deviceRegisteredListener.onDeviceRegisteredSuccess();
                        }
                        PushTokenUpdateHandler.access$getLogger$p(this.this$0).logI("Device registered with token " + this.$firebaseToken);
                    } else {
                        DeviceRegisteredListener deviceRegisteredListener = PushTokenUpdateHandler.access$getHandler$p(this.this$0).getDeviceRegisteredListener();
                        if (deviceRegisteredListener != null) {
                            deviceRegisteredListener.onDeviceRegisteredError(result.error());
                        }
                        PushTokenUpdateHandler.access$getLogger$p(this.this$0).logE("Error registering device " + result.error().getMessage());
                    }
                }
                {
                    this.this$0 = pushTokenUpdateHandler;
                    this.$userFirebaseToken = userFirebaseToken;
                    this.$firebaseToken = string2;
                }
            });
        }
    }

    public PushTokenUpdateHandler(@NotNull Context context, @NotNull ChatNotificationHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        this.handler = handler2;
        this.logger = ChatLogger.Companion.get("ChatNotifications");
        SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(PREFS_NAME, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.applicationConte\u2026ontext.MODE_PRIVATE\n    )");
        this.prefs = sharedPreferences;
    }

    public static final /* synthetic */ UserFirebaseToken access$getUserFirebaseToken$p(PushTokenUpdateHandler $this) {
        return $this.getUserFirebaseToken();
    }

    public static final /* synthetic */ void access$setUserFirebaseToken$p(PushTokenUpdateHandler $this, UserFirebaseToken userFirebaseToken) {
        $this.setUserFirebaseToken(userFirebaseToken);
    }

    public static final /* synthetic */ ChatNotificationHandler access$getHandler$p(PushTokenUpdateHandler $this) {
        return $this.handler;
    }

    public static final /* synthetic */ TaggedLogger access$getLogger$p(PushTokenUpdateHandler $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lio/getstream/chat/android/client/notifications/PushTokenUpdateHandler$UserFirebaseToken;", "", "userId", "", "firebaseToken", "(Ljava/lang/String;Ljava/lang/String;)V", "getFirebaseToken", "()Ljava/lang/String;", "getUserId", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "stream-chat-android-client_release"})
    private static final class UserFirebaseToken {
        @NotNull
        private final String userId;
        @NotNull
        private final String firebaseToken;

        @NotNull
        public final String getUserId() {
            return this.userId;
        }

        @NotNull
        public final String getFirebaseToken() {
            return this.firebaseToken;
        }

        public UserFirebaseToken(@NotNull String userId, @NotNull String firebaseToken) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)firebaseToken, (String)"firebaseToken");
            this.userId = userId;
            this.firebaseToken = firebaseToken;
        }

        @NotNull
        public final String component1() {
            return this.userId;
        }

        @NotNull
        public final String component2() {
            return this.firebaseToken;
        }

        @NotNull
        public final UserFirebaseToken copy(@NotNull String userId, @NotNull String firebaseToken) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)firebaseToken, (String)"firebaseToken");
            return new UserFirebaseToken(userId, firebaseToken);
        }

        public static /* synthetic */ UserFirebaseToken copy$default(UserFirebaseToken userFirebaseToken, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = userFirebaseToken.userId;
            }
            if ((n & 2) != 0) {
                string3 = userFirebaseToken.firebaseToken;
            }
            return userFirebaseToken.copy(string2, string3);
        }

        @NotNull
        public String toString() {
            return "UserFirebaseToken(userId=" + this.userId + ", firebaseToken=" + this.firebaseToken + ")";
        }

        public int hashCode() {
            String string2 = this.userId;
            String string3 = this.firebaseToken;
            return (string2 != null ? string2.hashCode() : 0) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof UserFirebaseToken)) break block3;
                    UserFirebaseToken userFirebaseToken = (UserFirebaseToken)object;
                    if (!Intrinsics.areEqual((Object)this.userId, (Object)userFirebaseToken.userId) || !Intrinsics.areEqual((Object)this.firebaseToken, (Object)userFirebaseToken.firebaseToken)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/getstream/chat/android/client/notifications/PushTokenUpdateHandler$Companion;", "", "()V", "KEY_FIREBASE_TOKEN", "", "KEY_USER_ID", "PREFS_NAME", "stream-chat-android-client_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

