/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.google.android.gms.tasks.Task;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.RemoteMessage;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.api.ChatApi;
import io.getstream.chat.android.client.api.models.QueryChannelRequest;
import io.getstream.chat.android.client.call.Call;
import io.getstream.chat.android.client.call.CallKt;
import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.events.NewMessageEvent;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.notifications.ChatNotifications;
import io.getstream.chat.android.client.notifications.ChatNotificationsImpl;
import io.getstream.chat.android.client.notifications.FirebaseMessageParser;
import io.getstream.chat.android.client.notifications.LoadNotificationDataWorker;
import io.getstream.chat.android.client.notifications.NotificationLoadDataListener;
import io.getstream.chat.android.client.notifications.PushNotificationReceivedListener;
import io.getstream.chat.android.client.notifications.PushTokenUpdateHandler;
import io.getstream.chat.android.client.notifications.handler.ChatNotificationHandler;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.core.internal.coroutines.DispatcherProvider;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J)\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020&2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010 \u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u0019H\u0016J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0017H\u0016J\"\u00100\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u00020&H\u0002J\"\u00104\u001a\u00020\u00192\u0006\u00105\u001a\u0002062\u0006\u0010#\u001a\u0002072\b\b\u0002\u00103\u001a\u00020&H\u0002J \u00104\u001a\u00020\u00192\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u00103\u001a\u00020&H\u0002J\u0010\u0010<\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006="}, d2={"Lio/getstream/chat/android/client/notifications/ChatNotificationsImpl;", "Lio/getstream/chat/android/client/notifications/ChatNotifications;", "handler", "Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;", "client", "Lio/getstream/chat/android/client/api/ChatApi;", "context", "Landroid/content/Context;", "(Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;Lio/getstream/chat/android/client/api/ChatApi;Landroid/content/Context;)V", "getHandler", "()Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "notificationManager", "Landroid/app/NotificationManager;", "getNotificationManager", "()Landroid/app/NotificationManager;", "notificationManager$delegate", "Lkotlin/Lazy;", "pushTokenUpdateHandler", "Lio/getstream/chat/android/client/notifications/PushTokenUpdateHandler;", "showedNotifications", "", "", "cancelLoadDataWork", "", "displayNotificationWithData", "channelType", "channelId", "messageId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleEvent", "event", "Lio/getstream/chat/android/client/events/NewMessageEvent;", "handleRemoteMessage", "message", "Lcom/google/firebase/messaging/RemoteMessage;", "isForeground", "", "isValidRemoteMessage", "onChatEvent", "Lio/getstream/chat/android/client/events/ChatEvent;", "onFirebaseMessage", "pushNotificationReceivedListener", "Lio/getstream/chat/android/client/notifications/PushNotificationReceivedListener;", "onSetUser", "setFirebaseToken", "firebaseToken", "showErrorNotification", "error", "Lio/getstream/chat/android/client/errors/ChatError;", "shouldShowInForeground", "showNotification", "channel", "Lio/getstream/chat/android/client/models/Channel;", "Lio/getstream/chat/android/client/models/Message;", "notificationId", "", "notification", "Landroid/app/Notification;", "wasNotificationDisplayed", "stream-chat-android-client_release"})
public final class ChatNotificationsImpl
implements ChatNotifications {
    @NotNull
    private final ChatNotificationHandler handler;
    @NotNull
    private final ChatApi client;
    @NotNull
    private final Context context;
    @NotNull
    private final TaggedLogger logger;
    @NotNull
    private final PushTokenUpdateHandler pushTokenUpdateHandler;
    @NotNull
    private final Set<String> showedNotifications;
    @NotNull
    private final Lazy notificationManager$delegate;

    public ChatNotificationsImpl(@NotNull ChatNotificationHandler handler2, @NotNull ChatApi client, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.handler = handler2;
        this.client = client;
        this.context = context;
        this.logger = ChatLogger.Companion.get("ChatNotifications");
        this.pushTokenUpdateHandler = new PushTokenUpdateHandler(this.context, this.getHandler());
        boolean bl = false;
        this.showedNotifications = new LinkedHashSet();
        this.notificationManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NotificationManager>(this){
            final /* synthetic */ ChatNotificationsImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NotificationManager invoke() {
                Object object = ChatNotificationsImpl.access$getContext$p(this.this$0).getSystemService("notification");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
                }
                return (NotificationManager)object;
            }
        }));
        if (Build.VERSION.SDK_INT >= 26) {
            this.getNotificationManager().createNotificationChannel(this.getHandler().createNotificationChannel());
        }
    }

    @Override
    @NotNull
    public ChatNotificationHandler getHandler() {
        return this.handler;
    }

    private final NotificationManager getNotificationManager() {
        Lazy lazy = this.notificationManager$delegate;
        boolean bl = false;
        return (NotificationManager)lazy.getValue();
    }

    @Override
    public void onSetUser() {
        Task task;
        FirebaseMessaging firebaseMessaging = this.getHandler().getFirebaseMessaging();
        if (firebaseMessaging != null && (task = firebaseMessaging.getToken()) != null) {
            task.addOnCompleteListener(arg_0 -> ChatNotificationsImpl.onSetUser$lambda-0(this, arg_0));
        }
    }

    @Override
    public void setFirebaseToken(@NotNull String firebaseToken) {
        Intrinsics.checkNotNullParameter((Object)firebaseToken, (String)"firebaseToken");
        this.pushTokenUpdateHandler.updateTokenIfNecessary(firebaseToken);
    }

    @Override
    public void onFirebaseMessage(@NotNull RemoteMessage message, @NotNull PushNotificationReceivedListener pushNotificationReceivedListener) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)pushNotificationReceivedListener, (String)"pushNotificationReceivedListener");
        this.logger.logI(Intrinsics.stringPlus((String)"onReceiveFirebaseMessage: payload: ", (Object)message.getData()));
        if (this.isValidRemoteMessage(message)) {
            FirebaseMessageParser firebaseMessageParser = this.getHandler().getFirebaseMessageParser();
            boolean bl = false;
            boolean bl2 = false;
            FirebaseMessageParser $this$onFirebaseMessage_u24lambda_u2d1 = firebaseMessageParser;
            boolean bl3 = false;
            FirebaseMessageParser.Data data = $this$onFirebaseMessage_u24lambda_u2d1.parse(message);
            pushNotificationReceivedListener.onPushNotificationReceived(data.getChannelType(), data.getChannelId());
        }
        if (!this.getHandler().onFirebaseMessage(message)) {
            if (this.isForeground()) {
                return;
            }
            this.handleRemoteMessage(message);
        }
    }

    @Override
    public void onChatEvent(@NotNull ChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof NewMessageEvent) {
            String currentUserId;
            User user = ChatClient.Companion.instance().getCurrentUser();
            String string = currentUserId = user == null ? null : user.getId();
            if (Intrinsics.areEqual((Object)((NewMessageEvent)event).getMessage().getUser().getId(), (Object)currentUserId)) {
                return;
            }
            this.logger.logD(Intrinsics.stringPlus((String)"Handling ", (Object)event));
            if (!this.getHandler().onChatEvent((NewMessageEvent)event)) {
                this.logger.logI("Handling " + event + " internally");
                this.handleEvent((NewMessageEvent)event);
            }
        }
    }

    @Override
    public void cancelLoadDataWork() {
        LoadNotificationDataWorker.Companion.cancel(this.context);
    }

    private final void handleRemoteMessage(RemoteMessage message) {
        if (this.isValidRemoteMessage(message)) {
            Object object = this.getHandler().getFirebaseMessageParser();
            boolean bl = false;
            boolean bl2 = false;
            FirebaseMessageParser $this$handleRemoteMessage_u24lambda_u2d2 = object;
            boolean bl3 = false;
            FirebaseMessageParser.Data data = $this$handleRemoteMessage_u24lambda_u2d2.parse(message);
            if (!this.wasNotificationDisplayed(data.getMessageId())) {
                this.showedNotifications.add(data.getMessageId());
                String string = data.getChannelId();
                String string2 = data.getChannelType();
                String string3 = data.getMessageId();
                object = this.context.getString(this.getHandler().getConfig().getLoadNotificationDataChannelName());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.getString(handler.config.loadNotificationDataChannelName)");
                Object object2 = object;
                int n = this.getHandler().getConfig().getLoadNotificationDataIcon();
                object = this.context.getString(this.getHandler().getConfig().getLoadNotificationDataTitle());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.getString(handler.config.loadNotificationDataTitle)");
                LoadNotificationDataWorker.Companion.start(this.context, string, string2, string3, (String)object2, n, (String)object);
            }
        } else {
            this.logger.logE("Push payload is not configured correctly: {" + message.getData() + '}');
        }
    }

    @Override
    public boolean isValidRemoteMessage(@NotNull RemoteMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.getHandler().isValidRemoteMessage$stream_chat_android_client_release(message);
    }

    private final void handleEvent(NewMessageEvent event) {
        String messageId = event.getMessage().getId();
        if (!this.wasNotificationDisplayed(messageId)) {
            this.showedNotifications.add(messageId);
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
                int label;
                final /* synthetic */ ChatNotificationsImpl this$0;
                final /* synthetic */ NewMessageEvent $event;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = CallKt.await(ChatNotificationsImpl.access$getClient$p(this.this$0).queryChannel(this.$event.getChannelType(), this.$event.getChannelId(), new QueryChannelRequest()), (Continuation)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if ((result = (Result)v0).isSuccess()) {
                                ChatNotificationsImpl.access$showNotification(this.this$0, (Channel)result.data(), this.$event.getMessage(), true);
                            } else {
                                ChatNotificationsImpl.access$showErrorNotification(this.this$0, this.$event.getMessage().getId(), result.error(), true);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    private final boolean wasNotificationDisplayed(String messageId) {
        return this.showedNotifications.contains(messageId);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object displayNotificationWithData(@NotNull String var1_1, @NotNull String var2_2, @NotNull String var3_3, @NotNull Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof displayNotificationWithData.1)) ** GOTO lbl-1000
        var12_5 = var4_4;
        if ((var12_5.label & -2147483648) != 0) {
            var12_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ChatNotificationsImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.displayNotificationWithData(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                getMessage = this.client.getMessage(messageId);
                getChannel = this.client.queryChannel((String)channelType, (String)channelId, new QueryChannelRequest());
                $continuation.L$0 = this;
                $continuation.L$1 = messageId;
                $continuation.label = 1;
                v0 = CallKt.await((Call)CallKt.zipWith(getChannel, getMessage), (Continuation)$continuation);
                if (v0 == var13_7) {
                    return var13_7;
                }
                ** GOTO lbl26
            }
            case 1: {
                messageId = (String)$continuation.L$1;
                this = (ChatNotificationsImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                if ((result = (Result)v0).isSuccess()) {
                    var8_11 = (Pair)result.data();
                    channel = (Channel)var8_11.component1();
                    message = (Message)var8_11.component2();
                    ChatNotificationsImpl.showNotification$default(this, channel, message, false, 4, null);
                } else {
                    ChatNotificationsImpl.showErrorNotification$default(this, messageId, result.error(), false, 4, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void showNotification(Channel channel, Message message, boolean shouldShowInForeground) {
        this.logger.logD("Showing notification with loaded data");
        int notificationId = (int)System.currentTimeMillis();
        NotificationLoadDataListener notificationLoadDataListener = this.getHandler().getDataLoadListener();
        if (notificationLoadDataListener != null) {
            notificationLoadDataListener.onLoadSuccess(channel, message);
        }
        notificationLoadDataListener = this.getHandler().buildNotification(notificationId, channel, message).build();
        boolean bl = false;
        boolean bl2 = false;
        NotificationLoadDataListener notification = notificationLoadDataListener;
        boolean bl3 = false;
        this.showedNotifications.add(message.getId());
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"notification");
        this.showNotification(notificationId, (Notification)notification, shouldShowInForeground);
        if (this.getHandler().getConfig().getShouldGroupNotifications()) {
            notificationLoadDataListener = this.getHandler().buildNotificationGroupSummary(channel, message).build();
            bl = false;
            bl2 = false;
            notification = notificationLoadDataListener;
            boolean bl4 = false;
            int n = this.getHandler().getNotificationGroupSummaryId(channel.getType(), channel.getId());
            Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"notification");
            this.showNotification(n, (Notification)notification, shouldShowInForeground);
        }
    }

    static /* synthetic */ void showNotification$default(ChatNotificationsImpl chatNotificationsImpl, Channel channel, Message message, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        chatNotificationsImpl.showNotification(channel, message, bl);
    }

    private final void showErrorNotification(String messageId, ChatError error, boolean shouldShowInForeground) {
        this.logger.logE(Intrinsics.stringPlus((String)"Error loading required data: ", (Object)error.getMessage()), error);
        NotificationLoadDataListener notificationLoadDataListener = this.getHandler().getDataLoadListener();
        if (notificationLoadDataListener != null) {
            notificationLoadDataListener.onLoadFail(messageId, error);
        }
        this.showNotification((int)System.currentTimeMillis(), this.getHandler().buildErrorCaseNotification(), shouldShowInForeground);
        if (this.getHandler().getConfig().getShouldGroupNotifications()) {
            this.showNotification(this.getHandler().getErrorNotificationGroupSummaryId(), this.getHandler().buildErrorNotificationGroupSummary(), shouldShowInForeground);
        }
    }

    static /* synthetic */ void showErrorNotification$default(ChatNotificationsImpl chatNotificationsImpl, String string, ChatError chatError, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        chatNotificationsImpl.showErrorNotification(string, chatError, bl);
    }

    private final void showNotification(int notificationId, Notification notification, boolean shouldShowInForeground) {
        if (shouldShowInForeground || !this.isForeground()) {
            this.getNotificationManager().notify(notificationId, notification);
        }
    }

    private final boolean isForeground() {
        return ProcessLifecycleOwner.get().getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED);
    }

    private static final void onSetUser$lambda-0(ChatNotificationsImpl this$0, Task it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.isSuccessful()) {
            this$0.logger.logI("Firebase returned token successfully");
            String string = (String)it.getResult();
            Intrinsics.checkNotNull((Object)string);
            String string2 = string;
            this$0.setFirebaseToken(string2);
        } else {
            this$0.logger.logI("Error: Firebase didn't returned token");
        }
    }

    public static final /* synthetic */ ChatApi access$getClient$p(ChatNotificationsImpl $this) {
        return $this.client;
    }

    public static final /* synthetic */ void access$showNotification(ChatNotificationsImpl $this, Channel channel, Message message, boolean shouldShowInForeground) {
        $this.showNotification(channel, message, shouldShowInForeground);
    }

    public static final /* synthetic */ void access$showErrorNotification(ChatNotificationsImpl $this, String messageId, ChatError error, boolean shouldShowInForeground) {
        $this.showErrorNotification(messageId, error, shouldShowInForeground);
    }

    public static final /* synthetic */ Context access$getContext$p(ChatNotificationsImpl $this) {
        return $this.context;
    }
}

