/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications;

import android.util.Log;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/getstream/chat/android/client/notifications/ChatFirebaseMessagingService;", "Lcom/google/firebase/messaging/FirebaseMessagingService;", "()V", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "onMessageReceived", "", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "onNewToken", "token", "", "Companion", "stream-chat-android-client_release"})
public final class ChatFirebaseMessagingService
extends FirebaseMessagingService {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final TaggedLogger logger = ChatLogger.Companion.get("ChatFirebaseMessagingService");
    @Deprecated
    @NotNull
    private static final String TAG = "Chat:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageReceived(@NotNull RemoteMessage remoteMessage) {
        Intrinsics.checkNotNullParameter((Object)remoteMessage, (String)"remoteMessage");
        this.logger.logD(Intrinsics.stringPlus((String)"onMessageReceived(): ", (Object)remoteMessage));
        try {
            ChatClient.Companion.handleRemoteMessage(remoteMessage);
        }
        catch (IllegalStateException exception) {
            Log.e((String)TAG, (String)Intrinsics.stringPlus((String)"Error while handling remote message: ", (Object)exception.getMessage()));
        }
        finally {
            this.stopSelf();
        }
    }

    public void onNewToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        try {
            ChatClient.Companion.setFirebaseToken(token);
        }
        catch (IllegalStateException exception) {
            Log.e((String)TAG, (String)Intrinsics.stringPlus((String)"Error while handling remote message: ", (Object)exception.getMessage()));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/client/notifications/ChatFirebaseMessagingService$Companion;", "", "()V", "TAG", "", "stream-chat-android-client_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

