/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications;

import com.google.firebase.messaging.RemoteMessage;
import io.getstream.chat.android.client.extensions.RemoteMessageExtensionsKt;
import io.getstream.chat.android.client.notifications.FirebaseMessageParser;
import io.getstream.chat.android.client.notifications.handler.NotificationConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/getstream/chat/android/client/notifications/FirebaseMessageParserImpl;", "Lio/getstream/chat/android/client/notifications/FirebaseMessageParser;", "config", "Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;", "(Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;)V", "channelIdKey", "", "channelTypeKey", "messageIdKey", "isValidRemoteMessage", "", "message", "Lcom/google/firebase/messaging/RemoteMessage;", "parse", "Lio/getstream/chat/android/client/notifications/FirebaseMessageParser$Data;", "stream-chat-android-client_release"})
public final class FirebaseMessageParserImpl
implements FirebaseMessageParser {
    @NotNull
    private final NotificationConfig config;
    @NotNull
    private final String messageIdKey;
    @NotNull
    private final String channelTypeKey;
    @NotNull
    private final String channelIdKey;

    public FirebaseMessageParserImpl(@NotNull NotificationConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.messageIdKey = this.config.getFirebaseMessageIdKey();
        this.channelTypeKey = this.config.getFirebaseChannelTypeKey();
        this.channelIdKey = this.config.getFirebaseChannelIdKey();
    }

    @Override
    public boolean isValidRemoteMessage(@NotNull RemoteMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return RemoteMessageExtensionsKt.isValid(message, this.config);
    }

    @Override
    @NotNull
    public FirebaseMessageParser.Data parse(@NotNull RemoteMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = (String)message.getData().get(this.messageIdKey);
        Intrinsics.checkNotNull((Object)string);
        String messageId = string;
        String string2 = (String)message.getData().get(this.channelIdKey);
        Intrinsics.checkNotNull((Object)string2);
        String channelId = string2;
        String string3 = (String)message.getData().get(this.channelTypeKey);
        Intrinsics.checkNotNull((Object)string3);
        String channelType = string3;
        return new FirebaseMessageParser.Data(messageId, channelType, channelId);
    }
}

