/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.parser2;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import io.getstream.chat.android.client.api2.MoshiUrlQueryPayloadFactory;
import io.getstream.chat.android.client.api2.mapping.EventMappingKt;
import io.getstream.chat.android.client.api2.mapping.SocketErrorMappingKt;
import io.getstream.chat.android.client.api2.model.dto.ChatEventDto;
import io.getstream.chat.android.client.api2.model.dto.UpstreamConnectedEventDto;
import io.getstream.chat.android.client.api2.model.response.SocketErrorResponse;
import io.getstream.chat.android.client.errors.ChatNetworkError;
import io.getstream.chat.android.client.events.ChannelUpdatedByUserEvent;
import io.getstream.chat.android.client.events.ChannelUpdatedEvent;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.events.ConnectedEvent;
import io.getstream.chat.android.client.events.MessageDeletedEvent;
import io.getstream.chat.android.client.events.MessageUpdatedEvent;
import io.getstream.chat.android.client.events.NewMessageEvent;
import io.getstream.chat.android.client.events.NotificationMessageNewEvent;
import io.getstream.chat.android.client.events.ReactionDeletedEvent;
import io.getstream.chat.android.client.events.ReactionNewEvent;
import io.getstream.chat.android.client.events.ReactionUpdateEvent;
import io.getstream.chat.android.client.extensions.MessageExtensionsKt;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.parser.ChatParser;
import io.getstream.chat.android.client.parser2.MoshiErrorLoggingKt;
import io.getstream.chat.android.client.parser2.adapters.AttachmentDtoAdapter;
import io.getstream.chat.android.client.parser2.adapters.DateAdapter;
import io.getstream.chat.android.client.parser2.adapters.DownstreamChannelDtoAdapter;
import io.getstream.chat.android.client.parser2.adapters.DownstreamMessageDtoAdapter;
import io.getstream.chat.android.client.parser2.adapters.DownstreamReactionDtoAdapter;
import io.getstream.chat.android.client.parser2.adapters.DownstreamUserDtoAdapter;
import io.getstream.chat.android.client.parser2.adapters.EventAdapterFactory;
import io.getstream.chat.android.client.parser2.adapters.UpstreamChannelDtoAdapter;
import io.getstream.chat.android.client.parser2.adapters.UpstreamMessageDtoAdapter;
import io.getstream.chat.android.client.parser2.adapters.UpstreamReactionDtoAdapter;
import io.getstream.chat.android.client.parser2.adapters.UpstreamUserDtoAdapter;
import io.getstream.chat.android.client.socket.ErrorResponse;
import io.getstream.chat.android.client.socket.SocketErrorMessage;
import io.getstream.chat.android.client.utils.Result;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J-\u0010\u001c\u001a\u0002H\u001d\"\b\b\u0000\u0010\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001d0\"H\u0016\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u001eH\u0002J\u0010\u0010/\u001a\u00020 2\u0006\u0010.\u001a\u00020\u001eH\u0016J#\u00100\u001a\u000201\"\u0006\b\u0000\u0010\u001d\u0018\u0001*\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0004H\u0082\bJ\f\u00103\u001a\u00020%*\u00020%H\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fRR\u0010\r\u001aF\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u0006*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000e0\u000e \u0006*\"\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u0006*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000e0\u000e\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R2\u0010\u0015\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00160\u0016 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00160\u0016\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0017\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00180\u0018 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00180\u0018\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lio/getstream/chat/android/client/parser2/MoshiChatParser;", "Lio/getstream/chat/android/client/parser/ChatParser;", "()V", "chatEventDtoAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Lio/getstream/chat/android/client/api2/model/dto/ChatEventDto;", "kotlin.jvm.PlatformType", "errorResponseAdapter", "Lio/getstream/chat/android/client/api2/model/response/SocketErrorResponse$ErrorResponse;", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "getLogger", "()Lio/getstream/chat/android/client/logger/TaggedLogger;", "mapAdapter", "", "moshi", "Lcom/squareup/moshi/Moshi;", "getMoshi", "()Lcom/squareup/moshi/Moshi;", "moshi$delegate", "Lkotlin/Lazy;", "socketErrorResponseAdapter", "Lio/getstream/chat/android/client/api2/model/response/SocketErrorResponse;", "upstreamConnectedEventAdapter", "Lio/getstream/chat/android/client/api2/model/dto/UpstreamConnectedEventDto;", "configRetrofit", "Lretrofit2/Retrofit$Builder;", "builder", "fromJson", "T", "", "raw", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "parseAndProcessEvent", "Lio/getstream/chat/android/client/events/ChatEvent;", "parseErrorResponse", "Lio/getstream/chat/android/client/socket/ErrorResponse;", "parseSocketError", "Lio/getstream/chat/android/client/socket/SocketErrorMessage;", "serializeConnectedEvent", "connectedEvent", "Lio/getstream/chat/android/client/events/ConnectedEvent;", "serializeMap", "any", "toJson", "addAdapter", "Lcom/squareup/moshi/Moshi$Builder;", "adapter", "enrichIfNeeded", "stream-chat-android-client_release"})
public final class MoshiChatParser
implements ChatParser {
    @NotNull
    private final TaggedLogger logger = ChatLogger.Companion.get("NEW_SERIALIZATION_ERROR");
    @NotNull
    private final Lazy moshi$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Moshi>(this){
        final /* synthetic */ MoshiChatParser this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        /*
         * WARNING - void declaration
         */
        public final Moshi invoke() {
            void $this$addAdapter$iv;
            MoshiChatParser moshiChatParser = this.this$0;
            Moshi.Builder builder = new Moshi.Builder();
            JsonAdapter adapter$iv = new DateAdapter();
            boolean $i$f$addAdapter = false;
            void var5_5 = $this$addAdapter$iv;
            boolean bl = false;
            boolean bl2 = false;
            void $this$addAdapter_u24lambda_u2d0$iv = var5_5;
            boolean bl3 = false;
            $this$addAdapter_u24lambda_u2d0$iv.add((Type)((Object)Date.class), adapter$iv);
            return var5_5.add((JsonAdapter.Factory)new EventAdapterFactory()).add((Object)DownstreamMessageDtoAdapter.INSTANCE).add((Object)UpstreamMessageDtoAdapter.INSTANCE).add((Object)DownstreamChannelDtoAdapter.INSTANCE).add((Object)UpstreamChannelDtoAdapter.INSTANCE).add((Object)AttachmentDtoAdapter.INSTANCE).add((Object)DownstreamReactionDtoAdapter.INSTANCE).add((Object)UpstreamReactionDtoAdapter.INSTANCE).add((Object)DownstreamUserDtoAdapter.INSTANCE).add((Object)UpstreamUserDtoAdapter.INSTANCE).build();
        }
    }));
    private final JsonAdapter<Map<?, ?>> mapAdapter = this.getMoshi().adapter(Map.class);
    private final JsonAdapter<UpstreamConnectedEventDto> upstreamConnectedEventAdapter = this.getMoshi().adapter(UpstreamConnectedEventDto.class);
    private final JsonAdapter<SocketErrorResponse> socketErrorResponseAdapter = this.getMoshi().adapter(SocketErrorResponse.class);
    private final JsonAdapter<SocketErrorResponse.ErrorResponse> errorResponseAdapter = this.getMoshi().adapter(SocketErrorResponse.ErrorResponse.class);
    private final JsonAdapter<ChatEventDto> chatEventDtoAdapter = this.getMoshi().adapter(ChatEventDto.class);

    @NotNull
    public final TaggedLogger getLogger() {
        return this.logger;
    }

    private final Moshi getMoshi() {
        Lazy lazy = this.moshi$delegate;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-moshi>(...)");
        return (Moshi)object;
    }

    private final /* synthetic */ <T> Moshi.Builder addAdapter(Moshi.Builder $this$addAdapter, JsonAdapter<T> adapter) {
        boolean $i$f$addAdapter = false;
        Moshi.Builder builder = $this$addAdapter;
        boolean bl = false;
        boolean bl2 = false;
        Moshi.Builder $this$addAdapter_u24lambda_u2d0 = builder;
        boolean bl3 = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        $this$addAdapter_u24lambda_u2d0.add((Type)((Object)Object.class), adapter);
        return builder;
    }

    @Override
    @NotNull
    public Retrofit.Builder configRetrofit(@NotNull Retrofit.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Retrofit.Builder builder2 = builder.addConverterFactory((Converter.Factory)new MoshiUrlQueryPayloadFactory(this.getMoshi()));
        MoshiConverterFactory moshiConverterFactory = MoshiConverterFactory.create((Moshi)this.getMoshi());
        Intrinsics.checkNotNullExpressionValue((Object)moshiConverterFactory, (String)"create(moshi)");
        Retrofit.Builder builder3 = builder2.addConverterFactory(MoshiErrorLoggingKt.withErrorLogging(moshiConverterFactory));
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"builder\n            .addConverterFactory(MoshiUrlQueryPayloadFactory(moshi))\n            .addConverterFactory(MoshiConverterFactory.create(moshi).withErrorLogging())");
        return builder3;
    }

    @Override
    @NotNull
    public String toJson(@NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        if (Map.class.isAssignableFrom(any.getClass())) {
            return this.serializeMap(any);
        }
        if (any instanceof ConnectedEvent) {
            return this.serializeConnectedEvent((ConnectedEvent)any);
        }
        JsonAdapter adapter = this.getMoshi().adapter(any.getClass());
        String string2 = adapter.toJson(any);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"adapter.toJson(any)");
        return string2;
    }

    private final String serializeMap(Object any) {
        String string2 = this.mapAdapter.toJson((Object)((Map)any));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mapAdapter.toJson(any as Map<*, *>)");
        return string2;
    }

    private final String serializeConnectedEvent(ConnectedEvent connectedEvent) {
        UpstreamConnectedEventDto eventDto = EventMappingKt.toDto(connectedEvent);
        String string2 = this.upstreamConnectedEventAdapter.toJson((Object)eventDto);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"upstreamConnectedEventAdapter.toJson(eventDto)");
        return string2;
    }

    @Override
    @NotNull
    public <T> T fromJson(@NotNull String raw, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        try {
            if (Intrinsics.areEqual(clazz, ChatEvent.class)) {
                return (T)this.parseAndProcessEvent(raw);
            }
            if (Intrinsics.areEqual(clazz, SocketErrorMessage.class)) {
                return (T)this.parseSocketError(raw);
            }
            if (Intrinsics.areEqual(clazz, ErrorResponse.class)) {
                return (T)this.parseErrorResponse(raw);
            }
            JsonAdapter adapter = this.getMoshi().adapter(clazz);
            Object object = adapter.fromJson(raw);
            Intrinsics.checkNotNull((Object)object);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"adapter.fromJson(raw)!!");
            return (T)object2;
        }
        catch (Exception e) {
            this.logger.logE(e);
            throw e;
        }
    }

    private final SocketErrorMessage parseSocketError(String raw) {
        Object object = this.socketErrorResponseAdapter.fromJson(raw);
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"socketErrorResponseAdapter.fromJson(raw)!!");
        return SocketErrorMappingKt.toDomain((SocketErrorResponse)object2);
    }

    private final ErrorResponse parseErrorResponse(String raw) {
        Object object = this.errorResponseAdapter.fromJson(raw);
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"errorResponseAdapter.fromJson(raw)!!");
        return SocketErrorMappingKt.toDomain((SocketErrorResponse.ErrorResponse)object2);
    }

    private final ChatEvent parseAndProcessEvent(String raw) {
        Object object = this.chatEventDtoAdapter.fromJson(raw);
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"chatEventDtoAdapter.fromJson(raw)!!");
        ChatEvent event = EventMappingKt.toDomain((ChatEventDto)object2);
        return this.enrichIfNeeded(event);
    }

    private final ChatEvent enrichIfNeeded(ChatEvent $this$enrichIfNeeded) {
        ChatEvent chatEvent = $this$enrichIfNeeded;
        boolean bl = false;
        boolean bl2 = false;
        ChatEvent $this$enrichIfNeeded_u24lambda_u2d1 = chatEvent;
        boolean bl3 = false;
        ChatEvent chatEvent2 = $this$enrichIfNeeded_u24lambda_u2d1;
        if (chatEvent2 instanceof NewMessageEvent) {
            MessageExtensionsKt.enrichWithCid(((NewMessageEvent)$this$enrichIfNeeded_u24lambda_u2d1).getMessage(), ((NewMessageEvent)$this$enrichIfNeeded_u24lambda_u2d1).getCid());
        } else if (chatEvent2 instanceof MessageDeletedEvent) {
            MessageExtensionsKt.enrichWithCid(((MessageDeletedEvent)$this$enrichIfNeeded_u24lambda_u2d1).getMessage(), ((MessageDeletedEvent)$this$enrichIfNeeded_u24lambda_u2d1).getCid());
        } else if (chatEvent2 instanceof MessageUpdatedEvent) {
            MessageExtensionsKt.enrichWithCid(((MessageUpdatedEvent)$this$enrichIfNeeded_u24lambda_u2d1).getMessage(), ((MessageUpdatedEvent)$this$enrichIfNeeded_u24lambda_u2d1).getCid());
        } else if (chatEvent2 instanceof ReactionNewEvent) {
            MessageExtensionsKt.enrichWithCid(((ReactionNewEvent)$this$enrichIfNeeded_u24lambda_u2d1).getMessage(), ((ReactionNewEvent)$this$enrichIfNeeded_u24lambda_u2d1).getCid());
        } else if (chatEvent2 instanceof ReactionUpdateEvent) {
            MessageExtensionsKt.enrichWithCid(((ReactionUpdateEvent)$this$enrichIfNeeded_u24lambda_u2d1).getMessage(), ((ReactionUpdateEvent)$this$enrichIfNeeded_u24lambda_u2d1).getCid());
        } else if (chatEvent2 instanceof ReactionDeletedEvent) {
            MessageExtensionsKt.enrichWithCid(((ReactionDeletedEvent)$this$enrichIfNeeded_u24lambda_u2d1).getMessage(), ((ReactionDeletedEvent)$this$enrichIfNeeded_u24lambda_u2d1).getCid());
        } else if (chatEvent2 instanceof ChannelUpdatedEvent) {
            Message message = ((ChannelUpdatedEvent)$this$enrichIfNeeded_u24lambda_u2d1).getMessage();
            if (message != null) {
                MessageExtensionsKt.enrichWithCid(message, ((ChannelUpdatedEvent)$this$enrichIfNeeded_u24lambda_u2d1).getCid());
            }
        } else if (chatEvent2 instanceof ChannelUpdatedByUserEvent) {
            Message message = ((ChannelUpdatedByUserEvent)$this$enrichIfNeeded_u24lambda_u2d1).getMessage();
            if (message != null) {
                MessageExtensionsKt.enrichWithCid(message, ((ChannelUpdatedByUserEvent)$this$enrichIfNeeded_u24lambda_u2d1).getCid());
            }
        } else if (chatEvent2 instanceof NotificationMessageNewEvent) {
            MessageExtensionsKt.enrichWithCid(((NotificationMessageNewEvent)$this$enrichIfNeeded_u24lambda_u2d1).getMessage(), ((NotificationMessageNewEvent)$this$enrichIfNeeded_u24lambda_u2d1).getCid());
        }
        return chatEvent;
    }

    @Override
    @NotNull
    public <T> Result<T> fromJsonOrError(@NotNull String raw, @NotNull Class<T> clazz) {
        return ChatParser.DefaultImpls.fromJsonOrError(this, raw, clazz);
    }

    @Override
    @NotNull
    public ChatNetworkError toError(@NotNull Response okHttpResponse) {
        return ChatParser.DefaultImpls.toError(this, okHttpResponse);
    }
}

