/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications;

import android.content.Context;
import android.content.SharedPreferences;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.notifications.DeviceRegisteredListener;
import io.getstream.chat.android.client.notifications.handler.ChatNotificationHandler;
import io.getstream.chat.android.client.utils.Result;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lio/getstream/chat/android/client/notifications/PushTokenUpdateHandler;", "", "context", "Landroid/content/Context;", "handler", "Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;", "(Landroid/content/Context;Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;)V", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "prefs", "Landroid/content/SharedPreferences;", "value", "Lio/getstream/chat/android/client/notifications/PushTokenUpdateHandler$UserFirebaseToken;", "userFirebaseToken", "getUserFirebaseToken", "()Lio/getstream/chat/android/client/notifications/PushTokenUpdateHandler$UserFirebaseToken;", "setUserFirebaseToken", "(Lio/getstream/chat/android/client/notifications/PushTokenUpdateHandler$UserFirebaseToken;)V", "updateTokenIfNecessary", "", "firebaseToken", "", "Companion", "UserFirebaseToken", "stream-chat-android-client_release"})
public final class PushTokenUpdateHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatNotificationHandler handler;
    @NotNull
    private final TaggedLogger logger;
    @NotNull
    private final SharedPreferences prefs;
    @NotNull
    private static final String PREFS_NAME = "stream_firebase_token_store";
    @NotNull
    private static final String KEY_USER_ID = "user_id";
    @NotNull
    private static final String KEY_FIREBASE_TOKEN = "firebase_token";

    public PushTokenUpdateHandler(@NotNull Context context, @NotNull ChatNotificationHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        this.handler = handler2;
        this.logger = ChatLogger.Companion.get("ChatNotifications");
        SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(PREFS_NAME, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.applicationContext.getSharedPreferences(\n        PREFS_NAME,\n        Context.MODE_PRIVATE\n    )");
        this.prefs = sharedPreferences;
    }

    private final UserFirebaseToken getUserFirebaseToken() {
        String key$iv;
        SharedPreferences $this$getNonNullString$iv;
        SharedPreferences sharedPreferences = this.prefs;
        String string = KEY_USER_ID;
        String defaultValue$iv = "";
        boolean $i$f$getNonNullString = false;
        String string2 = $this$getNonNullString$iv.getString(key$iv, defaultValue$iv);
        Intrinsics.checkNotNull((Object)string2);
        String string3 = string2;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(key, defaultValue)!!");
        String string4 = string3;
        $this$getNonNullString$iv = this.prefs;
        key$iv = KEY_FIREBASE_TOKEN;
        defaultValue$iv = "";
        $i$f$getNonNullString = false;
        String string5 = $this$getNonNullString$iv.getString(key$iv, defaultValue$iv);
        Intrinsics.checkNotNull((Object)string5);
        string3 = string5;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(key, defaultValue)!!");
        return new UserFirebaseToken(string4, string3);
    }

    private final void setUserFirebaseToken(UserFirebaseToken value) {
        this.prefs.edit().putString(KEY_USER_ID, value.getUserId()).putString(KEY_FIREBASE_TOKEN, value.getFirebaseToken()).apply();
    }

    public final void updateTokenIfNecessary(@NotNull String firebaseToken) {
        String string;
        Intrinsics.checkNotNullParameter((Object)firebaseToken, (String)"firebaseToken");
        User user = ChatClient.Companion.instance().getCurrentUser();
        UserFirebaseToken userFirebaseToken = new UserFirebaseToken(user == null ? "" : ((string = user.getId()) == null ? "" : string), firebaseToken);
        if (!Intrinsics.areEqual((Object)this.getUserFirebaseToken(), (Object)userFirebaseToken)) {
            ChatClient.Companion.instance().addDevice(firebaseToken).enqueue(arg_0 -> PushTokenUpdateHandler.updateTokenIfNecessary$lambda-0(this, userFirebaseToken, firebaseToken, arg_0));
        }
    }

    private static final void updateTokenIfNecessary$lambda-0(PushTokenUpdateHandler this$0, UserFirebaseToken $userFirebaseToken, String $firebaseToken, Result result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$userFirebaseToken, (String)"$userFirebaseToken");
        Intrinsics.checkNotNullParameter((Object)$firebaseToken, (String)"$firebaseToken");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (result.isSuccess()) {
            this$0.setUserFirebaseToken($userFirebaseToken);
            DeviceRegisteredListener deviceRegisteredListener = this$0.handler.getDeviceRegisteredListener();
            if (deviceRegisteredListener != null) {
                deviceRegisteredListener.onDeviceRegisteredSuccess();
            }
            this$0.logger.logI(Intrinsics.stringPlus((String)"Device registered with token ", (Object)$firebaseToken));
        } else {
            DeviceRegisteredListener deviceRegisteredListener = this$0.handler.getDeviceRegisteredListener();
            if (deviceRegisteredListener != null) {
                deviceRegisteredListener.onDeviceRegisteredError(result.error());
            }
            this$0.logger.logE(Intrinsics.stringPlus((String)"Error registering device ", (Object)result.error().getMessage()));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lio/getstream/chat/android/client/notifications/PushTokenUpdateHandler$UserFirebaseToken;", "", "userId", "", "firebaseToken", "(Ljava/lang/String;Ljava/lang/String;)V", "getFirebaseToken", "()Ljava/lang/String;", "getUserId", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "stream-chat-android-client_release"})
    private static final class UserFirebaseToken {
        @NotNull
        private final String userId;
        @NotNull
        private final String firebaseToken;

        public UserFirebaseToken(@NotNull String userId, @NotNull String firebaseToken) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)firebaseToken, (String)"firebaseToken");
            this.userId = userId;
            this.firebaseToken = firebaseToken;
        }

        @NotNull
        public final String getUserId() {
            return this.userId;
        }

        @NotNull
        public final String getFirebaseToken() {
            return this.firebaseToken;
        }

        @NotNull
        public final String component1() {
            return this.userId;
        }

        @NotNull
        public final String component2() {
            return this.firebaseToken;
        }

        @NotNull
        public final UserFirebaseToken copy(@NotNull String userId, @NotNull String firebaseToken) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)firebaseToken, (String)"firebaseToken");
            return new UserFirebaseToken(userId, firebaseToken);
        }

        public static /* synthetic */ UserFirebaseToken copy$default(UserFirebaseToken userFirebaseToken, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = userFirebaseToken.userId;
            }
            if ((n & 2) != 0) {
                string2 = userFirebaseToken.firebaseToken;
            }
            return userFirebaseToken.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "UserFirebaseToken(userId=" + this.userId + ", firebaseToken=" + this.firebaseToken + ')';
        }

        public int hashCode() {
            int result = this.userId.hashCode();
            result = result * 31 + this.firebaseToken.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UserFirebaseToken)) {
                return false;
            }
            UserFirebaseToken userFirebaseToken = (UserFirebaseToken)other;
            if (!Intrinsics.areEqual((Object)this.userId, (Object)userFirebaseToken.userId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.firebaseToken, (Object)userFirebaseToken.firebaseToken);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/getstream/chat/android/client/notifications/PushTokenUpdateHandler$Companion;", "", "()V", "KEY_FIREBASE_TOKEN", "", "KEY_USER_ID", "PREFS_NAME", "stream-chat-android-client_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

