/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.socket;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import io.getstream.chat.android.client.clientstate.DisconnectCause;
import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.errors.ChatErrorCode;
import io.getstream.chat.android.client.errors.ChatNetworkError;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.events.ConnectedEvent;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.network.NetworkStateProvider;
import io.getstream.chat.android.client.parser.ChatParser;
import io.getstream.chat.android.client.socket.ChatSocketService;
import io.getstream.chat.android.client.socket.ChatSocketServiceImpl;
import io.getstream.chat.android.client.socket.EventsParser;
import io.getstream.chat.android.client.socket.HealthMonitor;
import io.getstream.chat.android.client.socket.Socket;
import io.getstream.chat.android.client.socket.SocketFactory;
import io.getstream.chat.android.client.socket.SocketListener;
import io.getstream.chat.android.client.token.TokenManager;
import io.getstream.chat.android.core.internal.coroutines.DispatcherProvider;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00af\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u001b\b\u0000\u0018\u00002\u00020\u0001:\u0002OPB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0017H\u0016J\u0018\u00101\u001a\u00020/2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000203H\u0016J\u001c\u00105\u001a\u00020/2\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020/07H\u0002J\u0010\u00108\u001a\u00020/2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u00109\u001a\u00020\u0012H\u0002J\b\u0010:\u001a\u00020/H\u0016J\u0010\u0010;\u001a\u00020/2\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020/2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020/2\u0006\u0010?\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020/2\u0006\u0010<\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020/2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010F\u001a\u00020/H\u0016J\u0010\u0010G\u001a\u00020/2\u0006\u00100\u001a\u00020\u0017H\u0016J\u0015\u0010H\u001a\u00020/2\u0006\u0010?\u001a\u00020BH\u0000\u00a2\u0006\u0002\bIJ\u0010\u0010J\u001a\u00020/2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010K\u001a\u00020/H\u0002J \u0010L\u001a\u00020/2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u0010M\u001a\u00020NH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u0010%\u001a\u00020$2\u0006\u0010#\u001a\u00020$8@@BX\u0081\u008e\u0002\u00a2\u0006\u0018\n\u0004\b,\u0010-\u0012\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl;", "Lio/getstream/chat/android/client/socket/ChatSocketService;", "tokenManager", "Lio/getstream/chat/android/client/token/TokenManager;", "socketFactory", "Lio/getstream/chat/android/client/socket/SocketFactory;", "networkStateProvider", "Lio/getstream/chat/android/client/network/NetworkStateProvider;", "parser", "Lio/getstream/chat/android/client/parser/ChatParser;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lio/getstream/chat/android/client/token/TokenManager;Lio/getstream/chat/android/client/socket/SocketFactory;Lio/getstream/chat/android/client/network/NetworkStateProvider;Lio/getstream/chat/android/client/parser/ChatParser;Lkotlinx/coroutines/CoroutineScope;)V", "connectionConf", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf;", "eventUiHandler", "Landroid/os/Handler;", "eventsParser", "Lio/getstream/chat/android/client/socket/EventsParser;", "healthMonitor", "Lio/getstream/chat/android/client/socket/HealthMonitor;", "listeners", "", "Lio/getstream/chat/android/client/socket/SocketListener;", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "networkStateListener", "io/getstream/chat/android/client/socket/ChatSocketServiceImpl$networkStateListener$1", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$networkStateListener$1;", "reconnectionAttempts", "", "socket", "Lio/getstream/chat/android/client/socket/Socket;", "socketConnectionJob", "Lkotlinx/coroutines/Job;", "<set-?>", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", "state", "getState$stream_chat_android_client_release$annotations", "()V", "getState$stream_chat_android_client_release", "()Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", "setState", "(Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;)V", "state$delegate", "Lkotlin/properties/ReadWriteProperty;", "addListener", "", "listener", "anonymousConnect", "endpoint", "", "apiKey", "callListeners", "call", "Lkotlin/Function1;", "connect", "createNewEventsParser", "disconnect", "onChatNetworkError", "error", "Lio/getstream/chat/android/client/errors/ChatNetworkError;", "onConnectionResolved", "event", "Lio/getstream/chat/android/client/events/ConnectedEvent;", "onEvent", "Lio/getstream/chat/android/client/events/ChatEvent;", "onSocketError", "Lio/getstream/chat/android/client/errors/ChatError;", "reconnect", "releaseConnection", "removeListener", "sendEvent", "sendEvent$stream_chat_android_client_release", "setupSocket", "shutdownSocketConnection", "userConnect", "user", "Lio/getstream/chat/android/client/models/User;", "ConnectionConf", "State", "stream-chat-android-client_release"})
public final class ChatSocketServiceImpl
implements ChatSocketService {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final TokenManager tokenManager;
    @NotNull
    private final SocketFactory socketFactory;
    @NotNull
    private final NetworkStateProvider networkStateProvider;
    @NotNull
    private final ChatParser parser;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final TaggedLogger logger;
    @NotNull
    private ConnectionConf connectionConf;
    @Nullable
    private Socket socket;
    @Nullable
    private EventsParser eventsParser;
    @Nullable
    private Job socketConnectionJob;
    @NotNull
    private final List<SocketListener> listeners;
    @NotNull
    private final Handler eventUiHandler;
    @NotNull
    private final HealthMonitor healthMonitor;
    @NotNull
    private final networkStateListener.1 networkStateListener;
    private int reconnectionAttempts;
    @NotNull
    private final ReadWriteProperty state$delegate;

    /*
     * WARNING - void declaration
     */
    public ChatSocketServiceImpl(@NotNull TokenManager tokenManager, @NotNull SocketFactory socketFactory, @NotNull NetworkStateProvider networkStateProvider, @NotNull ChatParser parser, @NotNull CoroutineScope coroutineScope) {
        void initialValue$iv;
        Intrinsics.checkNotNullParameter((Object)tokenManager, (String)"tokenManager");
        Intrinsics.checkNotNullParameter((Object)socketFactory, (String)"socketFactory");
        Intrinsics.checkNotNullParameter((Object)networkStateProvider, (String)"networkStateProvider");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.tokenManager = tokenManager;
        this.socketFactory = socketFactory;
        this.networkStateProvider = networkStateProvider;
        this.parser = parser;
        this.coroutineScope = coroutineScope;
        this.logger = ChatLogger.Companion.get("SocketService");
        this.connectionConf = ConnectionConf.None.INSTANCE;
        boolean bl = false;
        this.listeners = new ArrayList();
        this.eventUiHandler = new Handler(Looper.getMainLooper());
        this.healthMonitor = new HealthMonitor(new HealthMonitor.HealthCallback(this){
            final /* synthetic */ ChatSocketServiceImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void reconnect() {
                if (this.this$0.getState$stream_chat_android_client_release() instanceof State.DisconnectedTemporarily) {
                    ChatSocketServiceImpl.access$reconnect(this.this$0, ChatSocketServiceImpl.access$getConnectionConf$p(this.this$0));
                }
            }

            public void check() {
                State.Connected connected;
                State state2 = this.this$0.getState$stream_chat_android_client_release();
                State.Connected connected2 = connected = state2 instanceof State.Connected ? (State.Connected)state2 : null;
                if (connected != null) {
                    state2 = connected;
                    ChatSocketServiceImpl chatSocketServiceImpl = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    State it = state2;
                    boolean bl3 = false;
                    chatSocketServiceImpl.sendEvent$stream_chat_android_client_release(((State.Connected)it).getEvent());
                }
            }
        });
        this.networkStateListener = new NetworkStateProvider.NetworkStateListener(this){
            final /* synthetic */ ChatSocketServiceImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void onConnected() {
                if (this.this$0.getState$stream_chat_android_client_release() instanceof State.DisconnectedTemporarily || Intrinsics.areEqual((Object)this.this$0.getState$stream_chat_android_client_release(), (Object)State.NetworkDisconnected.INSTANCE)) {
                    ChatSocketServiceImpl.access$getLogger$p(this.this$0).logI("network connected, reconnecting socket");
                    ChatSocketServiceImpl.access$reconnect(this.this$0, ChatSocketServiceImpl.access$getConnectionConf$p(this.this$0));
                }
            }

            public void onDisconnected() {
                ChatSocketServiceImpl.access$getHealthMonitor$p(this.this$0).stop();
                if (this.this$0.getState$stream_chat_android_client_release() instanceof State.Connected || this.this$0.getState$stream_chat_android_client_release() instanceof State.Connecting) {
                    ChatSocketServiceImpl.access$setState(this.this$0, State.NetworkDisconnected.INSTANCE);
                }
            }
        };
        Delegates delegates = Delegates.INSTANCE;
        State.DisconnectedTemporarily disconnectedTemporarily = new State.DisconnectedTemporarily(null);
        boolean $i$f$observable = false;
        this.state$delegate = (ReadWriteProperty)new ObservableProperty<State>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ ChatSocketServiceImpl this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = chatSocketServiceImpl;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newState;
                void oldState;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                State state2 = (State)newValue;
                State state3 = (State)oldValue;
                KProperty $noName_0 = property;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)oldState, (Object)newState)) {
                    ChatSocketServiceImpl.access$getLogger$p(this.this$0).logI(Intrinsics.stringPlus((String)"updateState: ", (Object)newState.getClass().getSimpleName()));
                    void var8_8 = newState;
                    if (var8_8 instanceof State.Connecting) {
                        ChatSocketServiceImpl.access$getHealthMonitor$p(this.this$0).stop();
                        ChatSocketServiceImpl.access$callListeners(this.this$0, state.2.1.INSTANCE);
                    } else if (var8_8 instanceof State.Connected) {
                        ChatSocketServiceImpl.access$getHealthMonitor$p(this.this$0).start();
                        ChatSocketServiceImpl.access$callListeners(this.this$0, (Function1)new Function1<SocketListener, Unit>((State)newState){
                            final /* synthetic */ State $newState;
                            {
                                this.$newState = $newState;
                                super(1);
                            }

                            public final void invoke(@NotNull SocketListener it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                it.onConnected(((State.Connected)this.$newState).getEvent());
                            }
                        });
                    } else if (var8_8 instanceof State.NetworkDisconnected) {
                        ChatSocketServiceImpl.access$shutdownSocketConnection(this.this$0);
                        ChatSocketServiceImpl.access$getHealthMonitor$p(this.this$0).stop();
                        ChatSocketServiceImpl.access$callListeners(this.this$0, state.2.3.INSTANCE);
                    } else if (var8_8 instanceof State.DisconnectedByRequest) {
                        ChatSocketServiceImpl.access$shutdownSocketConnection(this.this$0);
                        ChatSocketServiceImpl.access$getHealthMonitor$p(this.this$0).stop();
                        ChatSocketServiceImpl.access$callListeners(this.this$0, state.2.4.INSTANCE);
                    } else if (var8_8 instanceof State.DisconnectedTemporarily) {
                        ChatSocketServiceImpl.access$shutdownSocketConnection(this.this$0);
                        ChatSocketServiceImpl.access$getHealthMonitor$p(this.this$0).onDisconnected();
                        ChatSocketServiceImpl.access$callListeners(this.this$0, (Function1)new Function1<SocketListener, Unit>((State)newState){
                            final /* synthetic */ State $newState;
                            {
                                this.$newState = $newState;
                                super(1);
                            }

                            public final void invoke(@NotNull SocketListener it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                it.onDisconnected(new DisconnectCause.Error(((State.DisconnectedTemporarily)this.$newState).getError()));
                            }
                        });
                    } else if (var8_8 instanceof State.DisconnectedPermanently) {
                        ChatSocketServiceImpl.access$shutdownSocketConnection(this.this$0);
                        ChatSocketServiceImpl.access$setConnectionConf$p(this.this$0, ConnectionConf.None.INSTANCE);
                        ChatSocketServiceImpl.access$getNetworkStateProvider$p(this.this$0).unsubscribe(ChatSocketServiceImpl.access$getNetworkStateListener$p(this.this$0));
                        ChatSocketServiceImpl.access$getHealthMonitor$p(this.this$0).stop();
                        ChatSocketServiceImpl.access$callListeners(this.this$0, (Function1)new Function1<SocketListener, Unit>((State)newState){
                            final /* synthetic */ State $newState;
                            {
                                this.$newState = $newState;
                                super(1);
                            }

                            public final void invoke(@NotNull SocketListener it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                it.onDisconnected(new DisconnectCause.UnrecoverableError(((State.DisconnectedPermanently)this.$newState).getError()));
                            }
                        });
                    }
                }
            }
        };
    }

    @NotNull
    public final State getState$stream_chat_android_client_release() {
        return (State)this.state$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setState(State state2) {
        this.state$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)state2);
    }

    @VisibleForTesting
    public static /* synthetic */ void getState$stream_chat_android_client_release$annotations() {
    }

    @Override
    public void onSocketError(@NotNull ChatError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (!(this.getState$stream_chat_android_client_release() instanceof State.DisconnectedPermanently)) {
            ChatNetworkError chatNetworkError;
            this.logger.logE(error);
            this.callListeners((Function1<? super SocketListener, Unit>)((Function1)new Function1<SocketListener, Unit>(error){
                final /* synthetic */ ChatError $error;
                {
                    this.$error = $error;
                    super(1);
                }

                public final void invoke(@NotNull SocketListener it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.onError(this.$error);
                }
            }));
            ChatNetworkError chatNetworkError2 = chatNetworkError = error instanceof ChatNetworkError ? (ChatNetworkError)error : null;
            if (chatNetworkError != null) {
                ChatNetworkError chatNetworkError3 = chatNetworkError;
                boolean bl = false;
                boolean bl2 = false;
                ChatNetworkError p0 = chatNetworkError3;
                boolean bl3 = false;
                this.onChatNetworkError(p0);
            }
        }
    }

    private final void onChatNetworkError(ChatNetworkError error) {
        int n;
        if (ChatErrorCode.Companion.isAuthenticationError(error.getStreamCode())) {
            this.tokenManager.expireToken();
        }
        if (((((n = error.getStreamCode()) == ChatErrorCode.PARSER_ERROR.getCode() ? true : n == ChatErrorCode.CANT_PARSE_CONNECTION_EVENT.getCode()) ? true : n == ChatErrorCode.CANT_PARSE_EVENT.getCode()) ? true : n == ChatErrorCode.UNABLE_TO_PARSE_SOCKET_EVENT.getCode()) ? true : n == ChatErrorCode.NO_ERROR_BODY.getCode()) {
            if (this.reconnectionAttempts < 3) {
                BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ ChatSocketServiceImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                var2_3 = ChatSocketServiceImpl.access$getReconnectionAttempts$p(this.this$0);
                                var4_5 = 2.0;
                                var6_6 = false;
                                this.label = 1;
                                v0 = DelayKt.delay((long)((long)500 * (long)Math.pow(var2_3, var4_5)), (Continuation)((Continuation)this));
                                if (v0 == var7_2) {
                                    return var7_2;
                                }
                                ** GOTO lbl16
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl16:
                                // 2 sources

                                ChatSocketServiceImpl.access$reconnect(this.this$0, ChatSocketServiceImpl.access$getConnectionConf$p(this.this$0));
                                var2_4 = this.this$0;
                                ChatSocketServiceImpl.access$setReconnectionAttempts$p(var2_4, ChatSocketServiceImpl.access$getReconnectionAttempts$p(var2_4) + 1);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        } else if (((n == ChatErrorCode.UNDEFINED_TOKEN.getCode() ? true : n == ChatErrorCode.INVALID_TOKEN.getCode()) ? true : n == ChatErrorCode.API_KEY_NOT_FOUND.getCode()) ? true : n == ChatErrorCode.VALIDATION_ERROR.getCode()) {
            this.setState(new State.DisconnectedPermanently(error));
        } else {
            this.setState(new State.DisconnectedTemporarily(error));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(@NotNull SocketListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        List<SocketListener> list = this.listeners;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            bl2 = this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(@NotNull SocketListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        List<SocketListener> list = this.listeners;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            bl2 = this.listeners.add(listener);
        }
    }

    @Override
    public void anonymousConnect(@NotNull String endpoint, @NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.connect(new ConnectionConf.AnonymousConnectionConf(endpoint, apiKey));
    }

    @Override
    public void userConnect(@NotNull String endpoint, @NotNull String apiKey, @NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.connect(new ConnectionConf.UserConnectionConf(endpoint, apiKey, user));
    }

    private final void connect(ConnectionConf connectionConf) {
        this.logger.logI("connect");
        this.connectionConf = connectionConf;
        if (this.networkStateProvider.isConnected()) {
            this.setupSocket(connectionConf);
        } else {
            this.setState(State.NetworkDisconnected.INSTANCE);
        }
        this.networkStateProvider.subscribe(this.networkStateListener);
    }

    @Override
    public void disconnect() {
        this.reconnectionAttempts = 0;
        this.setState(new State.DisconnectedPermanently(null));
    }

    @Override
    public void releaseConnection() {
        this.setState(State.DisconnectedByRequest.INSTANCE);
    }

    @Override
    public void onConnectionResolved(@NotNull ConnectedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.setState(new State.Connected(event));
    }

    @Override
    public void onEvent(@NotNull ChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.healthMonitor.ack();
        this.callListeners((Function1<? super SocketListener, Unit>)((Function1)new Function1<SocketListener, Unit>(event){
            final /* synthetic */ ChatEvent $event;
            {
                this.$event = $event;
                super(1);
            }

            public final void invoke(@NotNull SocketListener listener) {
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                listener.onEvent(this.$event);
            }
        }));
    }

    public final void sendEvent$stream_chat_android_client_release(@NotNull ChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Socket socket = this.socket;
        if (socket != null) {
            socket.send(event);
        }
    }

    private final void reconnect(ConnectionConf connectionConf) {
        this.shutdownSocketConnection();
        this.setupSocket(connectionConf);
    }

    private final void setupSocket(ConnectionConf connectionConf) {
        this.logger.logI("setupSocket");
        boolean bl = false;
        boolean bl2 = false;
        ConnectionConf $this$setupSocket_u24lambda_u2d3 = connectionConf;
        boolean bl3 = false;
        ConnectionConf connectionConf2 = $this$setupSocket_u24lambda_u2d3;
        if (connectionConf2 instanceof ConnectionConf.None) {
            this.setState(new State.DisconnectedPermanently(null));
        } else if (connectionConf2 instanceof ConnectionConf.AnonymousConnectionConf) {
            this.setState(State.Connecting.INSTANCE);
            this.socket = this.socketFactory.createAnonymousSocket(this.createNewEventsParser(), ((ConnectionConf.AnonymousConnectionConf)$this$setupSocket_u24lambda_u2d3).getEndpoint(), ((ConnectionConf.AnonymousConnectionConf)$this$setupSocket_u24lambda_u2d3).getApiKey());
        } else if (connectionConf2 instanceof ConnectionConf.UserConnectionConf) {
            this.setState(State.Connecting.INSTANCE);
            this.socketConnectionJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, $this$setupSocket_u24lambda_u2d3, null){
                int label;
                final /* synthetic */ ChatSocketServiceImpl this$0;
                final /* synthetic */ ConnectionConf $this_with;
                {
                    this.this$0 = $receiver;
                    this.$this_with = $receiver2;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ChatSocketServiceImpl.access$getTokenManager$p(this.this$0).ensureTokenLoaded();
                            this.label = 1;
                            Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$this_with, null){
                                int label;
                                final /* synthetic */ ChatSocketServiceImpl this$0;
                                final /* synthetic */ ConnectionConf $this_with;
                                {
                                    this.this$0 = $receiver;
                                    this.$this_with = $receiver2;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            ChatSocketServiceImpl.access$setSocket$p(this.this$0, ChatSocketServiceImpl.access$getSocketFactory$p(this.this$0).createNormalSocket(ChatSocketServiceImpl.access$createNewEventsParser(this.this$0), ((ConnectionConf.UserConnectionConf)this.$this_with).getEndpoint(), ((ConnectionConf.UserConnectionConf)this.$this_with).getApiKey(), ((ConnectionConf.UserConnectionConf)this.$this_with).getUser()));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        connectionConf2 = Unit.INSTANCE;
        boolean $i$f$getExhaustive = false;
    }

    private final EventsParser createNewEventsParser() {
        EventsParser eventsParser = new EventsParser(this.parser, this);
        boolean bl = false;
        boolean bl2 = false;
        EventsParser it = eventsParser;
        boolean bl3 = false;
        this.eventsParser = it;
        return eventsParser;
    }

    private final void shutdownSocketConnection() {
        Object object = this.socketConnectionJob;
        if (object != null) {
            Job.DefaultImpls.cancel$default((Job)object, null, (int)1, null);
        }
        object = this.eventsParser;
        if (object != null) {
            ((EventsParser)((Object)object)).closeByClient$stream_chat_android_client_release();
        }
        this.eventsParser = null;
        object = this.socket;
        if (object != null) {
            ((Socket)object).close(1000, "Connection close by client");
        }
        this.socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callListeners(Function1<? super SocketListener, Unit> call) {
        List<SocketListener> list = this.listeners;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SocketListener listener = (SocketListener)element$iv;
                boolean bl4 = false;
                this.eventUiHandler.post(() -> ChatSocketServiceImpl.callListeners$lambda-7$lambda-6$lambda-5(call, listener));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void callListeners$lambda-7$lambda-6$lambda-5(Function1 $call, SocketListener $listener) {
        Intrinsics.checkNotNullParameter((Object)$call, (String)"$call");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $call.invoke((Object)$listener);
    }

    public static final /* synthetic */ int access$getReconnectionAttempts$p(ChatSocketServiceImpl $this) {
        return $this.reconnectionAttempts;
    }

    public static final /* synthetic */ void access$reconnect(ChatSocketServiceImpl $this, ConnectionConf connectionConf) {
        $this.reconnect(connectionConf);
    }

    public static final /* synthetic */ ConnectionConf access$getConnectionConf$p(ChatSocketServiceImpl $this) {
        return $this.connectionConf;
    }

    public static final /* synthetic */ void access$setReconnectionAttempts$p(ChatSocketServiceImpl $this, int n) {
        $this.reconnectionAttempts = n;
    }

    public static final /* synthetic */ TaggedLogger access$getLogger$p(ChatSocketServiceImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ HealthMonitor access$getHealthMonitor$p(ChatSocketServiceImpl $this) {
        return $this.healthMonitor;
    }

    public static final /* synthetic */ void access$callListeners(ChatSocketServiceImpl $this, Function1 call) {
        $this.callListeners((Function1<? super SocketListener, Unit>)call);
    }

    public static final /* synthetic */ void access$shutdownSocketConnection(ChatSocketServiceImpl $this) {
        $this.shutdownSocketConnection();
    }

    public static final /* synthetic */ void access$setConnectionConf$p(ChatSocketServiceImpl $this, ConnectionConf connectionConf) {
        $this.connectionConf = connectionConf;
    }

    public static final /* synthetic */ NetworkStateProvider access$getNetworkStateProvider$p(ChatSocketServiceImpl $this) {
        return $this.networkStateProvider;
    }

    public static final /* synthetic */ networkStateListener.1 access$getNetworkStateListener$p(ChatSocketServiceImpl $this) {
        return $this.networkStateListener;
    }

    public static final /* synthetic */ TokenManager access$getTokenManager$p(ChatSocketServiceImpl $this) {
        return $this.tokenManager;
    }

    public static final /* synthetic */ void access$setSocket$p(ChatSocketServiceImpl $this, Socket socket) {
        $this.socket = socket;
    }

    public static final /* synthetic */ SocketFactory access$getSocketFactory$p(ChatSocketServiceImpl $this) {
        return $this.socketFactory;
    }

    public static final /* synthetic */ EventsParser access$createNewEventsParser(ChatSocketServiceImpl $this) {
        return $this.createNewEventsParser();
    }

    public static final /* synthetic */ void access$setState(ChatSocketServiceImpl $this, State state2) {
        $this.setState(state2);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ChatSocketServiceImpl.class), "state", "getState$stream_chat_android_client_release()Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;")))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf;", "", "()V", "AnonymousConnectionConf", "None", "UserConnectionConf", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf$None;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf$AnonymousConnectionConf;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf$UserConnectionConf;", "stream-chat-android-client_release"})
    public static abstract class ConnectionConf {
        private ConnectionConf() {
        }

        public /* synthetic */ ConnectionConf(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf$None;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf;", "()V", "stream-chat-android-client_release"})
        public static final class None
        extends ConnectionConf {
            @NotNull
            public static final None INSTANCE = new None();

            private None() {
                super(null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf$AnonymousConnectionConf;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf;", "endpoint", "", "apiKey", "(Ljava/lang/String;Ljava/lang/String;)V", "getApiKey", "()Ljava/lang/String;", "getEndpoint", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "stream-chat-android-client_release"})
        public static final class AnonymousConnectionConf
        extends ConnectionConf {
            @NotNull
            private final String endpoint;
            @NotNull
            private final String apiKey;

            public AnonymousConnectionConf(@NotNull String endpoint, @NotNull String apiKey) {
                Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
                Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
                super(null);
                this.endpoint = endpoint;
                this.apiKey = apiKey;
            }

            @NotNull
            public final String getEndpoint() {
                return this.endpoint;
            }

            @NotNull
            public final String getApiKey() {
                return this.apiKey;
            }

            @NotNull
            public final String component1() {
                return this.endpoint;
            }

            @NotNull
            public final String component2() {
                return this.apiKey;
            }

            @NotNull
            public final AnonymousConnectionConf copy(@NotNull String endpoint, @NotNull String apiKey) {
                Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
                Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
                return new AnonymousConnectionConf(endpoint, apiKey);
            }

            public static /* synthetic */ AnonymousConnectionConf copy$default(AnonymousConnectionConf anonymousConnectionConf, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = anonymousConnectionConf.endpoint;
                }
                if ((n & 2) != 0) {
                    string3 = anonymousConnectionConf.apiKey;
                }
                return anonymousConnectionConf.copy(string2, string3);
            }

            @NotNull
            public String toString() {
                return "AnonymousConnectionConf(endpoint=" + this.endpoint + ", apiKey=" + this.apiKey + ')';
            }

            public int hashCode() {
                int result = this.endpoint.hashCode();
                result = result * 31 + this.apiKey.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AnonymousConnectionConf)) {
                    return false;
                }
                AnonymousConnectionConf anonymousConnectionConf = (AnonymousConnectionConf)other;
                if (!Intrinsics.areEqual((Object)this.endpoint, (Object)anonymousConnectionConf.endpoint)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.apiKey, (Object)anonymousConnectionConf.apiKey);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf$UserConnectionConf;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$ConnectionConf;", "endpoint", "", "apiKey", "user", "Lio/getstream/chat/android/client/models/User;", "(Ljava/lang/String;Ljava/lang/String;Lio/getstream/chat/android/client/models/User;)V", "getApiKey", "()Ljava/lang/String;", "getEndpoint", "getUser", "()Lio/getstream/chat/android/client/models/User;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "stream-chat-android-client_release"})
        public static final class UserConnectionConf
        extends ConnectionConf {
            @NotNull
            private final String endpoint;
            @NotNull
            private final String apiKey;
            @NotNull
            private final User user;

            public UserConnectionConf(@NotNull String endpoint, @NotNull String apiKey, @NotNull User user) {
                Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
                Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                super(null);
                this.endpoint = endpoint;
                this.apiKey = apiKey;
                this.user = user;
            }

            @NotNull
            public final String getEndpoint() {
                return this.endpoint;
            }

            @NotNull
            public final String getApiKey() {
                return this.apiKey;
            }

            @NotNull
            public final User getUser() {
                return this.user;
            }

            @NotNull
            public final String component1() {
                return this.endpoint;
            }

            @NotNull
            public final String component2() {
                return this.apiKey;
            }

            @NotNull
            public final User component3() {
                return this.user;
            }

            @NotNull
            public final UserConnectionConf copy(@NotNull String endpoint, @NotNull String apiKey, @NotNull User user) {
                Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
                Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                return new UserConnectionConf(endpoint, apiKey, user);
            }

            public static /* synthetic */ UserConnectionConf copy$default(UserConnectionConf userConnectionConf, String string2, String string3, User user, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = userConnectionConf.endpoint;
                }
                if ((n & 2) != 0) {
                    string3 = userConnectionConf.apiKey;
                }
                if ((n & 4) != 0) {
                    user = userConnectionConf.user;
                }
                return userConnectionConf.copy(string2, string3, user);
            }

            @NotNull
            public String toString() {
                return "UserConnectionConf(endpoint=" + this.endpoint + ", apiKey=" + this.apiKey + ", user=" + this.user + ')';
            }

            public int hashCode() {
                int result = this.endpoint.hashCode();
                result = result * 31 + this.apiKey.hashCode();
                result = result * 31 + this.user.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UserConnectionConf)) {
                    return false;
                }
                UserConnectionConf userConnectionConf = (UserConnectionConf)other;
                if (!Intrinsics.areEqual((Object)this.endpoint, (Object)userConnectionConf.endpoint)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.apiKey, (Object)userConnectionConf.apiKey)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.user, (Object)userConnectionConf.user);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b1\u0018\u00002\u00020\u0001:\u0006\u0003\u0004\u0005\u0006\u0007\bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0006\t\n\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", "", "()V", "Connected", "Connecting", "DisconnectedByRequest", "DisconnectedPermanently", "DisconnectedTemporarily", "NetworkDisconnected", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$Connecting;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$Connected;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$NetworkDisconnected;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$DisconnectedTemporarily;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$DisconnectedPermanently;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$DisconnectedByRequest;", "stream-chat-android-client_release"})
    @VisibleForTesting
    public static abstract class State {
        private State() {
        }

        public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$Connecting;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", "()V", "stream-chat-android-client_release"})
        public static final class Connecting
        extends State {
            @NotNull
            public static final Connecting INSTANCE = new Connecting();

            private Connecting() {
                super(null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$Connected;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", "event", "Lio/getstream/chat/android/client/events/ConnectedEvent;", "(Lio/getstream/chat/android/client/events/ConnectedEvent;)V", "getEvent", "()Lio/getstream/chat/android/client/events/ConnectedEvent;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android-client_release"})
        public static final class Connected
        extends State {
            @NotNull
            private final ConnectedEvent event;

            public Connected(@NotNull ConnectedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                super(null);
                this.event = event;
            }

            @NotNull
            public final ConnectedEvent getEvent() {
                return this.event;
            }

            @NotNull
            public final ConnectedEvent component1() {
                return this.event;
            }

            @NotNull
            public final Connected copy(@NotNull ConnectedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return new Connected(event);
            }

            public static /* synthetic */ Connected copy$default(Connected connected, ConnectedEvent connectedEvent, int n, Object object) {
                if ((n & 1) != 0) {
                    connectedEvent = connected.event;
                }
                return connected.copy(connectedEvent);
            }

            @NotNull
            public String toString() {
                return "Connected(event=" + this.event + ')';
            }

            public int hashCode() {
                return this.event.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Connected)) {
                    return false;
                }
                Connected connected = (Connected)other;
                return Intrinsics.areEqual((Object)this.event, (Object)connected.event);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$NetworkDisconnected;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", "()V", "stream-chat-android-client_release"})
        public static final class NetworkDisconnected
        extends State {
            @NotNull
            public static final NetworkDisconnected INSTANCE = new NetworkDisconnected();

            private NetworkDisconnected() {
                super(null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$DisconnectedTemporarily;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", "error", "Lio/getstream/chat/android/client/errors/ChatNetworkError;", "(Lio/getstream/chat/android/client/errors/ChatNetworkError;)V", "getError", "()Lio/getstream/chat/android/client/errors/ChatNetworkError;", "stream-chat-android-client_release"})
        public static final class DisconnectedTemporarily
        extends State {
            @Nullable
            private final ChatNetworkError error;

            public DisconnectedTemporarily(@Nullable ChatNetworkError error) {
                super(null);
                this.error = error;
            }

            @Nullable
            public final ChatNetworkError getError() {
                return this.error;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$DisconnectedPermanently;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", "error", "Lio/getstream/chat/android/client/errors/ChatNetworkError;", "(Lio/getstream/chat/android/client/errors/ChatNetworkError;)V", "getError", "()Lio/getstream/chat/android/client/errors/ChatNetworkError;", "stream-chat-android-client_release"})
        public static final class DisconnectedPermanently
        extends State {
            @Nullable
            private final ChatNetworkError error;

            public DisconnectedPermanently(@Nullable ChatNetworkError error) {
                super(null);
                this.error = error;
            }

            @Nullable
            public final ChatNetworkError getError() {
                return this.error;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State$DisconnectedByRequest;", "Lio/getstream/chat/android/client/socket/ChatSocketServiceImpl$State;", "()V", "stream-chat-android-client_release"})
        public static final class DisconnectedByRequest
        extends State {
            @NotNull
            public static final DisconnectedByRequest INSTANCE = new DisconnectedByRequest();

            private DisconnectedByRequest() {
                super(null);
            }
        }
    }
}

