/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications.handler;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import androidx.core.app.RemoteInput;
import io.getstream.chat.android.client.R;
import io.getstream.chat.android.client.events.NewMessageEvent;
import io.getstream.chat.android.client.extensions.ChannelExtensionKt;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Device;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.PushMessage;
import io.getstream.chat.android.client.notifications.DeviceRegisteredListener;
import io.getstream.chat.android.client.notifications.NotificationLoadDataListener;
import io.getstream.chat.android.client.notifications.handler.ChatNotificationHandler;
import io.getstream.chat.android.client.notifications.handler.NotificationConfig;
import io.getstream.chat.android.client.notifications.handler.PushDeviceGenerator;
import io.getstream.chat.android.client.receivers.NotificationMessageReceiver;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 L2\u00020\u0001:\u0001LB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0017J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020 H\u0016J\b\u0010#\u001a\u00020\u0011H\u0016J \u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0016J(\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020\u001eH\u0002J\b\u0010-\u001a\u00020 H\u0016J\b\u0010.\u001a\u00020 H\u0016J\u0018\u0010/\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0016J\u0018\u00100\u001a\u00020\u00112\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u0002022\u0006\u00106\u001a\u000204H\u0002J\b\u00107\u001a\u00020\u0011H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016J0\u0010<\u001a\u00020=2!\u0010>\u001a\u001d\u0012\u0013\u0012\u00110@\u00a2\u0006\f\bA\u0012\b\bB\u0012\u0004\b\b(C\u0012\u0004\u0012\u00020=0?H\u0000\u00a2\u0006\u0002\bDJ\u0010\u0010E\u001a\u0002092\u0006\u0010\u0014\u001a\u00020FH\u0016J0\u0010G\u001a\u0002042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010%\u001a\u00020 2\u0006\u0010'\u001a\u00020 2\u0006\u0010H\u001a\u00020 2\u0006\u0010I\u001a\u00020 H\u0002J\u000e\u0010J\u001a\u0004\u0018\u00010 *\u00020\u0013H\u0002J\f\u0010K\u001a\u00020 *\u00020\u0013H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006M"}, d2={"Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;", "", "context", "Landroid/content/Context;", "config", "Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;", "(Landroid/content/Context;Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;)V", "getConfig", "()Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;", "getContext", "()Landroid/content/Context;", "buildErrorCaseNotification", "Landroid/app/Notification;", "buildErrorNotificationGroupSummary", "buildNotification", "Landroidx/core/app/NotificationCompat$Builder;", "notificationId", "", "channel", "Lio/getstream/chat/android/client/models/Channel;", "message", "Lio/getstream/chat/android/client/models/Message;", "buildNotificationGroupSummary", "createNotificationChannel", "Landroid/app/NotificationChannel;", "getDataLoadListener", "Lio/getstream/chat/android/client/notifications/NotificationLoadDataListener;", "getDeviceRegisteredListener", "Lio/getstream/chat/android/client/notifications/DeviceRegisteredListener;", "getErrorCaseIntent", "Landroid/content/Intent;", "getErrorCaseNotificationContent", "", "getErrorCaseNotificationTitle", "getErrorNotificationGroupKey", "getErrorNotificationGroupSummaryId", "getNewMessageIntent", "messageId", "channelType", "channelId", "getNotificationBuilder", "contentTitle", "contentText", "groupKey", "intent", "getNotificationChannelId", "getNotificationChannelName", "getNotificationGroupKey", "getNotificationGroupSummaryId", "getReadAction", "Landroidx/core/app/NotificationCompat$Action;", "pendingIntent", "Landroid/app/PendingIntent;", "getReplyAction", "replyPendingIntent", "getRequestCode", "onChatEvent", "", "event", "Lio/getstream/chat/android/client/events/NewMessageEvent;", "onCreateDevice", "", "onDeviceCreated", "Lkotlin/Function1;", "Lio/getstream/chat/android/client/models/Device;", "Lkotlin/ParameterName;", "name", "device", "onCreateDevice$stream_chat_android_client_release", "onPushMessage", "Lio/getstream/chat/android/client/models/PushMessage;", "prepareActionPendingIntent", "type", "actionType", "getMemberNamesWithoutCurrentUser", "getNotificationContentTitle", "Companion", "stream-chat-android-client_release"})
public class ChatNotificationHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final NotificationConfig config;
    @Deprecated
    @NotNull
    private static final String ERROR_NOTIFICATION_GROUP_KEY = "error_notification_group_key";

    @JvmOverloads
    public ChatNotificationHandler(@NotNull Context context, @NotNull NotificationConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.config = config;
    }

    public /* synthetic */ ChatNotificationHandler(Context context, NotificationConfig notificationConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            notificationConfig = new NotificationConfig(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, false, false, null, 16383, null);
        }
        this(context, notificationConfig);
    }

    @NotNull
    protected final Context getContext() {
        return this.context;
    }

    @NotNull
    public final NotificationConfig getConfig() {
        return this.config;
    }

    public boolean onChatEvent(@NotNull NewMessageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return true;
    }

    public boolean onPushMessage(@NotNull PushMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return false;
    }

    @Nullable
    public DeviceRegisteredListener getDeviceRegisteredListener() {
        return null;
    }

    @Nullable
    public NotificationLoadDataListener getDataLoadListener() {
        return null;
    }

    @RequiresApi(api=26)
    @NotNull
    public NotificationChannel createNotificationChannel() {
        NotificationChannel notificationChannel = new NotificationChannel(this.getNotificationChannelId(), (CharSequence)this.getNotificationChannelName(), 3);
        boolean bl = false;
        boolean bl2 = false;
        NotificationChannel $this$createNotificationChannel_u24lambda_u2d0 = notificationChannel;
        boolean bl3 = false;
        $this$createNotificationChannel_u24lambda_u2d0.setShowBadge(true);
        $this$createNotificationChannel_u24lambda_u2d0.setImportance(4);
        $this$createNotificationChannel_u24lambda_u2d0.enableLights(true);
        $this$createNotificationChannel_u24lambda_u2d0.setLightColor(-65536);
        $this$createNotificationChannel_u24lambda_u2d0.enableVibration(true);
        long[] lArray = new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L};
        $this$createNotificationChannel_u24lambda_u2d0.setVibrationPattern(lArray);
        return notificationChannel;
    }

    @NotNull
    public String getNotificationChannelId() {
        String string = this.context.getString(this.config.getNotificationChannelId());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(config.notificationChannelId)");
        return string;
    }

    @NotNull
    public String getNotificationChannelName() {
        String string = this.context.getString(this.config.getNotificationChannelName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(config.notificationChannelName)");
        return string;
    }

    @NotNull
    public String getErrorCaseNotificationTitle() {
        String string = this.context.getString(this.config.getErrorCaseNotificationTitle());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(config.errorCaseNotificationTitle)");
        return string;
    }

    @NotNull
    public String getErrorCaseNotificationContent() {
        String string = this.context.getString(this.config.getErrorCaseNotificationContent());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(config.errorCaseNotificationContent)");
        return string;
    }

    @NotNull
    public Notification buildErrorCaseNotification() {
        Notification notification = this.getNotificationBuilder(this.getErrorCaseNotificationTitle(), this.getErrorCaseNotificationContent(), this.getErrorNotificationGroupKey(), this.getErrorCaseIntent()).build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"getNotificationBuilder(\n            contentTitle = getErrorCaseNotificationTitle(),\n            contentText = getErrorCaseNotificationContent(),\n            groupKey = getErrorNotificationGroupKey(),\n            intent = getErrorCaseIntent(),\n        ).build()");
        return notification;
    }

    @NotNull
    public NotificationCompat.Builder buildNotification(int notificationId, @NotNull Channel channel, @NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        NotificationCompat.Builder builder = this.getNotificationBuilder(this.getNotificationContentTitle(channel), message.getText(), this.getNotificationGroupKey(channel.getType(), channel.getId()), this.getNewMessageIntent(message.getId(), channel.getType(), channel.getId()));
        boolean bl = false;
        boolean bl2 = false;
        NotificationCompat.Builder $this$buildNotification_u24lambda_u2d1 = builder;
        boolean bl3 = false;
        $this$buildNotification_u24lambda_u2d1.addAction(this.getReadAction(this.prepareActionPendingIntent(notificationId, message.getId(), channel.getId(), channel.getType(), "com.getstream.sdk.chat.READ")));
        $this$buildNotification_u24lambda_u2d1.addAction(this.getReplyAction(this.prepareActionPendingIntent(notificationId, message.getId(), channel.getId(), channel.getType(), "com.getstream.sdk.chat.REPLY")));
        return builder;
    }

    @NotNull
    public NotificationCompat.Builder buildNotificationGroupSummary(@NotNull Channel channel, @NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = this.getNotificationContentTitle(channel);
        String string2 = this.context.getString(this.config.getNotificationGroupSummaryContentText());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(config.notificationGroupSummaryContentText)");
        string2 = this.getNotificationBuilder(string, string2, this.getNotificationGroupKey(channel.getType(), channel.getId()), this.getNewMessageIntent(message.getId(), channel.getType(), channel.getId()));
        boolean bl = false;
        boolean bl2 = false;
        String $this$buildNotificationGroupSummary_u24lambda_u2d2 = string2;
        boolean bl3 = false;
        $this$buildNotificationGroupSummary_u24lambda_u2d2.setGroupSummary(true);
        return string2;
    }

    @NotNull
    public Notification buildErrorNotificationGroupSummary() {
        String string = this.context.getString(this.config.getErrorNotificationGroupSummaryTitle());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(config.errorNotificationGroupSummaryTitle)");
        String string2 = string;
        string = this.context.getString(this.config.getErrorNotificationGroupSummaryContentText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(config.errorNotificationGroupSummaryContentText)");
        string = this.getNotificationBuilder(string2, string, this.getErrorNotificationGroupKey(), this.getErrorCaseIntent());
        boolean bl = false;
        boolean bl2 = false;
        String $this$buildErrorNotificationGroupSummary_u24lambda_u2d3 = string;
        boolean bl3 = false;
        $this$buildErrorNotificationGroupSummary_u24lambda_u2d3.setGroupSummary(true);
        Notification notification = string.build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"getNotificationBuilder(\n            contentTitle = context.getString(config.errorNotificationGroupSummaryTitle),\n            contentText = context.getString(config.errorNotificationGroupSummaryContentText),\n            groupKey = getErrorNotificationGroupKey(),\n            getErrorCaseIntent(),\n        ).apply {\n            setGroupSummary(true)\n        }.build()");
        return notification;
    }

    @NotNull
    public String getNotificationGroupKey(@NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return channelType + ':' + channelId;
    }

    public int getNotificationGroupSummaryId(@NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.getNotificationGroupKey(channelType, channelId).hashCode();
    }

    @NotNull
    public String getErrorNotificationGroupKey() {
        return ERROR_NOTIFICATION_GROUP_KEY;
    }

    public int getErrorNotificationGroupSummaryId() {
        return this.getErrorNotificationGroupKey().hashCode();
    }

    private final int getRequestCode() {
        return (int)System.currentTimeMillis();
    }

    @NotNull
    public Intent getNewMessageIntent(@NotNull String messageId, @NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        PackageManager packageManager = this.context.getPackageManager();
        Intrinsics.checkNotNull((Object)packageManager);
        Intent intent = packageManager.getLaunchIntentForPackage(this.context.getPackageName());
        Intrinsics.checkNotNull((Object)intent);
        Intent intent2 = intent;
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"context.packageManager!!.getLaunchIntentForPackage(context.packageName)!!");
        return intent2;
    }

    @NotNull
    public Intent getErrorCaseIntent() {
        PackageManager packageManager = this.context.getPackageManager();
        Intrinsics.checkNotNull((Object)packageManager);
        Intent intent = packageManager.getLaunchIntentForPackage(this.context.getPackageName());
        Intrinsics.checkNotNull((Object)intent);
        Intent intent2 = intent;
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"context.packageManager!!.getLaunchIntentForPackage(context.packageName)!!");
        return intent2;
    }

    private final NotificationCompat.Builder getNotificationBuilder(String contentTitle, String contentText, String groupKey, Intent intent) {
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this.context, (int)this.getRequestCode(), (Intent)intent, (int)0x8000000);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context, this.getNotificationChannelId()).setDefaults(-1).setAutoCancel(true).setSmallIcon(this.config.getSmallIcon()).setContentTitle((CharSequence)contentTitle).setContentText((CharSequence)contentText).setPriority(1).setCategory("msg").setShowWhen(true).setContentIntent(contentIntent);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder(context, getNotificationChannelId())\n            .setDefaults(NotificationCompat.DEFAULT_ALL)\n            .setAutoCancel(true)\n            .setSmallIcon(config.smallIcon)\n            .setContentTitle(contentTitle)\n            .setContentText(contentText)\n            .setPriority(NotificationCompat.PRIORITY_HIGH)\n            .setCategory(NotificationCompat.CATEGORY_MESSAGE)\n            .setShowWhen(true)\n            .setContentIntent(contentIntent)");
        boolean bl = false;
        boolean bl2 = false;
        NotificationCompat.Builder $this$getNotificationBuilder_u24lambda_u2d4 = builder;
        boolean bl3 = false;
        if (this.getConfig().getShouldGroupNotifications()) {
            $this$getNotificationBuilder_u24lambda_u2d4.setGroup(groupKey);
        }
        return builder;
    }

    private final NotificationCompat.Action getReadAction(PendingIntent pendingIntent) {
        NotificationCompat.Action action = new NotificationCompat.Action.Builder(17301591, (CharSequence)this.context.getString(R.string.stream_chat_notification_read), pendingIntent).build();
        Intrinsics.checkNotNullExpressionValue((Object)action, (String)"Builder(\n            android.R.drawable.ic_menu_view,\n            context.getString(R.string.stream_chat_notification_read),\n            pendingIntent,\n        ).build()");
        return action;
    }

    private final NotificationCompat.Action getReplyAction(PendingIntent replyPendingIntent) {
        RemoteInput remoteInput = new RemoteInput.Builder("text_reply").setLabel((CharSequence)this.context.getString(R.string.stream_chat_notification_type_hint)).build();
        Intrinsics.checkNotNullExpressionValue((Object)remoteInput, (String)"Builder(NotificationMessageReceiver.KEY_TEXT_REPLY)\n                .setLabel(context.getString(R.string.stream_chat_notification_type_hint))\n                .build()");
        RemoteInput remoteInput2 = remoteInput;
        remoteInput = new NotificationCompat.Action.Builder(17301584, (CharSequence)this.context.getString(R.string.stream_chat_notification_reply), replyPendingIntent).addRemoteInput(remoteInput2).setAllowGeneratedReplies(true).build();
        Intrinsics.checkNotNullExpressionValue((Object)remoteInput, (String)"Builder(\n            android.R.drawable.ic_menu_send,\n            context.getString(R.string.stream_chat_notification_reply),\n            replyPendingIntent\n        )\n            .addRemoteInput(remoteInput)\n            .setAllowGeneratedReplies(true)\n            .build()");
        return remoteInput;
    }

    private final PendingIntent prepareActionPendingIntent(int notificationId, String messageId, String channelId, String type, String actionType) {
        Intent notifyIntent;
        Intent intent = notifyIntent = new Intent(this.context, NotificationMessageReceiver.class);
        boolean bl = false;
        boolean bl2 = false;
        Intent $this$prepareActionPendingIntent_u24lambda_u2d5 = intent;
        boolean bl3 = false;
        $this$prepareActionPendingIntent_u24lambda_u2d5.putExtra("notification_id", notificationId);
        $this$prepareActionPendingIntent_u24lambda_u2d5.putExtra("message_id", messageId);
        $this$prepareActionPendingIntent_u24lambda_u2d5.putExtra("id", channelId);
        $this$prepareActionPendingIntent_u24lambda_u2d5.putExtra("type", type);
        $this$prepareActionPendingIntent_u24lambda_u2d5.setAction(actionType);
        intent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)notifyIntent, (int)0x8000000);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"getBroadcast(\n            context,\n            0,\n            notifyIntent,\n            PendingIntent.FLAG_UPDATE_CURRENT,\n        )");
        return intent;
    }

    public final void onCreateDevice$stream_chat_android_client_release(@NotNull Function1<? super Device, Unit> onDeviceCreated) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(onDeviceCreated, (String)"onDeviceCreated");
            Iterable $this$firstOrNull$iv = this.config.getPushDeviceGenerators();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PushDeviceGenerator it = (PushDeviceGenerator)element$iv;
                boolean bl = false;
                if (!it.isValidForThisDevice(this.getContext())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        PushDeviceGenerator pushDeviceGenerator = v0;
        if (pushDeviceGenerator != null) {
            pushDeviceGenerator.asyncGenerateDevice(onDeviceCreated);
        }
    }

    private final String getNotificationContentTitle(Channel $this$getNotificationContentTitle) {
        String string2;
        String string3;
        String string4 = $this$getNotificationContentTitle.getName();
        boolean bl = false;
        boolean bl2 = false;
        String it = string4;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        String string5 = string3 = charSequence.length() > 0 ? string4 : null;
        if (string3 == null) {
            string4 = this.getMemberNamesWithoutCurrentUser($this$getNotificationContentTitle);
            if (string4 == null) {
                String string6 = this.context.getString(R.string.stream_chat_notification_title);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"context.getString(R.string.stream_chat_notification_title)");
                string2 = string6;
            } else {
                string2 = string4;
            }
        } else {
            string2 = string3;
        }
        return string2;
    }

    private final String getMemberNamesWithoutCurrentUser(Channel $this$getMemberNamesWithoutCurrentUser) {
        String string2 = CollectionsKt.joinToString$default((Iterable)ChannelExtensionKt.getUsersExcludingCurrent($this$getMemberNamesWithoutCurrentUser), null, null, null, (int)0, null, (Function1)getMemberNamesWithoutCurrentUser.1.INSTANCE, (int)31, null);
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        return charSequence.length() > 0 ? string2 : null;
    }

    @JvmOverloads
    public ChatNotificationHandler(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler$Companion;", "", "()V", "ERROR_NOTIFICATION_GROUP_KEY", "", "stream-chat-android-client_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

