/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.api.models;

import android.os.Handler;
import android.os.Looper;
import io.getstream.chat.android.client.utils.ProgressCallback;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/getstream/chat/android/client/api/models/ProgressRequestBody;", "Lokhttp3/RequestBody;", "delegate", "callback", "Lio/getstream/chat/android/client/utils/ProgressCallback;", "(Lokhttp3/RequestBody;Lio/getstream/chat/android/client/utils/ProgressCallback;)V", "handler", "Landroid/os/Handler;", "contentLength", "", "contentType", "Lokhttp3/MediaType;", "writeTo", "", "sink", "Lokio/BufferedSink;", "CountingSink", "stream-chat-android-client_release"})
public final class ProgressRequestBody
extends RequestBody {
    @NotNull
    private final RequestBody delegate;
    @NotNull
    private final ProgressCallback callback;
    @NotNull
    private final Handler handler;

    public ProgressRequestBody(@NotNull RequestBody delegate, @NotNull ProgressCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        this.delegate = delegate;
        this.callback = callback2;
        this.handler = new Handler(Looper.getMainLooper());
    }

    @Nullable
    public MediaType contentType() {
        return this.delegate.contentType();
    }

    public long contentLength() {
        return this.delegate.contentLength();
    }

    public void writeTo(@NotNull BufferedSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        BufferedSink countingSink = Okio.buffer((Sink)((Sink)new CountingSink((Sink)sink)));
        this.delegate.writeTo(countingSink);
        countingSink.flush();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\b\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lio/getstream/chat/android/client/api/models/ProgressRequestBody$CountingSink;", "Lokio/ForwardingSink;", "delegate", "Lokio/Sink;", "(Lio/getstream/chat/android/client/api/models/ProgressRequestBody;Lokio/Sink;)V", "total", "", "getTotal", "()J", "uploaded", "getUploaded", "setUploaded", "(J)V", "write", "", "source", "Lokio/Buffer;", "byteCount", "stream-chat-android-client_release"})
    private final class CountingSink
    extends ForwardingSink {
        private final long total;
        private long uploaded;

        public CountingSink(Sink delegate) {
            Intrinsics.checkNotNullParameter((Object)((Object)ProgressRequestBody.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            super(delegate);
            this.total = ProgressRequestBody.this.contentLength();
        }

        public final long getTotal() {
            return this.total;
        }

        public final long getUploaded() {
            return this.uploaded;
        }

        public final void setUploaded(long l) {
            this.uploaded = l;
        }

        public void write(@NotNull Buffer source, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            super.write(source, byteCount);
            CountingSink countingSink = this;
            countingSink.uploaded += byteCount;
            long percentage = (long)100 * this.uploaded / this.total;
            ProgressRequestBody.this.handler.post(() -> CountingSink.write$lambda-0(ProgressRequestBody.this, percentage));
        }

        private static final void write$lambda-0(ProgressRequestBody this$0, long $percentage) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.callback.onProgress($percentage);
        }
    }
}

