/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.logger;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.logger.ChatLogLevel;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/getstream/chat/android/client/logger/TaggedLoggerImpl;", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "tag", "", "logger", "Lio/getstream/chat/android/client/logger/ChatLogger;", "(Ljava/lang/Object;Lio/getstream/chat/android/client/logger/ChatLogger;)V", "getLevel", "Lio/getstream/chat/android/client/logger/ChatLogLevel;", "logD", "", "message", "", "logE", "chatError", "Lio/getstream/chat/android/client/errors/ChatError;", "throwable", "", "logI", "logW", "stream-chat-android-client_release"})
public final class TaggedLoggerImpl
implements TaggedLogger {
    @NotNull
    private final Object tag;
    @NotNull
    private final ChatLogger logger;

    public TaggedLoggerImpl(@NotNull Object tag, @NotNull ChatLogger logger) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.tag = tag;
        this.logger = logger;
    }

    @Override
    public void logI(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.logI(this.tag, message);
    }

    @Override
    public void logD(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.logD(this.tag, message);
    }

    @Override
    public void logW(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.logW(this.tag, message);
    }

    @Override
    public void logE(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.logE(this.tag, message);
    }

    @Override
    public void logE(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.logger.logE(this.tag, throwable);
    }

    @Override
    public void logE(@NotNull String message, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.logger.logE(this.tag, message, throwable);
    }

    @Override
    @NotNull
    public ChatLogLevel getLevel() {
        return this.logger.getLevel();
    }

    @Override
    public void logE(@NotNull String message, @NotNull ChatError chatError) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)chatError, (String)"chatError");
        this.logger.logE(this.tag, message, chatError);
    }

    @Override
    public void logE(@NotNull ChatError chatError) {
        Intrinsics.checkNotNullParameter((Object)chatError, (String)"chatError");
        this.logger.logE(this.tag, chatError);
    }
}

