/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications.handler;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import io.getstream.chat.android.client.R;
import io.getstream.chat.android.client.events.NewMessageEvent;
import io.getstream.chat.android.client.extensions.ChannelExtensionKt;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Device;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.PushMessage;
import io.getstream.chat.android.client.notifications.DeviceRegisteredListener;
import io.getstream.chat.android.client.notifications.NotificationLoadDataListener;
import io.getstream.chat.android.client.notifications.handler.ChatNotificationHandler;
import io.getstream.chat.android.client.notifications.handler.NotificationConfig;
import io.getstream.chat.android.client.notifications.handler.PushDeviceGenerator;
import io.getstream.chat.android.client.receivers.NotificationMessageReceiver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 a2\u00020\u0001:\u0001aB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020&H\u0017J\r\u0010'\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b(J\u001d\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0000\u00a2\u0006\u0002\b-J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0019002\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0010\u00101\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\n\u00102\u001a\u0004\u0018\u000103H\u0017J\n\u00104\u001a\u0004\u0018\u000105H\u0017J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020+H\u0016J\b\u00109\u001a\u00020+H\u0016J\b\u0010:\u001a\u00020+H\u0016J\b\u0010;\u001a\u00020\u0019H\u0016J \u0010<\u001a\u0002072\u0006\u0010=\u001a\u00020+2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0016J(\u0010>\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020+2\u0006\u0010@\u001a\u00020+2\u0006\u0010A\u001a\u00020+2\u0006\u0010B\u001a\u000207H\u0002J\b\u0010C\u001a\u00020+H\u0016J\b\u0010D\u001a\u00020+H\u0016J\u0018\u0010E\u001a\u00020+2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0016J\u0018\u0010F\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0016J\u0010\u0010G\u001a\u00020+2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010H\u001a\u00020+2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u000e\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001900H\u0002J\b\u0010J\u001a\u00020\u0019H\u0002J\u0010\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0016J0\u0010O\u001a\u00020\u00172!\u0010P\u001a\u001d\u0012\u0013\u0012\u00110R\u00a2\u0006\f\bS\u0012\b\bT\u0012\u0004\b\b(U\u0012\u0004\u0012\u00020\u00170QH\u0000\u00a2\u0006\u0002\bVJ\u0015\u0010W\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\bXJ\u0010\u0010Y\u001a\u00020L2\u0006\u0010\"\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001d\u0010\\\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b]J\u0018\u0010\\\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010^\u001a\u00020\u001cH\u0002J\u000e\u0010_\u001a\u0004\u0018\u00010+*\u00020!H\u0002J\f\u0010`\u001a\u00020+*\u00020!H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006b"}, d2={"Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;", "", "context", "Landroid/content/Context;", "config", "Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;", "(Landroid/content/Context;Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;)V", "getConfig", "()Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;", "getContext", "()Landroid/content/Context;", "notificationManager", "Landroid/app/NotificationManager;", "getNotificationManager", "()Landroid/app/NotificationManager;", "notificationManager$delegate", "Lkotlin/Lazy;", "sharedPreferences", "Landroid/content/SharedPreferences;", "getSharedPreferences", "()Landroid/content/SharedPreferences;", "sharedPreferences$delegate", "addNotificationId", "", "notificationId", "", "notificationSummaryId", "buildErrorCaseNotification", "Landroid/app/Notification;", "buildErrorNotificationGroupSummary", "buildNotification", "Landroidx/core/app/NotificationCompat$Builder;", "channel", "Lio/getstream/chat/android/client/models/Channel;", "message", "Lio/getstream/chat/android/client/models/Message;", "buildNotificationGroupSummary", "createNotificationChannel", "Landroid/app/NotificationChannel;", "dismissAllNotifications", "dismissAllNotifications$stream_chat_android_client_release", "dismissChannelNotifications", "channelType", "", "channelId", "dismissChannelNotifications$stream_chat_android_client_release", "dismissSummaryNotification", "getAssociatedNotificationIds", "", "getAssociatedNotificationSummaryId", "getDataLoadListener", "Lio/getstream/chat/android/client/notifications/NotificationLoadDataListener;", "getDeviceRegisteredListener", "Lio/getstream/chat/android/client/notifications/DeviceRegisteredListener;", "getErrorCaseIntent", "Landroid/content/Intent;", "getErrorCaseNotificationContent", "getErrorCaseNotificationTitle", "getErrorNotificationGroupKey", "getErrorNotificationGroupSummaryId", "getNewMessageIntent", "messageId", "getNotificationBuilder", "contentTitle", "contentText", "groupKey", "intent", "getNotificationChannelId", "getNotificationChannelName", "getNotificationGroupKey", "getNotificationGroupSummaryId", "getNotificationIdKey", "getNotificationSummaryIdKey", "getNotificationSummaryIds", "getRequestCode", "onChatEvent", "", "event", "Lio/getstream/chat/android/client/events/NewMessageEvent;", "onCreateDevice", "onDeviceCreated", "Lkotlin/Function1;", "Lio/getstream/chat/android/client/models/Device;", "Lkotlin/ParameterName;", "name", "device", "onCreateDevice$stream_chat_android_client_release", "onDismissNotification", "onDismissNotification$stream_chat_android_client_release", "onPushMessage", "Lio/getstream/chat/android/client/models/PushMessage;", "removeNotificationId", "showNotification", "showNotification$stream_chat_android_client_release", "notification", "getMemberNamesWithoutCurrentUser", "getNotificationContentTitle", "Companion", "stream-chat-android-client_release"})
public class ChatNotificationHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final NotificationConfig config;
    @NotNull
    private final Lazy sharedPreferences$delegate;
    @NotNull
    private final Lazy notificationManager$delegate;
    @java.lang.Deprecated
    @NotNull
    private static final String ERROR_NOTIFICATION_GROUP_KEY = "error_notification_group_key";
    @java.lang.Deprecated
    @NotNull
    private static final String SHARED_PREFERENCES_NAME = "stream_notifications.sp";
    @java.lang.Deprecated
    @NotNull
    private static final String KEY_PREFIX_NOTIFICATION_ID = "nId-";
    @java.lang.Deprecated
    @NotNull
    private static final String KEY_PREFIX_NOTIFICATION_SUMMARY_ID = "nSId-";
    @java.lang.Deprecated
    @NotNull
    private static final String KEY_NOTIFICATION_SUMMARY_IDS = "notification_summary_ids";

    @JvmOverloads
    public ChatNotificationHandler(@NotNull Context context, @NotNull NotificationConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.config = config;
        this.sharedPreferences$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SharedPreferences>(this){
            final /* synthetic */ ChatNotificationHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final SharedPreferences invoke() {
                return this.this$0.getContext().getSharedPreferences("stream_notifications.sp", 0);
            }
        }));
        this.notificationManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NotificationManager>(this){
            final /* synthetic */ ChatNotificationHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NotificationManager invoke() {
                Object object = this.this$0.getContext().getSystemService("notification");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
                }
                return (NotificationManager)object;
            }
        }));
    }

    public /* synthetic */ ChatNotificationHandler(Context context, NotificationConfig notificationConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            notificationConfig = new NotificationConfig(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, false, false, null, 16383, null);
        }
        this(context, notificationConfig);
    }

    @NotNull
    protected final Context getContext() {
        return this.context;
    }

    @NotNull
    public final NotificationConfig getConfig() {
        return this.config;
    }

    private final SharedPreferences getSharedPreferences() {
        Lazy lazy = this.sharedPreferences$delegate;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-sharedPreferences>(...)");
        return (SharedPreferences)object;
    }

    private final NotificationManager getNotificationManager() {
        Lazy lazy = this.notificationManager$delegate;
        boolean bl = false;
        return (NotificationManager)lazy.getValue();
    }

    public boolean onChatEvent(@NotNull NewMessageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return true;
    }

    public boolean onPushMessage(@NotNull PushMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return false;
    }

    @Deprecated(message="It is not used anymore", level=DeprecationLevel.ERROR)
    @Nullable
    public DeviceRegisteredListener getDeviceRegisteredListener() {
        return null;
    }

    @Deprecated(message="It is not used anymore, you will be notify to build the notification instead", level=DeprecationLevel.ERROR)
    @Nullable
    public NotificationLoadDataListener getDataLoadListener() {
        return null;
    }

    @RequiresApi(api=26)
    @NotNull
    public NotificationChannel createNotificationChannel() {
        NotificationChannel notificationChannel = new NotificationChannel(this.getNotificationChannelId(), (CharSequence)this.getNotificationChannelName(), 3);
        boolean bl = false;
        boolean bl2 = false;
        NotificationChannel $this$createNotificationChannel_u24lambda_u2d0 = notificationChannel;
        boolean bl3 = false;
        $this$createNotificationChannel_u24lambda_u2d0.setShowBadge(true);
        $this$createNotificationChannel_u24lambda_u2d0.setImportance(4);
        $this$createNotificationChannel_u24lambda_u2d0.enableLights(true);
        $this$createNotificationChannel_u24lambda_u2d0.setLightColor(-65536);
        $this$createNotificationChannel_u24lambda_u2d0.enableVibration(true);
        long[] lArray = new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L};
        $this$createNotificationChannel_u24lambda_u2d0.setVibrationPattern(lArray);
        return notificationChannel;
    }

    @NotNull
    public String getNotificationChannelId() {
        String string = this.context.getString(this.config.getNotificationChannelId());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(config.notificationChannelId)");
        return string;
    }

    @NotNull
    public String getNotificationChannelName() {
        String string = this.context.getString(this.config.getNotificationChannelName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(config.notificationChannelName)");
        return string;
    }

    @NotNull
    public String getErrorCaseNotificationTitle() {
        String string = this.context.getString(this.config.getErrorCaseNotificationTitle());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(config.errorCaseNotificationTitle)");
        return string;
    }

    @NotNull
    public String getErrorCaseNotificationContent() {
        String string = this.context.getString(this.config.getErrorCaseNotificationContent());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(config.errorCaseNotificationContent)");
        return string;
    }

    @NotNull
    public Notification buildErrorCaseNotification() {
        Notification notification = this.getNotificationBuilder(this.getErrorCaseNotificationTitle(), this.getErrorCaseNotificationContent(), this.getErrorNotificationGroupKey(), this.getErrorCaseIntent()).build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"getNotificationBuilder(\n            contentTitle = getErrorCaseNotificationTitle(),\n            contentText = getErrorCaseNotificationContent(),\n            groupKey = getErrorNotificationGroupKey(),\n            intent = getErrorCaseIntent(),\n        ).build()");
        return notification;
    }

    public final void showNotification$stream_chat_android_client_release(@NotNull Channel channel, @NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        int notificationId = (int)System.nanoTime();
        int notificationSummaryId = this.getNotificationGroupSummaryId(channel.getType(), channel.getId());
        this.addNotificationId(notificationId, notificationSummaryId);
        Notification notification = this.buildNotification(notificationId, channel, message).build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"buildNotification(notificationId, channel, message).build()");
        this.showNotification(notificationId, notification);
        notification = this.buildNotificationGroupSummary(channel, message).build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"buildNotificationGroupSummary(channel, message).build()");
        this.showNotification(notificationSummaryId, notification);
    }

    @NotNull
    public NotificationCompat.Builder buildNotification(int notificationId, @NotNull Channel channel, @NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        NotificationCompat.Builder builder = this.getNotificationBuilder(this.getNotificationContentTitle(channel), message.getText(), this.getNotificationGroupKey(channel.getType(), channel.getId()), this.getNewMessageIntent(message.getId(), channel.getType(), channel.getId()));
        boolean bl = false;
        boolean bl2 = false;
        NotificationCompat.Builder $this$buildNotification_u24lambda_u2d1 = builder;
        boolean bl3 = false;
        $this$buildNotification_u24lambda_u2d1.addAction(NotificationMessageReceiver.Companion.createReadAction$stream_chat_android_client_release(this.getContext(), notificationId, channel, message));
        $this$buildNotification_u24lambda_u2d1.addAction(NotificationMessageReceiver.Companion.createReplyAction$stream_chat_android_client_release(this.getContext(), notificationId, channel));
        $this$buildNotification_u24lambda_u2d1.setDeleteIntent(NotificationMessageReceiver.Companion.createDismissPendingIntent$stream_chat_android_client_release(this.getContext(), notificationId));
        return builder;
    }

    @NotNull
    public NotificationCompat.Builder buildNotificationGroupSummary(@NotNull Channel channel, @NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = this.getNotificationContentTitle(channel);
        String string2 = this.context.getString(this.config.getNotificationGroupSummaryContentText());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(config.notificationGroupSummaryContentText)");
        string2 = this.getNotificationBuilder(string, string2, this.getNotificationGroupKey(channel.getType(), channel.getId()), this.getNewMessageIntent(message.getId(), channel.getType(), channel.getId()));
        boolean bl = false;
        boolean bl2 = false;
        String $this$buildNotificationGroupSummary_u24lambda_u2d2 = string2;
        boolean bl3 = false;
        $this$buildNotificationGroupSummary_u24lambda_u2d2.setGroupSummary(true);
        return string2;
    }

    @NotNull
    public Notification buildErrorNotificationGroupSummary() {
        String string = this.context.getString(this.config.getErrorNotificationGroupSummaryTitle());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(config.errorNotificationGroupSummaryTitle)");
        String string2 = string;
        string = this.context.getString(this.config.getErrorNotificationGroupSummaryContentText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(config.errorNotificationGroupSummaryContentText)");
        string = this.getNotificationBuilder(string2, string, this.getErrorNotificationGroupKey(), this.getErrorCaseIntent());
        boolean bl = false;
        boolean bl2 = false;
        String $this$buildErrorNotificationGroupSummary_u24lambda_u2d3 = string;
        boolean bl3 = false;
        $this$buildErrorNotificationGroupSummary_u24lambda_u2d3.setGroupSummary(true);
        Notification notification = string.build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"getNotificationBuilder(\n            contentTitle = context.getString(config.errorNotificationGroupSummaryTitle),\n            contentText = context.getString(config.errorNotificationGroupSummaryContentText),\n            groupKey = getErrorNotificationGroupKey(),\n            getErrorCaseIntent(),\n        ).apply {\n            setGroupSummary(true)\n        }.build()");
        return notification;
    }

    @NotNull
    public String getNotificationGroupKey(@NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return channelType + ':' + channelId;
    }

    public int getNotificationGroupSummaryId(@NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.getNotificationGroupKey(channelType, channelId).hashCode();
    }

    @NotNull
    public String getErrorNotificationGroupKey() {
        return ERROR_NOTIFICATION_GROUP_KEY;
    }

    public int getErrorNotificationGroupSummaryId() {
        return this.getErrorNotificationGroupKey().hashCode();
    }

    private final int getRequestCode() {
        return (int)System.currentTimeMillis();
    }

    @NotNull
    public Intent getNewMessageIntent(@NotNull String messageId, @NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        PackageManager packageManager = this.context.getPackageManager();
        Intrinsics.checkNotNull((Object)packageManager);
        Intent intent = packageManager.getLaunchIntentForPackage(this.context.getPackageName());
        Intrinsics.checkNotNull((Object)intent);
        Intent intent2 = intent;
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"context.packageManager!!.getLaunchIntentForPackage(context.packageName)!!");
        return intent2;
    }

    public final void dismissChannelNotifications$stream_chat_android_client_release(@NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        this.dismissSummaryNotification(this.getNotificationGroupSummaryId(channelType, channelId));
    }

    public final void dismissAllNotifications$stream_chat_android_client_release() {
        Iterable $this$forEach$iv = this.getNotificationSummaryIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int p0 = ((Number)element$iv).intValue();
            boolean bl = false;
            this.dismissSummaryNotification(p0);
        }
    }

    @NotNull
    public Intent getErrorCaseIntent() {
        PackageManager packageManager = this.context.getPackageManager();
        Intrinsics.checkNotNull((Object)packageManager);
        Intent intent = packageManager.getLaunchIntentForPackage(this.context.getPackageName());
        Intrinsics.checkNotNull((Object)intent);
        Intent intent2 = intent;
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"context.packageManager!!.getLaunchIntentForPackage(context.packageName)!!");
        return intent2;
    }

    private final void showNotification(int notificationId, Notification notification) {
        this.getNotificationManager().notify(notificationId, notification);
    }

    private final NotificationCompat.Builder getNotificationBuilder(String contentTitle, String contentText, String groupKey, Intent intent) {
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this.context, (int)this.getRequestCode(), (Intent)intent, (int)0x8000000);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context, this.getNotificationChannelId()).setDefaults(-1).setAutoCancel(true).setSmallIcon(this.config.getSmallIcon()).setContentTitle((CharSequence)contentTitle).setContentText((CharSequence)contentText).setPriority(1).setCategory("msg").setShowWhen(true).setContentIntent(contentIntent).setGroup(groupKey);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder(context, getNotificationChannelId())\n            .setDefaults(NotificationCompat.DEFAULT_ALL)\n            .setAutoCancel(true)\n            .setSmallIcon(config.smallIcon)\n            .setContentTitle(contentTitle)\n            .setContentText(contentText)\n            .setPriority(NotificationCompat.PRIORITY_HIGH)\n            .setCategory(NotificationCompat.CATEGORY_MESSAGE)\n            .setShowWhen(true)\n            .setContentIntent(contentIntent)\n            .setGroup(groupKey)");
        return builder;
    }

    public final void onCreateDevice$stream_chat_android_client_release(@NotNull Function1<? super Device, Unit> onDeviceCreated) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(onDeviceCreated, (String)"onDeviceCreated");
            Iterable $this$firstOrNull$iv = this.config.getPushDeviceGenerators();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PushDeviceGenerator it = (PushDeviceGenerator)element$iv;
                boolean bl = false;
                if (!it.isValidForThisDevice(this.getContext())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        PushDeviceGenerator pushDeviceGenerator = v0;
        if (pushDeviceGenerator != null) {
            pushDeviceGenerator.asyncGenerateDevice(onDeviceCreated);
        }
    }

    private final String getNotificationContentTitle(Channel $this$getNotificationContentTitle) {
        String string2;
        String string3;
        String string4 = $this$getNotificationContentTitle.getName();
        boolean bl = false;
        boolean bl2 = false;
        String it = string4;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        String string5 = string3 = charSequence.length() > 0 ? string4 : null;
        if (string3 == null) {
            string4 = this.getMemberNamesWithoutCurrentUser($this$getNotificationContentTitle);
            if (string4 == null) {
                String string6 = this.context.getString(R.string.stream_chat_notification_title);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"context.getString(R.string.stream_chat_notification_title)");
                string2 = string6;
            } else {
                string2 = string4;
            }
        } else {
            string2 = string3;
        }
        return string2;
    }

    private final String getMemberNamesWithoutCurrentUser(Channel $this$getMemberNamesWithoutCurrentUser) {
        String string2 = CollectionsKt.joinToString$default((Iterable)ChannelExtensionKt.getUsersExcludingCurrent($this$getMemberNamesWithoutCurrentUser), null, null, null, (int)0, null, (Function1)getMemberNamesWithoutCurrentUser.1.INSTANCE, (int)31, null);
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        return charSequence.length() > 0 ? string2 : null;
    }

    private final void dismissSummaryNotification(int notificationSummaryId) {
        Iterable $this$forEach$iv = this.getAssociatedNotificationIds(notificationSummaryId);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            this.getNotificationManager().cancel(it);
            this.removeNotificationId(it);
        }
        this.getNotificationManager().cancel(notificationSummaryId);
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$dismissSummaryNotification_u24lambda_u2d8 = editor$iv;
        boolean bl = false;
        $this$dismissSummaryNotification_u24lambda_u2d8.remove(this.getNotificationSummaryIdKey(notificationSummaryId));
        editor$iv.apply();
    }

    public final void onDismissNotification$stream_chat_android_client_release(int notificationId) {
        int notificationSummaryId = this.getAssociatedNotificationSummaryId(notificationId);
        this.removeNotificationId(notificationId);
        this.getNotificationManager().cancel(notificationId);
        Collection collection = this.getAssociatedNotificationIds(notificationSummaryId);
        boolean bl = false;
        boolean bl2 = false;
        if (collection == null || collection.isEmpty()) {
            this.getNotificationManager().cancel(notificationSummaryId);
        }
    }

    private final void addNotificationId(int notificationId, int notificationSummaryId) {
        String string2;
        int p0;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$addNotificationId_u24lambda_u2d11 = editor$iv;
        boolean bl = false;
        $this$addNotificationId_u24lambda_u2d11.putInt(this.getNotificationIdKey(notificationId), notificationSummaryId);
        Iterable iterable = SetsKt.plus(this.getNotificationSummaryIds(), (Object)notificationSummaryId);
        String string3 = KEY_NOTIFICATION_SUMMARY_IDS;
        SharedPreferences.Editor editor = $this$addNotificationId_u24lambda_u2d11;
        boolean $i$f$map = false;
        void var13_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl2 = false;
            string2 = String.valueOf(p0);
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        editor.putStringSet(string3, CollectionsKt.toSet((Iterable)collection));
        $this$map$iv = SetsKt.plus(this.getAssociatedNotificationIds(notificationSummaryId), (Object)notificationId);
        string3 = this.getNotificationSummaryIdKey(notificationSummaryId);
        editor = $this$addNotificationId_u24lambda_u2d11;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl3 = false;
            string2 = String.valueOf(p0);
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        editor.putStringSet(string3, CollectionsKt.toSet((Iterable)collection));
        editor$iv.apply();
    }

    /*
     * WARNING - void declaration
     */
    private final void removeNotificationId(int notificationId) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$removeNotificationId_u24lambda_u2d13 = editor$iv;
        boolean bl = false;
        int notificationSummaryId = this.getAssociatedNotificationSummaryId(notificationId);
        $this$removeNotificationId_u24lambda_u2d13.remove(this.getNotificationIdKey(notificationId));
        Iterable iterable = SetsKt.minus(this.getAssociatedNotificationIds(notificationSummaryId), (Object)notificationId);
        String string2 = this.getNotificationSummaryIdKey(notificationSummaryId);
        SharedPreferences.Editor editor = $this$removeNotificationId_u24lambda_u2d13;
        boolean $i$f$map = false;
        void var13_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl2 = false;
            String string3 = String.valueOf((int)p0);
            collection.add(string3);
        }
        collection = (List)destination$iv$iv;
        editor.putStringSet(string2, CollectionsKt.toSet((Iterable)collection));
        editor$iv.apply();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Integer> getNotificationSummaryIds() {
        void $this$mapTo$iv$iv;
        Set set = this.getSharedPreferences().getStringSet(KEY_NOTIFICATION_SUMMARY_IDS, null);
        boolean bl = false;
        Set set2 = set;
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        Iterable $this$map$iv = set2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var10_10 = p0;
            boolean bl3 = false;
            Integer n = Integer.parseInt((String)var10_10);
            collection.add(n);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final int getAssociatedNotificationSummaryId(int notificationId) {
        return this.getSharedPreferences().getInt(this.getNotificationIdKey(notificationId), 0);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Integer> getAssociatedNotificationIds(int notificationSummaryId) {
        void $this$mapTo$iv$iv;
        Set set = this.getSharedPreferences().getStringSet(this.getNotificationSummaryIdKey(notificationSummaryId), null);
        boolean bl = false;
        Set set2 = set;
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        Iterable $this$map$iv = set2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var11_11 = p0;
            boolean bl3 = false;
            Integer n = Integer.parseInt((String)var11_11);
            collection.add(n);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final String getNotificationIdKey(int notificationId) {
        return Intrinsics.stringPlus((String)KEY_PREFIX_NOTIFICATION_ID, (Object)notificationId);
    }

    private final String getNotificationSummaryIdKey(int notificationSummaryId) {
        return Intrinsics.stringPlus((String)KEY_PREFIX_NOTIFICATION_SUMMARY_ID, (Object)notificationSummaryId);
    }

    @JvmOverloads
    public ChatNotificationHandler(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler$Companion;", "", "()V", "ERROR_NOTIFICATION_GROUP_KEY", "", "KEY_NOTIFICATION_SUMMARY_IDS", "KEY_PREFIX_NOTIFICATION_ID", "KEY_PREFIX_NOTIFICATION_SUMMARY_ID", "SHARED_PREFERENCES_NAME", "stream-chat-android-client_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

