/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications.storage;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.notifications.storage.PushNotificationsConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/getstream/chat/android/client/notifications/storage/EncryptedPushNotificationsConfigStore;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "prefs", "Landroid/content/SharedPreferences;", "clear", "", "get", "Lio/getstream/chat/android/client/notifications/storage/PushNotificationsConfig;", "put", "config", "Companion", "stream-chat-android-client_release"})
public final class EncryptedPushNotificationsConfigStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SharedPreferences prefs;
    @NotNull
    private final TaggedLogger logger;
    @NotNull
    private static final String MASTER_KEY_ALIAS = "_stream_sync_config_master_key_";
    @NotNull
    private static final String ENCRYPTED_SYNC_CONFIG_PREFS_NAME = "stream_livedata_sync_config_store";
    @NotNull
    private static final String SYNC_CONFIG_PREFS_NAME = ".stream_livedata_sync_config_store";
    @NotNull
    private static final String KEY_USER_ID = "user_id";
    @NotNull
    private static final String KEY_USER_TOKEN = "user_token";

    /*
     * WARNING - void declaration
     */
    public EncryptedPushNotificationsConfigStore(@NotNull Context context) {
        SharedPreferences sharedPreferences2;
        EncryptedPushNotificationsConfigStore encryptedPushNotificationsConfigStore;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.logger = ChatLogger.Companion.get("EncryptedBackgroundSyncConfigStore");
        EncryptedPushNotificationsConfigStore encryptedPushNotificationsConfigStore2 = this;
        try {
            encryptedPushNotificationsConfigStore = encryptedPushNotificationsConfigStore2;
            MasterKey masterKey = new MasterKey.Builder(context, MASTER_KEY_ALIAS).setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
            Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"Builder(context, MASTER_KEY_ALIAS)\n                .setKeyScheme(MasterKey.KeyScheme.AES256_GCM)\n                .build()");
            MasterKey masterKey2 = masterKey;
            sharedPreferences2 = EncryptedSharedPreferences.create((Context)context, (String)ENCRYPTED_SYNC_CONFIG_PREFS_NAME, (MasterKey)masterKey2, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences2, (String)"{\n            val masterKey = MasterKey.Builder(context, MASTER_KEY_ALIAS)\n                .setKeyScheme(MasterKey.KeyScheme.AES256_GCM)\n                .build()\n\n            EncryptedSharedPreferences.create(\n                context,\n                ENCRYPTED_SYNC_CONFIG_PREFS_NAME,\n                masterKey,\n                EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV,\n                EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM,\n            )\n        }");
        }
        catch (Exception masterKey2) {
            void e;
            encryptedPushNotificationsConfigStore = encryptedPushNotificationsConfigStore2;
            this.logger.logE("Error creating encrypted shared preferences", (Throwable)e);
            SharedPreferences sharedPreferences3 = context.getApplicationContext().getSharedPreferences(SYNC_CONFIG_PREFS_NAME, 0);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences3, (String)"{\n            logger.logE(\"Error creating encrypted shared preferences\", e)\n            context.applicationContext.getSharedPreferences(\n                SYNC_CONFIG_PREFS_NAME,\n                Context.MODE_PRIVATE,\n            )\n        }");
            sharedPreferences2 = sharedPreferences3;
        }
        encryptedPushNotificationsConfigStore.prefs = sharedPreferences2;
    }

    public final void put(@NotNull PushNotificationsConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        SharedPreferences.Editor editor = this.prefs.edit();
        boolean bl = false;
        boolean bl2 = false;
        SharedPreferences.Editor $this$put_u24lambda_u2d0 = editor;
        boolean bl3 = false;
        $this$put_u24lambda_u2d0.putString(KEY_USER_ID, config.getUserId());
        $this$put_u24lambda_u2d0.putString(KEY_USER_TOKEN, config.getUserToken());
        editor.apply();
    }

    @Nullable
    public final PushNotificationsConfig get() {
        String string2;
        SharedPreferences sharedPreferences2 = this.prefs;
        boolean bl = false;
        boolean bl2 = false;
        SharedPreferences $this$get_u24lambda_u2d1 = sharedPreferences2;
        boolean bl3 = false;
        String string3 = $this$get_u24lambda_u2d1.getString(KEY_USER_ID, "");
        String userId = string2 = string3 == null ? "" : string3;
        String string4 = $this$get_u24lambda_u2d1.getString(KEY_USER_TOKEN, "");
        String userToken = string3 = string4 == null ? "" : string4;
        PushNotificationsConfig config = new PushNotificationsConfig(userId, userToken);
        return config.isValid$stream_chat_android_client_release() ? config : (PushNotificationsConfig)null;
    }

    public final void clear() {
        this.prefs.edit().clear().apply();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/getstream/chat/android/client/notifications/storage/EncryptedPushNotificationsConfigStore$Companion;", "", "()V", "ENCRYPTED_SYNC_CONFIG_PREFS_NAME", "", "KEY_USER_ID", "KEY_USER_TOKEN", "MASTER_KEY_ALIAS", "SYNC_CONFIG_PREFS_NAME", "stream-chat-android-client_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

