/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.network;

import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import io.getstream.chat.android.client.network.NetworkStateProvider;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00009\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005*\u0001\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000eR\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/getstream/chat/android/client/network/NetworkStateProvider;", "", "connectivityManager", "Landroid/net/ConnectivityManager;", "(Landroid/net/ConnectivityManager;)V", "callback", "io/getstream/chat/android/client/network/NetworkStateProvider$callback$1", "Lio/getstream/chat/android/client/network/NetworkStateProvider$callback$1;", "isConnected", "", "isRegistered", "Ljava/util/concurrent/atomic/AtomicBoolean;", "listeners", "", "Lio/getstream/chat/android/client/network/NetworkStateProvider$NetworkStateListener;", "lock", "notifyListenersIfNetworkStateChanged", "", "subscribe", "listener", "unsubscribe", "NetworkStateListener", "stream-chat-android-client_release"})
public final class NetworkStateProvider {
    @NotNull
    private final ConnectivityManager connectivityManager;
    @NotNull
    private final Object lock;
    @NotNull
    private final callback.1 callback;
    private volatile boolean isConnected;
    @NotNull
    private volatile Set<? extends NetworkStateListener> listeners;
    @NotNull
    private final AtomicBoolean isRegistered;

    public NetworkStateProvider(@NotNull ConnectivityManager connectivityManager) {
        Intrinsics.checkNotNullParameter((Object)connectivityManager, (String)"connectivityManager");
        this.connectivityManager = connectivityManager;
        this.lock = new Object();
        this.callback = new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ NetworkStateProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAvailable(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                NetworkStateProvider.access$notifyListenersIfNetworkStateChanged(this.this$0);
            }

            public void onCapabilitiesChanged(@NotNull Network network, @NotNull NetworkCapabilities networkCapabilities) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                Intrinsics.checkNotNullParameter((Object)networkCapabilities, (String)"networkCapabilities");
                NetworkStateProvider.access$notifyListenersIfNetworkStateChanged(this.this$0);
            }

            public void onLost(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                NetworkStateProvider.access$notifyListenersIfNetworkStateChanged(this.this$0);
            }
        };
        this.isConnected = this.isConnected();
        boolean bl = false;
        this.listeners = SetsKt.emptySet();
        this.isRegistered = new AtomicBoolean(false);
    }

    private final void notifyListenersIfNetworkStateChanged() {
        block3: {
            boolean isNowConnected;
            block2: {
                isNowConnected = this.isConnected();
                if (this.isConnected || !isNowConnected) break block2;
                this.isConnected = true;
                Iterable $this$forEach$iv = this.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    NetworkStateListener it = (NetworkStateListener)element$iv;
                    boolean bl = false;
                    it.onConnected();
                }
                break block3;
            }
            if (!this.isConnected || isNowConnected) break block3;
            this.isConnected = false;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NetworkStateListener it = (NetworkStateListener)element$iv;
                boolean bl = false;
                it.onDisconnected();
            }
        }
    }

    public final boolean isConnected() {
        boolean bl;
        if (Build.VERSION.SDK_INT >= 23) {
            ConnectivityManager connectivityManager = this.connectivityManager;
            boolean bl2 = false;
            boolean bl3 = false;
            ConnectivityManager $this$isConnected_u24lambda_u2d3 = connectivityManager;
            boolean bl4 = false;
            NetworkCapabilities networkCapabilities = $this$isConnected_u24lambda_u2d3.getNetworkCapabilities($this$isConnected_u24lambda_u2d3.getActiveNetwork());
            if (networkCapabilities == null) {
                bl = false;
            } else {
                boolean bl5;
                NetworkCapabilities networkCapabilities2 = networkCapabilities;
                boolean bl6 = false;
                boolean bl7 = false;
                NetworkCapabilities $this$isConnected_u24lambda_u2d3_u24lambda_u2d2 = networkCapabilities2;
                boolean bl8 = false;
                bl = bl5 = $this$isConnected_u24lambda_u2d3_u24lambda_u2d2.hasCapability(12) && $this$isConnected_u24lambda_u2d3_u24lambda_u2d2.hasCapability(16);
            }
        } else {
            boolean bl9;
            NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
            bl = networkInfo == null ? false : (bl9 = networkInfo.isConnected());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void subscribe(@NotNull NetworkStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.listeners = SetsKt.plus(this.listeners, (Object)listener);
            if (this.isRegistered.compareAndSet(false, true)) {
                this.connectivityManager.registerNetworkCallback(new NetworkRequest.Builder().build(), (ConnectivityManager.NetworkCallback)this.callback);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void unsubscribe(@NotNull NetworkStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            void it;
            boolean bl3 = false;
            Set set = SetsKt.minus(this.listeners, (Object)listener);
            boolean bl4 = false;
            boolean bl5 = false;
            Set set2 = set;
            NetworkStateProvider networkStateProvider = this;
            boolean bl6 = false;
            if (it.isEmpty() && this.isRegistered.compareAndSet(true, false)) {
                this.connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.callback);
            }
            Unit unit = Unit.INSTANCE;
            networkStateProvider.listeners = set;
            Unit unit2 = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ void access$notifyListenersIfNetworkStateChanged(NetworkStateProvider $this) {
        $this.notifyListenersIfNetworkStateChanged();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/client/network/NetworkStateProvider$NetworkStateListener;", "", "onConnected", "", "onDisconnected", "stream-chat-android-client_release"})
    public static interface NetworkStateListener {
        public void onConnected();

        public void onDisconnected();
    }
}

