/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.socket;

import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.parser.ChatParser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.WebSocket;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/getstream/chat/android/client/socket/Socket;", "", "socket", "Lokhttp3/WebSocket;", "parser", "Lio/getstream/chat/android/client/parser/ChatParser;", "(Lokhttp3/WebSocket;Lio/getstream/chat/android/client/parser/ChatParser;)V", "getParser", "()Lio/getstream/chat/android/client/parser/ChatParser;", "getSocket", "()Lokhttp3/WebSocket;", "close", "", "code", "", "reason", "", "send", "event", "Lio/getstream/chat/android/client/events/ChatEvent;", "stream-chat-android-client_release"})
public final class Socket {
    @NotNull
    private final WebSocket socket;
    @NotNull
    private final ChatParser parser;

    public Socket(@NotNull WebSocket socket, @NotNull ChatParser parser) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        this.socket = socket;
        this.parser = parser;
    }

    @NotNull
    public final WebSocket getSocket() {
        return this.socket;
    }

    @NotNull
    public final ChatParser getParser() {
        return this.parser;
    }

    public final void send(@NotNull ChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.socket.send(this.parser.toJson(event));
    }

    public final void close(int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.socket.close(code, reason);
    }
}

