/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications.handler;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import io.getstream.chat.android.client.R;
import io.getstream.chat.android.client.events.NewMessageEvent;
import io.getstream.chat.android.client.extensions.ChannelExtensionKt;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.PushMessage;
import io.getstream.chat.android.client.notifications.handler.ChatNotificationHandler;
import io.getstream.chat.android.client.notifications.handler.NotificationHandler;
import io.getstream.chat.android.client.receivers.NotificationMessageReceiver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 A2\u00020\u0001:\u0001AB\\\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012M\b\u0002\u0010\u0004\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010%\u001a\u00020&H\u0007J\b\u0010'\u001a\u00020\u001aH\u0016J\u0018\u0010(\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001c0+2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010,\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010-\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J(\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\fH\u0002J\b\u00103\u001a\u00020\u0006H\u0002J\b\u00104\u001a\u00020\u0006H\u0002J\u0018\u00105\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0018\u00106\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u00107\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u00108\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020\u001c0+H\u0002J\b\u0010:\u001a\u00020\u001cH\u0002J\u0010\u0010;\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010<\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010<\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020>H\u0002J\u000e\u0010?\u001a\u0004\u0018\u00010\u0006*\u00020!H\u0002J\f\u0010@\u001a\u00020\u0006*\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RS\u0010\u0004\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006B"}, d2={"Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;", "Lio/getstream/chat/android/client/notifications/handler/NotificationHandler;", "context", "Landroid/content/Context;", "newMessageIntent", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "messageId", "channelType", "channelId", "Landroid/content/Intent;", "(Landroid/content/Context;Lkotlin/jvm/functions/Function3;)V", "notificationManager", "Landroid/app/NotificationManager;", "getNotificationManager", "()Landroid/app/NotificationManager;", "notificationManager$delegate", "Lkotlin/Lazy;", "sharedPreferences", "Landroid/content/SharedPreferences;", "getSharedPreferences", "()Landroid/content/SharedPreferences;", "sharedPreferences$delegate", "addNotificationId", "", "notificationId", "", "notificationSummaryId", "buildNotification", "Landroidx/core/app/NotificationCompat$Builder;", "channel", "Lio/getstream/chat/android/client/models/Channel;", "message", "Lio/getstream/chat/android/client/models/Message;", "buildNotificationGroupSummary", "createNotificationChannel", "Landroid/app/NotificationChannel;", "dismissAllNotifications", "dismissChannelNotifications", "dismissSummaryNotification", "getAssociatedNotificationIds", "", "getAssociatedNotificationSummaryId", "getNewMessageIntent", "getNotificationBuilder", "contentTitle", "contentText", "groupKey", "intent", "getNotificationChannelId", "getNotificationChannelName", "getNotificationGroupKey", "getNotificationGroupSummaryId", "getNotificationIdKey", "getNotificationSummaryIdKey", "getNotificationSummaryIds", "getRequestCode", "removeNotificationId", "showNotification", "notification", "Landroid/app/Notification;", "getMemberNamesWithoutCurrentUser", "getNotificationContentTitle", "Companion", "stream-chat-android-client_release"})
public final class ChatNotificationHandler
implements NotificationHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Function3<String, String, String, Intent> newMessageIntent;
    @NotNull
    private final Lazy sharedPreferences$delegate;
    @NotNull
    private final Lazy notificationManager$delegate;
    @Deprecated
    @NotNull
    private static final String SHARED_PREFERENCES_NAME = "stream_notifications.sp";
    @Deprecated
    @NotNull
    private static final String KEY_PREFIX_NOTIFICATION_ID = "nId-";
    @Deprecated
    @NotNull
    private static final String KEY_PREFIX_NOTIFICATION_SUMMARY_ID = "nSId-";
    @Deprecated
    @NotNull
    private static final String KEY_NOTIFICATION_SUMMARY_IDS = "notification_summary_ids";

    public ChatNotificationHandler(@NotNull Context context, @NotNull Function3<? super String, ? super String, ? super String, ? extends Intent> newMessageIntent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(newMessageIntent, (String)"newMessageIntent");
        this.context = context;
        this.newMessageIntent = newMessageIntent;
        this.sharedPreferences$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SharedPreferences>(this){
            final /* synthetic */ ChatNotificationHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final SharedPreferences invoke() {
                return ChatNotificationHandler.access$getContext$p(this.this$0).getSharedPreferences("stream_notifications.sp", 0);
            }
        }));
        this.notificationManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NotificationManager>(this){
            final /* synthetic */ ChatNotificationHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NotificationManager invoke() {
                Object object = ChatNotificationHandler.access$getContext$p(this.this$0).getSystemService("notification");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
                }
                object = (NotificationManager)object;
                ChatNotificationHandler chatNotificationHandler = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                if (Build.VERSION.SDK_INT >= 26) {
                    it.createNotificationChannel(chatNotificationHandler.createNotificationChannel());
                }
                return object;
            }
        }));
    }

    public /* synthetic */ ChatNotificationHandler(final Context context, Function3 function3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function3 = (Function3)new Function3<String, String, String, Intent>(){

                @NotNull
                public final Intent invoke(@NotNull String $noName_0, @NotNull String $noName_1, @NotNull String $noName_2) {
                    Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
                    Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"$noName_1");
                    Intrinsics.checkNotNullParameter((Object)$noName_2, (String)"$noName_2");
                    PackageManager packageManager = context.getPackageManager();
                    Intrinsics.checkNotNull((Object)packageManager);
                    Intent intent = packageManager.getLaunchIntentForPackage(context.getPackageName());
                    Intrinsics.checkNotNull((Object)intent);
                    Intent intent2 = intent;
                    Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"context.packageManager!!\u2026ge(context.packageName)!!");
                    return intent2;
                }
            };
        }
        this(context, (Function3<? super String, ? super String, ? super String, ? extends Intent>)function3);
    }

    private final SharedPreferences getSharedPreferences() {
        Lazy lazy = this.sharedPreferences$delegate;
        Object var3_2 = null;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-sharedPreferences>(...)");
        return (SharedPreferences)object;
    }

    private final NotificationManager getNotificationManager() {
        Lazy lazy = this.notificationManager$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (NotificationManager)lazy.getValue();
    }

    @RequiresApi(api=26)
    @NotNull
    public final NotificationChannel createNotificationChannel() {
        NotificationChannel notificationChannel = new NotificationChannel(this.getNotificationChannelId(), (CharSequence)this.getNotificationChannelName(), 3);
        boolean bl = false;
        boolean bl2 = false;
        NotificationChannel $this$createNotificationChannel_u24lambda_u2d0 = notificationChannel;
        boolean bl3 = false;
        $this$createNotificationChannel_u24lambda_u2d0.setShowBadge(true);
        $this$createNotificationChannel_u24lambda_u2d0.setImportance(4);
        $this$createNotificationChannel_u24lambda_u2d0.enableLights(true);
        $this$createNotificationChannel_u24lambda_u2d0.setLightColor(-65536);
        $this$createNotificationChannel_u24lambda_u2d0.enableVibration(true);
        long[] lArray = new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L};
        $this$createNotificationChannel_u24lambda_u2d0.setVibrationPattern(lArray);
        return notificationChannel;
    }

    private final String getNotificationChannelId() {
        String string2 = this.context.getString(R.string.stream_chat_notification_channel_id);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026_notification_channel_id)");
        return string2;
    }

    private final String getNotificationChannelName() {
        String string2 = this.context.getString(R.string.stream_chat_notification_channel_name);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026otification_channel_name)");
        return string2;
    }

    @Override
    public void showNotification(@NotNull Channel channel, @NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        int notificationId = (int)System.nanoTime();
        int notificationSummaryId = this.getNotificationGroupSummaryId(channel.getType(), channel.getId());
        this.addNotificationId(notificationId, notificationSummaryId);
        Notification notification = this.buildNotification(notificationId, channel, message).build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"buildNotification(notifi\u2026channel, message).build()");
        this.showNotification(notificationId, notification);
        notification = this.buildNotificationGroupSummary(channel, message).build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"buildNotificationGroupSu\u2026channel, message).build()");
        this.showNotification(notificationSummaryId, notification);
    }

    private final NotificationCompat.Builder buildNotification(int notificationId, Channel channel, Message message) {
        NotificationCompat.Builder builder = this.getNotificationBuilder(this.getNotificationContentTitle(channel), message.getText(), this.getNotificationGroupKey(channel.getType(), channel.getId()), this.getNewMessageIntent(message.getId(), channel.getType(), channel.getId()));
        boolean bl = false;
        boolean bl2 = false;
        NotificationCompat.Builder $this$buildNotification_u24lambda_u2d1 = builder;
        boolean bl3 = false;
        $this$buildNotification_u24lambda_u2d1.addAction(NotificationMessageReceiver.Companion.createReadAction$stream_chat_android_client_release(this.context, notificationId, channel, message));
        $this$buildNotification_u24lambda_u2d1.addAction(NotificationMessageReceiver.Companion.createReplyAction$stream_chat_android_client_release(this.context, notificationId, channel));
        $this$buildNotification_u24lambda_u2d1.setDeleteIntent(NotificationMessageReceiver.Companion.createDismissPendingIntent$stream_chat_android_client_release(this.context, notificationId, channel));
        return builder;
    }

    private final NotificationCompat.Builder buildNotificationGroupSummary(Channel channel, Message message) {
        String string2 = this.getNotificationContentTitle(channel);
        String string3 = this.context.getString(R.string.stream_chat_notification_group_summary_content_text);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.stri\u2026oup_summary_content_text)");
        string3 = this.getNotificationBuilder(string2, string3, this.getNotificationGroupKey(channel.getType(), channel.getId()), this.getNewMessageIntent(message.getId(), channel.getType(), channel.getId()));
        boolean bl = false;
        boolean bl2 = false;
        String $this$buildNotificationGroupSummary_u24lambda_u2d2 = string3;
        boolean bl3 = false;
        $this$buildNotificationGroupSummary_u24lambda_u2d2.setGroupSummary(true);
        return string3;
    }

    private final String getNotificationGroupKey(String channelType, String channelId) {
        return channelType + ':' + channelId;
    }

    private final int getNotificationGroupSummaryId(String channelType, String channelId) {
        return this.getNotificationGroupKey(channelType, channelId).hashCode();
    }

    private final int getRequestCode() {
        return (int)System.currentTimeMillis();
    }

    private final Intent getNewMessageIntent(String messageId, String channelType, String channelId) {
        return (Intent)this.newMessageIntent.invoke((Object)messageId, (Object)channelType, (Object)channelId);
    }

    @Override
    public void dismissChannelNotifications(@NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        this.dismissSummaryNotification(this.getNotificationGroupSummaryId(channelType, channelId));
    }

    @Override
    public void dismissAllNotifications() {
        Iterable $this$forEach$iv = this.getNotificationSummaryIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int p0 = ((Number)element$iv).intValue();
            boolean bl = false;
            this.dismissSummaryNotification(p0);
        }
    }

    private final void showNotification(int notificationId, Notification notification) {
        this.getNotificationManager().notify(notificationId, notification);
    }

    private final NotificationCompat.Builder getNotificationBuilder(String contentTitle, String contentText, String groupKey, Intent intent) {
        int flags = Build.VERSION.SDK_INT >= 23 ? 0xC000000 : 0x8000000;
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this.context, (int)this.getRequestCode(), (Intent)intent, (int)flags);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context, this.getNotificationChannelId()).setDefaults(-1).setAutoCancel(true).setSmallIcon(R.drawable.stream_ic_notification).setContentTitle((CharSequence)contentTitle).setContentText((CharSequence)contentText).setPriority(1).setCategory("msg").setShowWhen(true).setContentIntent(contentIntent).setGroup(groupKey);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder(context, getNoti\u2026      .setGroup(groupKey)");
        return builder;
    }

    private final String getNotificationContentTitle(Channel $this$getNotificationContentTitle) {
        String string2;
        String string3;
        String string4 = $this$getNotificationContentTitle.getName();
        boolean bl = false;
        boolean bl2 = false;
        String it = string4;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        String string5 = string3 = charSequence.length() > 0 ? string4 : null;
        if (string3 == null) {
            string4 = this.getMemberNamesWithoutCurrentUser($this$getNotificationContentTitle);
            if (string4 == null) {
                String string6 = this.context.getString(R.string.stream_chat_notification_title);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"context.getString(R.stri\u2026_chat_notification_title)");
                string2 = string6;
            } else {
                string2 = string4;
            }
        } else {
            string2 = string3;
        }
        return string2;
    }

    private final String getMemberNamesWithoutCurrentUser(Channel $this$getMemberNamesWithoutCurrentUser) {
        String string2 = CollectionsKt.joinToString$default((Iterable)ChannelExtensionKt.getUsersExcludingCurrent($this$getMemberNamesWithoutCurrentUser), null, null, null, (int)0, null, (Function1)getMemberNamesWithoutCurrentUser.1.INSTANCE, (int)31, null);
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        return charSequence.length() > 0 ? string2 : null;
    }

    private final void dismissSummaryNotification(int notificationSummaryId) {
        Iterable $this$forEach$iv = this.getAssociatedNotificationIds(notificationSummaryId);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            this.getNotificationManager().cancel(it);
            this.removeNotificationId(it);
        }
        this.getNotificationManager().cancel(notificationSummaryId);
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$dismissSummaryNotification_u24lambda_u2d6 = editor$iv;
        boolean bl = false;
        $this$dismissSummaryNotification_u24lambda_u2d6.remove(this.getNotificationSummaryIdKey(notificationSummaryId));
        editor$iv.apply();
    }

    private final void addNotificationId(int notificationId, int notificationSummaryId) {
        String string2;
        int p0;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$addNotificationId_u24lambda_u2d9 = editor$iv;
        boolean bl = false;
        $this$addNotificationId_u24lambda_u2d9.putInt(this.getNotificationIdKey(notificationId), notificationSummaryId);
        Iterable iterable = SetsKt.plus(this.getNotificationSummaryIds(), (Object)notificationSummaryId);
        String string3 = KEY_NOTIFICATION_SUMMARY_IDS;
        SharedPreferences.Editor editor = $this$addNotificationId_u24lambda_u2d9;
        boolean $i$f$map = false;
        void var13_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl2 = false;
            string2 = String.valueOf(p0);
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        editor.putStringSet(string3, CollectionsKt.toSet((Iterable)collection));
        $this$map$iv = SetsKt.plus(this.getAssociatedNotificationIds(notificationSummaryId), (Object)notificationId);
        string3 = this.getNotificationSummaryIdKey(notificationSummaryId);
        editor = $this$addNotificationId_u24lambda_u2d9;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl3 = false;
            string2 = String.valueOf(p0);
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        editor.putStringSet(string3, CollectionsKt.toSet((Iterable)collection));
        editor$iv.apply();
    }

    /*
     * WARNING - void declaration
     */
    private final void removeNotificationId(int notificationId) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$removeNotificationId_u24lambda_u2d11 = editor$iv;
        boolean bl = false;
        int notificationSummaryId = this.getAssociatedNotificationSummaryId(notificationId);
        $this$removeNotificationId_u24lambda_u2d11.remove(this.getNotificationIdKey(notificationId));
        Iterable iterable = SetsKt.minus(this.getAssociatedNotificationIds(notificationSummaryId), (Object)notificationId);
        String string2 = this.getNotificationSummaryIdKey(notificationSummaryId);
        SharedPreferences.Editor editor = $this$removeNotificationId_u24lambda_u2d11;
        boolean $i$f$map = false;
        void var13_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl2 = false;
            String string3 = String.valueOf((int)p0);
            collection.add(string3);
        }
        collection = (List)destination$iv$iv;
        editor.putStringSet(string2, CollectionsKt.toSet((Iterable)collection));
        editor$iv.apply();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Integer> getNotificationSummaryIds() {
        void $this$mapTo$iv$iv;
        Set set = this.getSharedPreferences().getStringSet(KEY_NOTIFICATION_SUMMARY_IDS, null);
        boolean bl = false;
        Set set2 = set;
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        Iterable $this$map$iv = set2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var10_10 = p0;
            boolean bl3 = false;
            Integer n = Integer.parseInt((String)var10_10);
            collection.add(n);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final int getAssociatedNotificationSummaryId(int notificationId) {
        return this.getSharedPreferences().getInt(this.getNotificationIdKey(notificationId), 0);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Integer> getAssociatedNotificationIds(int notificationSummaryId) {
        void $this$mapTo$iv$iv;
        Set set = this.getSharedPreferences().getStringSet(this.getNotificationSummaryIdKey(notificationSummaryId), null);
        boolean bl = false;
        Set set2 = set;
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        Iterable $this$map$iv = set2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var11_11 = p0;
            boolean bl3 = false;
            Integer n = Integer.parseInt((String)var11_11);
            collection.add(n);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final String getNotificationIdKey(int notificationId) {
        return Intrinsics.stringPlus((String)KEY_PREFIX_NOTIFICATION_ID, (Object)notificationId);
    }

    private final String getNotificationSummaryIdKey(int notificationSummaryId) {
        return Intrinsics.stringPlus((String)KEY_PREFIX_NOTIFICATION_SUMMARY_ID, (Object)notificationSummaryId);
    }

    @Override
    public boolean onChatEvent(@NotNull NewMessageEvent event) {
        return NotificationHandler.DefaultImpls.onChatEvent(this, event);
    }

    @Override
    public boolean onPushMessage(@NotNull PushMessage message) {
        return NotificationHandler.DefaultImpls.onPushMessage(this, message);
    }

    public static final /* synthetic */ Context access$getContext$p(ChatNotificationHandler $this) {
        return $this.context;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler$Companion;", "", "()V", "KEY_NOTIFICATION_SUMMARY_IDS", "", "KEY_PREFIX_NOTIFICATION_ID", "KEY_PREFIX_NOTIFICATION_SUMMARY_ID", "SHARED_PREFERENCES_NAME", "stream-chat-android-client_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

