/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.helpers;

import io.getstream.chat.android.client.models.Attachment;
import io.getstream.chat.android.client.utils.SystemTimeProvider;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@InternalStreamChatApi
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/getstream/chat/android/client/helpers/AttachmentHelper;", "", "systemTimeProvider", "Lio/getstream/chat/android/client/utils/SystemTimeProvider;", "(Lio/getstream/chat/android/client/utils/SystemTimeProvider;)V", "hasStreamImageUrl", "", "attachment", "Lio/getstream/chat/android/client/models/Attachment;", "hasValidImageUrl", "Companion", "stream-chat-android-client_release"})
public final class AttachmentHelper {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final SystemTimeProvider systemTimeProvider;
    @Deprecated
    @NotNull
    private static final String QUERY_KEY_NAME_EXPIRES = "Expires";
    @Deprecated
    @NotNull
    private static final Regex STREAM_CDN_HOST_PATTERN;

    public AttachmentHelper(@NotNull SystemTimeProvider systemTimeProvider) {
        Intrinsics.checkNotNullParameter((Object)systemTimeProvider, (String)"systemTimeProvider");
        this.systemTimeProvider = systemTimeProvider;
    }

    public /* synthetic */ AttachmentHelper(SystemTimeProvider systemTimeProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            systemTimeProvider = new SystemTimeProvider();
        }
        this(systemTimeProvider);
    }

    public final boolean hasValidImageUrl(@NotNull Attachment attachment) {
        Long l;
        HttpUrl httpUrl;
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        String string = attachment.getImageUrl();
        HttpUrl httpUrl2 = httpUrl = string == null ? null : HttpUrl.Companion.parse(string);
        if (httpUrl == null) {
            return false;
        }
        HttpUrl url = httpUrl;
        if (!url.queryParameterNames().contains(QUERY_KEY_NAME_EXPIRES)) {
            return true;
        }
        String string2 = url.queryParameter(QUERY_KEY_NAME_EXPIRES);
        Long l2 = l = string2 == null ? null : StringsKt.toLongOrNull((String)string2);
        if (l == null) {
            return false;
        }
        long timestamp = l;
        return timestamp > this.systemTimeProvider.provideCurrentTimeInSeconds();
    }

    public final boolean hasStreamImageUrl(@NotNull Attachment attachment) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        String string = attachment.getImageUrl();
        if (string == null) {
            bl = false;
        } else {
            HttpUrl httpUrl = HttpUrl.Companion.parse(string);
            if (httpUrl == null) {
                bl = false;
            } else {
                String string2 = httpUrl.host();
                if (string2 == null) {
                    bl = false;
                } else {
                    boolean bl2;
                    String string3 = string2;
                    Regex regex = STREAM_CDN_HOST_PATTERN;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    CharSequence p0 = string3;
                    boolean bl5 = false;
                    bl = bl2 = regex.matches(p0);
                }
            }
        }
        return bl;
    }

    public AttachmentHelper() {
        this(null, 1, null);
    }

    static {
        String string = "stream-chat-+.+\\.imgix.net$|.+\\.stream-io-cdn.com$";
        RegexOption regexOption = RegexOption.IGNORE_CASE;
        boolean bl = false;
        STREAM_CDN_HOST_PATTERN = new Regex(string, regexOption);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/getstream/chat/android/client/helpers/AttachmentHelper$Companion;", "", "()V", "QUERY_KEY_NAME_EXPIRES", "", "STREAM_CDN_HOST_PATTERN", "Lkotlin/text/Regex;", "stream-chat-android-client_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

