/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.parser;

import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.errors.ChatErrorCode;
import io.getstream.chat.android.client.errors.ChatNetworkError;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.socket.ErrorResponse;
import io.getstream.chat.android.client.utils.Result;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import retrofit2.Retrofit;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J-\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH&\u00a2\u0006\u0002\u0010\fJ.\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\b0\u000e\"\b\b\u0000\u0010\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0001H&R\u000b\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a8\u0006\u0015"}, d2={"Lio/getstream/chat/android/client/parser/ChatParser;", "", "TAG", "", "configRetrofit", "Lretrofit2/Retrofit$Builder;", "builder", "fromJson", "T", "raw", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "fromJsonOrError", "Lio/getstream/chat/android/client/utils/Result;", "toError", "Lio/getstream/chat/android/client/errors/ChatNetworkError;", "okHttpResponse", "Lokhttp3/Response;", "toJson", "any", "stream-chat-android-client_release"})
public interface ChatParser {
    @NotNull
    public String toJson(@NotNull Object var1);

    @NotNull
    public <T> T fromJson(@NotNull String var1, @NotNull Class<T> var2);

    @NotNull
    public Retrofit.Builder configRetrofit(@NotNull Retrofit.Builder var1);

    @NotNull
    public <T> Result<T> fromJsonOrError(@NotNull String var1, @NotNull Class<T> var2);

    @NotNull
    public ChatNetworkError toError(@NotNull Response var1);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        private static String getTAG(ChatParser this_) {
            String string2 = ChatParser.class.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ChatParser::class.java.simpleName");
            return string2;
        }

        @NotNull
        public static <T> Result<T> fromJsonOrError(@NotNull ChatParser this_, @NotNull String raw, @NotNull Class<T> clazz) {
            Result result;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            try {
                result = new Result(this_.fromJson(raw, clazz));
            }
            catch (Throwable t) {
                result = new Result(new ChatError("fromJsonOrError error parsing of " + clazz + " into " + raw, t));
            }
            return result;
        }

        @NotNull
        public static ChatNetworkError toError(@NotNull ChatParser this_, @NotNull Response okHttpResponse) {
            ChatNetworkError chatNetworkError;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)okHttpResponse, (String)"okHttpResponse");
            int statusCode = okHttpResponse.code();
            try {
                ChatNetworkError chatNetworkError2;
                String body = okHttpResponse.peekBody(Long.MAX_VALUE).string();
                if (((CharSequence)body).length() == 0) {
                    chatNetworkError2 = ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, ChatErrorCode.NO_ERROR_BODY, null, statusCode, 2, null);
                } else {
                    ErrorResponse errorResponse;
                    try {
                        errorResponse = this_.fromJson(body, ErrorResponse.class);
                    }
                    catch (Throwable t) {
                        ErrorResponse errorResponse2;
                        ErrorResponse $this$toError_u24lambda_u2d0 = errorResponse2 = new ErrorResponse(0, null, 0, 7, null);
                        boolean bl = false;
                        $this$toError_u24lambda_u2d0.setMessage(body);
                        errorResponse = errorResponse2;
                    }
                    ErrorResponse error = errorResponse;
                    chatNetworkError2 = ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, error.getCode(), error.getMessage(), statusCode, null, 8, null);
                }
                chatNetworkError = chatNetworkError2;
            }
            catch (Throwable t) {
                ChatLogger.Companion.getInstance().logE((Object)DefaultImpls.getTAG(this_), t);
                chatNetworkError = ChatNetworkError.Companion.create(ChatErrorCode.NETWORK_FAILED, t, statusCode);
            }
            return chatNetworkError;
        }
    }
}

