/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.utils;

import android.util.Log;
import io.getstream.chat.android.client.utils.PerformanceUtils;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalStreamChatApi
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J=\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\u0006\u0010\t\u001a\u00020\u00052\u001c\u0010\u0011\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J'\u0010\u0011\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\u0006\u0010\t\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0015\u00a2\u0006\u0002\u0010\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lio/getstream/chat/android/client/utils/PerformanceUtils;", "", "()V", "tasks", "", "", "Lio/getstream/chat/android/client/utils/PerformanceUtils$TaskEntry;", "doMeasureAndUpdateResult", "", "taskName", "entry", "log", "message", "startTask", "stopTask", "suspendTask", "T", "task", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "TaskEntry", "stream-chat-android-client_release"})
public final class PerformanceUtils {
    @NotNull
    public static final PerformanceUtils INSTANCE = new PerformanceUtils();
    @NotNull
    private static volatile Map<String, TaskEntry> tasks = MapsKt.emptyMap();

    private PerformanceUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startTask(@NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        synchronized (taskName) {
            boolean bl = false;
            long startTime = System.currentTimeMillis();
            TaskEntry lastEntry = tasks.get(taskName);
            tasks = lastEntry == null ? MapsKt.plus(tasks, (Pair)TuplesKt.to((Object)taskName, (Object)new TaskEntry(taskName, 0, 0.0, startTime))) : MapsKt.plus(tasks, (Pair)TuplesKt.to((Object)taskName, (Object)TaskEntry.copy$default(lastEntry, null, 0, 0.0, startTime, 7, null)));
            INSTANCE.log("Task \"" + taskName + "\" started");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopTask(@NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        synchronized (taskName) {
            boolean bl = false;
            TaskEntry lastEntry = tasks.get(taskName);
            if (lastEntry == null) {
                INSTANCE.log("There is no such task \"" + taskName + '\"');
                return;
            }
            INSTANCE.doMeasureAndUpdateResult(taskName, lastEntry);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void doMeasureAndUpdateResult(String taskName, TaskEntry entry) {
        Long l = entry.getLastStart();
        if (l != null) {
            long startTime = ((Number)l).longValue();
            boolean bl = false;
            double lastDuration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            double newSumDuration = entry.getSumDuration() + lastDuration;
            int newCount = entry.getCount() + 1;
            tasks = MapsKt.plus(tasks, (Pair)TuplesKt.to((Object)taskName, (Object)TaskEntry.copy$default(entry, null, newCount, newSumDuration, null, 1, null)));
            double avgDuration = newSumDuration / (double)newCount;
            INSTANCE.log("Task \"" + taskName + "\" completed for " + lastDuration + " seconds\nThe average duration for task \"" + taskName + "\" is " + avgDuration + " seconds");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T task(@NotNull String taskName, @NotNull Function0<? extends T> task) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        synchronized (taskName) {
            Object object;
            int n;
            boolean bl = false;
            TaskEntry taskEntry = tasks.get(taskName);
            int count = taskEntry == null ? 0 : (n = taskEntry.getCount());
            long startTime = System.currentTimeMillis();
            Object it = object = task.invoke();
            boolean bl2 = false;
            INSTANCE.doMeasureAndUpdateResult(taskName, new TaskEntry(taskName, count, 0.0, startTime, 4, null));
            Object object2 = object;
            return (T)object2;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final <T> Object suspendTask(@NotNull String var1_1, @NotNull Function1<? super Continuation<? super T>, ? extends Object> var2_2, @NotNull Continuation<? super T> var3_3) {
        if (!(var3_3 instanceof suspendTask.1)) ** GOTO lbl-1000
        var10_4 = var3_3;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                int I$0;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ PerformanceUtils this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.suspendTask(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = PerformanceUtils.tasks.get(taskName);
                count = v0 == null ? 0 : (var6_7 = v0.getCount());
                startTime = System.currentTimeMillis();
                $continuation.L$0 = taskName;
                $continuation.I$0 = count;
                $continuation.J$0 = startTime;
                $continuation.label = 1;
                v1 = task.invoke($continuation);
                if (v1 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl29
            }
            case 1: {
                startTime = $continuation.J$0;
                count = $continuation.I$0;
                taskName = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl29:
                // 2 sources

                var7_10 = v1;
                $i$a$-also-PerformanceUtils$suspendTask$2 = false;
                PerformanceUtils.INSTANCE.doMeasureAndUpdateResult(taskName, new TaskEntry(taskName, count, 0.0, Boxing.boxLong((long)startTime), 4, null));
                return var7_10;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Log.d((String)"Performance", (String)message);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ8\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lio/getstream/chat/android/client/utils/PerformanceUtils$TaskEntry;", "", "name", "", "count", "", "sumDuration", "", "lastStart", "", "(Ljava/lang/String;IDLjava/lang/Long;)V", "getCount", "()I", "getLastStart", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getName", "()Ljava/lang/String;", "getSumDuration", "()D", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/String;IDLjava/lang/Long;)Lio/getstream/chat/android/client/utils/PerformanceUtils$TaskEntry;", "equals", "", "other", "hashCode", "toString", "stream-chat-android-client_release"})
    private static final class TaskEntry {
        @NotNull
        private final String name;
        private final int count;
        private final double sumDuration;
        @Nullable
        private final Long lastStart;

        public TaskEntry(@NotNull String name, int count, double sumDuration, @Nullable Long lastStart) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.count = count;
            this.sumDuration = sumDuration;
            this.lastStart = lastStart;
        }

        public /* synthetic */ TaskEntry(String string2, int n, double d, Long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                d = 0.0;
            }
            this(string2, n, d, l);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getCount() {
            return this.count;
        }

        public final double getSumDuration() {
            return this.sumDuration;
        }

        @Nullable
        public final Long getLastStart() {
            return this.lastStart;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final int component2() {
            return this.count;
        }

        public final double component3() {
            return this.sumDuration;
        }

        @Nullable
        public final Long component4() {
            return this.lastStart;
        }

        @NotNull
        public final TaskEntry copy(@NotNull String name, int count, double sumDuration, @Nullable Long lastStart) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new TaskEntry(name, count, sumDuration, lastStart);
        }

        public static /* synthetic */ TaskEntry copy$default(TaskEntry taskEntry, String string2, int n, double d, Long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string2 = taskEntry.name;
            }
            if ((n2 & 2) != 0) {
                n = taskEntry.count;
            }
            if ((n2 & 4) != 0) {
                d = taskEntry.sumDuration;
            }
            if ((n2 & 8) != 0) {
                l = taskEntry.lastStart;
            }
            return taskEntry.copy(string2, n, d, l);
        }

        @NotNull
        public String toString() {
            return "TaskEntry(name=" + this.name + ", count=" + this.count + ", sumDuration=" + this.sumDuration + ", lastStart=" + this.lastStart + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Integer.hashCode(this.count);
            result = result * 31 + Double.hashCode(this.sumDuration);
            result = result * 31 + (this.lastStart == null ? 0 : ((Object)this.lastStart).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TaskEntry)) {
                return false;
            }
            TaskEntry taskEntry = (TaskEntry)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)taskEntry.name)) {
                return false;
            }
            if (this.count != taskEntry.count) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sumDuration, (Object)taskEntry.sumDuration)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lastStart, (Object)taskEntry.lastStart);
        }
    }
}

