/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.di;

import android.content.Context;
import android.net.ConnectivityManager;
import com.moczul.ok2curl.CurlInterceptor;
import com.moczul.ok2curl.logger.Loggable;
import io.getstream.chat.android.client.api.AnonymousApi;
import io.getstream.chat.android.client.api.AuthenticatedApi;
import io.getstream.chat.android.client.api.ChatApi;
import io.getstream.chat.android.client.api.ChatClientConfig;
import io.getstream.chat.android.client.api.HeadersInterceptor;
import io.getstream.chat.android.client.api.HttpLoggingInterceptor;
import io.getstream.chat.android.client.api.RetrofitAnonymousApi;
import io.getstream.chat.android.client.api.RetrofitApi;
import io.getstream.chat.android.client.api.RetrofitCallAdapterFactory;
import io.getstream.chat.android.client.api.RetrofitCdnApi;
import io.getstream.chat.android.client.api.TokenAuthInterceptor;
import io.getstream.chat.android.client.di.BaseChatModule;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.network.NetworkStateProvider;
import io.getstream.chat.android.client.notifications.ChatNotifications;
import io.getstream.chat.android.client.notifications.handler.ChatNotificationHandler;
import io.getstream.chat.android.client.parser.ChatParser;
import io.getstream.chat.android.client.socket.ChatSocket;
import io.getstream.chat.android.client.socket.ChatSocketImpl;
import io.getstream.chat.android.client.token.TokenManager;
import io.getstream.chat.android.client.token.TokenManagerImpl;
import io.getstream.chat.android.client.uploader.FileUploader;
import io.getstream.chat.android.client.uploader.StreamFileUploader;
import io.getstream.chat.android.client.utils.UuidGenerator;
import io.getstream.chat.android.client.utils.UuidGeneratorImpl;
import java.lang.annotation.Annotation;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.CallAdapter;
import retrofit2.Retrofit;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u00102\u001a\u00020\u0014J\b\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u00142\u0006\u00106\u001a\u00020\u0005H\u0002J\u0018\u00107\u001a\u00020 2\u0006\u00108\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0014H\u0002J0\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010?\u001a\u00020%2\u0006\u0010.\u001a\u00020/H\u0002J!\u0010@\u001a\u0002HA\"\u0004\b\u0000\u0010A2\f\u0010B\u001a\b\u0012\u0004\u0012\u0002HA00H\u0002\u00a2\u0006\u0002\u0010CJ\b\u0010D\u001a\u00020EH\u0002J\u0018\u0010F\u001a\u00020*2\u0006\u00106\u001a\u00020\u00052\u0006\u0010?\u001a\u00020%H\u0002J(\u0010G\u001a\u0002042\u0006\u0010=\u001a\u00020>2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010?\u001a\u00020%2\u0006\u0010.\u001a\u00020/H\u0014J\u001e\u0010H\u001a\b\u0012\u0004\u0012\u00020/0I2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/H\u0002J\u0006\u0010J\u001a\u00020\u001eJ\u0006\u0010K\u001a\u00020 J\u0006\u0010?\u001a\u00020%J\u0006\u0010L\u001a\u00020*R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0012\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0012\u001a\u0004\b!\u0010\"R\u001b\u0010$\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0012\u001a\u0004\b&\u0010'R\u001b\u0010)\u001a\u00020*8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\u0012\u001a\u0004\b+\u0010,R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010.\u001a\u00020/*\u0006\u0012\u0002\b\u0003008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u00101\u00a8\u0006M"}, d2={"Lio/getstream/chat/android/client/di/BaseChatModule;", "", "appContext", "Landroid/content/Context;", "config", "Lio/getstream/chat/android/client/api/ChatClientConfig;", "notificationsHandler", "Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;", "fileUploader", "Lio/getstream/chat/android/client/uploader/FileUploader;", "tokenManager", "Lio/getstream/chat/android/client/token/TokenManager;", "(Landroid/content/Context;Lio/getstream/chat/android/client/api/ChatClientConfig;Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;Lio/getstream/chat/android/client/uploader/FileUploader;Lio/getstream/chat/android/client/token/TokenManager;)V", "baseClient", "Lokhttp3/OkHttpClient;", "getBaseClient", "()Lokhttp3/OkHttpClient;", "baseClient$delegate", "Lkotlin/Lazy;", "defaultApi", "Lio/getstream/chat/android/client/api/ChatApi;", "getDefaultApi", "()Lio/getstream/chat/android/client/api/ChatApi;", "defaultApi$delegate", "defaultFileUploader", "Lio/getstream/chat/android/client/uploader/StreamFileUploader;", "getDefaultFileUploader", "()Lio/getstream/chat/android/client/uploader/StreamFileUploader;", "defaultFileUploader$delegate", "defaultLogger", "Lio/getstream/chat/android/client/logger/ChatLogger;", "defaultNotifications", "Lio/getstream/chat/android/client/notifications/ChatNotifications;", "getDefaultNotifications", "()Lio/getstream/chat/android/client/notifications/ChatNotifications;", "defaultNotifications$delegate", "defaultParser", "Lio/getstream/chat/android/client/parser/ChatParser;", "getDefaultParser", "()Lio/getstream/chat/android/client/parser/ChatParser;", "defaultParser$delegate", "defaultSocket", "Lio/getstream/chat/android/client/socket/ChatSocket;", "getDefaultSocket", "()Lio/getstream/chat/android/client/socket/ChatSocket;", "defaultSocket$delegate", "isAnonymousApi", "", "Ljava/lang/Class;", "(Ljava/lang/Class;)Z", "api", "baseClientBuilder", "Lokhttp3/OkHttpClient$Builder;", "buildApi", "chatConfig", "buildNotification", "handler", "buildRetrofit", "Lretrofit2/Retrofit;", "endpoint", "", "timeout", "", "parser", "buildRetrofitApi", "T", "apiClass", "(Ljava/lang/Class;)Ljava/lang/Object;", "buildRetrofitCdnApi", "Lio/getstream/chat/android/client/api/RetrofitCdnApi;", "buildSocket", "clientBuilder", "getAnonymousProvider", "Lkotlin/Function0;", "logger", "notifications", "socket", "stream-chat-android-client_release"})
public class BaseChatModule {
    private final ChatLogger defaultLogger;
    private final Lazy defaultParser$delegate;
    private final Lazy defaultNotifications$delegate;
    private final Lazy defaultApi$delegate;
    private final Lazy defaultSocket$delegate;
    private final Lazy defaultFileUploader$delegate;
    private final Lazy baseClient$delegate;
    private final Context appContext;
    private final ChatClientConfig config;
    private final ChatNotificationHandler notificationsHandler;
    private final FileUploader fileUploader;
    private final TokenManager tokenManager;

    private final ChatParser getDefaultParser() {
        Lazy lazy = this.defaultParser$delegate;
        BaseChatModule baseChatModule = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ChatParser)lazy.getValue();
    }

    private final ChatNotifications getDefaultNotifications() {
        Lazy lazy = this.defaultNotifications$delegate;
        BaseChatModule baseChatModule = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ChatNotifications)lazy.getValue();
    }

    private final ChatApi getDefaultApi() {
        Lazy lazy = this.defaultApi$delegate;
        BaseChatModule baseChatModule = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ChatApi)lazy.getValue();
    }

    private final ChatSocket getDefaultSocket() {
        Lazy lazy = this.defaultSocket$delegate;
        BaseChatModule baseChatModule = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ChatSocket)lazy.getValue();
    }

    private final StreamFileUploader getDefaultFileUploader() {
        Lazy lazy = this.defaultFileUploader$delegate;
        BaseChatModule baseChatModule = this;
        Object var3_3 = null;
        boolean bl = false;
        return (StreamFileUploader)lazy.getValue();
    }

    @NotNull
    public final ChatApi api() {
        return this.getDefaultApi();
    }

    @NotNull
    public final ChatSocket socket() {
        return this.getDefaultSocket();
    }

    @NotNull
    public final ChatParser parser() {
        return this.getDefaultParser();
    }

    @NotNull
    public final ChatLogger logger() {
        return this.defaultLogger;
    }

    @NotNull
    public final ChatNotifications notifications() {
        return this.getDefaultNotifications();
    }

    private final ChatNotifications buildNotification(ChatNotificationHandler handler2, ChatApi api) {
        return ChatNotifications.Companion.create(handler2, api, this.appContext);
    }

    private final Retrofit buildRetrofit(String endpoint, long timeout, ChatClientConfig config, ChatParser parser, boolean isAnonymousApi) {
        OkHttpClient okHttpClient = this.clientBuilder(timeout, config, parser, isAnonymousApi).build();
        Retrofit.Builder builder = new Retrofit.Builder().baseUrl(endpoint).client(okHttpClient);
        boolean bl = false;
        boolean bl2 = false;
        Retrofit.Builder p1 = builder;
        boolean bl3 = false;
        parser.configRetrofit(p1);
        Retrofit retrofit = builder.addCallAdapterFactory((CallAdapter.Factory)RetrofitCallAdapterFactory.Companion.create$default(RetrofitCallAdapterFactory.Companion, parser, null, 2, null)).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"Retrofit.Builder()\n     \u2026er))\n            .build()");
        return retrofit;
    }

    private final OkHttpClient getBaseClient() {
        Lazy lazy = this.baseClient$delegate;
        BaseChatModule baseChatModule = this;
        Object var3_3 = null;
        boolean bl = false;
        return (OkHttpClient)lazy.getValue();
    }

    private final OkHttpClient.Builder baseClientBuilder() {
        return this.getBaseClient().newBuilder().followRedirects(false);
    }

    @NotNull
    protected OkHttpClient.Builder clientBuilder(long timeout, @NotNull ChatClientConfig config, @NotNull ChatParser parser, boolean isAnonymousApi) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        return this.baseClientBuilder().callTimeout(timeout, TimeUnit.MILLISECONDS).connectTimeout(timeout, TimeUnit.MILLISECONDS).writeTimeout(timeout, TimeUnit.MILLISECONDS).readTimeout(timeout, TimeUnit.MILLISECONDS).addInterceptor((Interceptor)new HeadersInterceptor(this.getAnonymousProvider(config, isAnonymousApi))).addInterceptor((Interceptor)new HttpLoggingInterceptor()).addInterceptor((Interceptor)new TokenAuthInterceptor(this.tokenManager, parser, (Function0<Boolean>)((Function0)new Function0<Boolean>(config){
            final /* synthetic */ ChatClientConfig $config;

            public final boolean invoke() {
                return this.$config.isAnonymous();
            }
            {
                this.$config = chatClientConfig;
                super(0);
            }
        }))).addInterceptor((Interceptor)new CurlInterceptor(new Loggable(this){
            final /* synthetic */ BaseChatModule this$0;

            public final void log(String it) {
                ChatLogger chatLogger = this.this$0.logger();
                String string = it;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                chatLogger.logI("CURL", string);
            }
            {
                this.this$0 = baseChatModule;
            }
        }));
    }

    private final Function0<Boolean> getAnonymousProvider(ChatClientConfig config, boolean isAnonymousApi) {
        return (Function0)new Function0<Boolean>(isAnonymousApi, config){
            final /* synthetic */ boolean $isAnonymousApi;
            final /* synthetic */ ChatClientConfig $config;

            public final boolean invoke() {
                return this.$isAnonymousApi || this.$config.isAnonymous();
            }
            {
                this.$isAnonymousApi = bl;
                this.$config = chatClientConfig;
                super(0);
            }
        };
    }

    private final ChatSocket buildSocket(ChatClientConfig chatConfig, ChatParser parser) {
        Object object = this.appContext.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        return new ChatSocketImpl(chatConfig.getApiKey(), chatConfig.getWssUrl(), this.tokenManager, parser, new NetworkStateProvider((ConnectivityManager)object));
    }

    private final ChatApi buildApi(ChatClientConfig chatConfig) {
        String string = chatConfig.getApiKey();
        UuidGenerator uuidGenerator = new UuidGeneratorImpl();
        FileUploader fileUploader = this.fileUploader;
        if (fileUploader == null) {
            fileUploader = this.getDefaultFileUploader();
        }
        return new ChatApi(string, this.buildRetrofitApi(RetrofitApi.class), this.buildRetrofitApi(RetrofitAnonymousApi.class), uuidGenerator, fileUploader, null, 32, null);
    }

    private final <T> T buildRetrofitApi(Class<T> apiClass) {
        return (T)this.buildRetrofit(this.config.getHttpUrl(), this.config.getBaseTimeout(), this.config, this.parser(), this.isAnonymousApi(apiClass)).create(apiClass);
    }

    private final boolean isAnonymousApi(Class<?> $this$isAnonymousApi) {
        boolean auth;
        boolean anon;
        block6: {
            boolean bl;
            boolean bl2;
            int n;
            block5: {
                Annotation[] annotationArray = $this$isAnonymousApi.getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"this.annotations");
                Annotation[] $this$any$iv = annotationArray;
                boolean $i$f$any = false;
                Annotation[] annotationArray2 = $this$any$iv;
                int n2 = annotationArray2.length;
                for (n = 0; n < n2; ++n) {
                    Annotation element$iv;
                    Annotation it = element$iv = annotationArray2[n];
                    boolean bl3 = false;
                    if (!(it instanceof AnonymousApi)) continue;
                    bl2 = true;
                    break block5;
                }
                bl2 = false;
            }
            anon = bl2;
            Annotation[] annotationArray = $this$isAnonymousApi.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"this.annotations");
            Annotation[] $this$any$iv = annotationArray;
            boolean $i$f$any = false;
            Annotation[] annotationArray3 = $this$any$iv;
            n = annotationArray3.length;
            for (int i = 0; i < n; ++i) {
                Annotation element$iv;
                Annotation it = element$iv = annotationArray3[i];
                boolean bl4 = false;
                if (!(it instanceof AuthenticatedApi)) continue;
                bl = true;
                break block6;
            }
            bl = auth = false;
        }
        if (anon && auth) {
            throw (Throwable)new IllegalStateException("Api class must be annotated with either @AnonymousApi or @AuthenticatedApi, and not both");
        }
        if (anon) {
            return true;
        }
        if (auth) {
            return false;
        }
        throw (Throwable)new IllegalStateException("Api class must be annotated with either @AnonymousApi or @AuthenticatedApi");
    }

    private final RetrofitCdnApi buildRetrofitCdnApi() {
        Class<RetrofitCdnApi> apiClass = RetrofitCdnApi.class;
        Object object = this.buildRetrofit(this.config.getCdnHttpUrl(), this.config.getCdnTimeout(), this.config, this.parser(), this.isAnonymousApi(apiClass)).create(apiClass);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"buildRetrofit(\n         \u2026       ).create(apiClass)");
        return (RetrofitCdnApi)object;
    }

    public BaseChatModule(@NotNull Context appContext, @NotNull ChatClientConfig config, @NotNull ChatNotificationHandler notificationsHandler, @Nullable FileUploader fileUploader, @NotNull TokenManager tokenManager) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)notificationsHandler, (String)"notificationsHandler");
        Intrinsics.checkNotNullParameter((Object)tokenManager, (String)"tokenManager");
        this.appContext = appContext;
        this.config = config;
        this.notificationsHandler = notificationsHandler;
        this.fileUploader = fileUploader;
        this.tokenManager = tokenManager;
        this.defaultLogger = new ChatLogger.Builder(this.config.getLoggerConfig()).build();
        this.defaultParser$delegate = LazyKt.lazy((Function0)defaultParser.2.INSTANCE);
        this.defaultNotifications$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ChatNotifications>(this){
            final /* synthetic */ BaseChatModule this$0;

            @NotNull
            public final ChatNotifications invoke() {
                return BaseChatModule.access$buildNotification(this.this$0, BaseChatModule.access$getNotificationsHandler$p(this.this$0), this.this$0.api());
            }
            {
                this.this$0 = baseChatModule;
                super(0);
            }
        }));
        this.defaultApi$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ChatApi>(this){
            final /* synthetic */ BaseChatModule this$0;

            @NotNull
            public final ChatApi invoke() {
                return BaseChatModule.access$buildApi(this.this$0, BaseChatModule.access$getConfig$p(this.this$0));
            }
            {
                this.this$0 = baseChatModule;
                super(0);
            }
        }));
        this.defaultSocket$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ChatSocket>(this){
            final /* synthetic */ BaseChatModule this$0;

            @NotNull
            public final ChatSocket invoke() {
                return BaseChatModule.access$buildSocket(this.this$0, BaseChatModule.access$getConfig$p(this.this$0), this.this$0.parser());
            }
            {
                this.this$0 = baseChatModule;
                super(0);
            }
        }));
        this.defaultFileUploader$delegate = LazyKt.lazy((Function0)((Function0)new Function0<StreamFileUploader>(this){
            final /* synthetic */ BaseChatModule this$0;

            @NotNull
            public final StreamFileUploader invoke() {
                return new StreamFileUploader(BaseChatModule.access$getConfig$p(this.this$0).getApiKey(), BaseChatModule.access$buildRetrofitCdnApi(this.this$0));
            }
            {
                this.this$0 = baseChatModule;
                super(0);
            }
        }));
        this.baseClient$delegate = LazyKt.lazy((Function0)baseClient.2.INSTANCE);
    }

    public /* synthetic */ BaseChatModule(Context context, ChatClientConfig chatClientConfig, ChatNotificationHandler chatNotificationHandler, FileUploader fileUploader, TokenManager tokenManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            fileUploader = null;
        }
        if ((n & 0x10) != 0) {
            tokenManager = new TokenManagerImpl();
        }
        this(context, chatClientConfig, chatNotificationHandler, fileUploader, tokenManager);
    }

    public static final /* synthetic */ ChatNotifications access$buildNotification(BaseChatModule $this, ChatNotificationHandler handler2, ChatApi api) {
        return $this.buildNotification(handler2, api);
    }

    public static final /* synthetic */ ChatNotificationHandler access$getNotificationsHandler$p(BaseChatModule $this) {
        return $this.notificationsHandler;
    }

    public static final /* synthetic */ ChatApi access$buildApi(BaseChatModule $this, ChatClientConfig chatConfig) {
        return $this.buildApi(chatConfig);
    }

    public static final /* synthetic */ ChatClientConfig access$getConfig$p(BaseChatModule $this) {
        return $this.config;
    }

    public static final /* synthetic */ ChatSocket access$buildSocket(BaseChatModule $this, ChatClientConfig chatConfig, ChatParser parser) {
        return $this.buildSocket(chatConfig, parser);
    }

    public static final /* synthetic */ RetrofitCdnApi access$buildRetrofitCdnApi(BaseChatModule $this) {
        return $this.buildRetrofitCdnApi();
    }
}

