/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.logger;

import android.util.Log;
import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.logger.ChatLogLevel;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.ChatLoggerHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\tH\u0016J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\tH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/getstream/chat/android/client/logger/ChatLoggerImpl;", "Lio/getstream/chat/android/client/logger/ChatLogger;", "level", "Lio/getstream/chat/android/client/logger/ChatLogLevel;", "handler", "Lio/getstream/chat/android/client/logger/ChatLoggerHandler;", "(Lio/getstream/chat/android/client/logger/ChatLogLevel;Lio/getstream/chat/android/client/logger/ChatLoggerHandler;)V", "getLevel", "getStackString", "", "t", "", "getTag", "tag", "", "logD", "", "message", "logE", "chatError", "Lio/getstream/chat/android/client/errors/ChatError;", "throwable", "logI", "logW", "stream-chat-android-client_release"})
public final class ChatLoggerImpl
implements ChatLogger {
    private final ChatLogLevel level;
    private final ChatLoggerHandler handler;

    @Override
    public void logE(@NotNull Object tag, @NotNull String message, @NotNull Throwable throwable) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            if (this.level.isMoreOrEqualsThan$stream_chat_android_client_release(ChatLogLevel.ERROR)) {
                Log.e((String)this.getTag(tag), (String)message);
                Log.e((String)this.getTag(tag), (String)this.getStackString(throwable));
            }
            ChatLoggerHandler chatLoggerHandler = this.handler;
            if (chatLoggerHandler == null) break block1;
            chatLoggerHandler.logE(tag, message, throwable);
        }
    }

    @Override
    public void logE(@NotNull Object tag, @NotNull Throwable throwable) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            if (this.level.isMoreOrEqualsThan$stream_chat_android_client_release(ChatLogLevel.ERROR)) {
                Log.e((String)this.getTag(tag), (String)this.getStackString(throwable));
            }
            ChatLoggerHandler chatLoggerHandler = this.handler;
            if (chatLoggerHandler == null) break block1;
            chatLoggerHandler.logT(this.getTag(tag), throwable);
        }
    }

    @Override
    public void logE(@NotNull Object tag, @NotNull ChatError chatError) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)chatError, (String)"chatError");
        Throwable cause = chatError.getCause();
        String message = chatError.getMessage();
        if (cause != null && message != null) {
            this.logE(tag, message, cause);
        } else if (cause != null) {
            this.logE(tag, cause);
        } else {
            String string2 = message;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            this.logE(tag, string3);
        }
    }

    @Override
    public void logE(@NotNull Object tag, @NotNull String message, @NotNull ChatError chatError) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)chatError, (String)"chatError");
        Throwable cause = chatError.getCause();
        if (cause != null) {
            this.logE(tag, message, cause);
        } else {
            this.logE(tag, message);
        }
    }

    @Override
    public void logI(@NotNull Object tag, @NotNull String message) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (this.level.isMoreOrEqualsThan$stream_chat_android_client_release(ChatLogLevel.ALL)) {
                Log.i((String)this.getTag(tag), (String)message);
            }
            ChatLoggerHandler chatLoggerHandler = this.handler;
            if (chatLoggerHandler == null) break block1;
            chatLoggerHandler.logI(this.getTag(tag), message);
        }
    }

    @Override
    public void logD(@NotNull Object tag, @NotNull String message) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (this.level.isMoreOrEqualsThan$stream_chat_android_client_release(ChatLogLevel.DEBUG)) {
                Log.d((String)this.getTag(tag), (String)message);
            }
            ChatLoggerHandler chatLoggerHandler = this.handler;
            if (chatLoggerHandler == null) break block1;
            chatLoggerHandler.logD(this.getTag(tag), message);
        }
    }

    @Override
    public void logW(@NotNull Object tag, @NotNull String message) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (this.level.isMoreOrEqualsThan$stream_chat_android_client_release(ChatLogLevel.WARN)) {
                Log.w((String)this.getTag(tag), (String)message);
            }
            ChatLoggerHandler chatLoggerHandler = this.handler;
            if (chatLoggerHandler == null) break block1;
            chatLoggerHandler.logW(this.getTag(tag), message);
        }
    }

    @Override
    public void logE(@NotNull Object tag, @NotNull String message) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (this.level.isMoreOrEqualsThan$stream_chat_android_client_release(ChatLogLevel.ERROR)) {
                Log.e((String)this.getTag(tag), (String)message);
            }
            ChatLoggerHandler chatLoggerHandler = this.handler;
            if (chatLoggerHandler == null) break block1;
            chatLoggerHandler.logE(this.getTag(tag), message);
        }
    }

    @Override
    @NotNull
    public ChatLogLevel getLevel() {
        return this.level;
    }

    private final String getTag(Object tag) {
        String string2;
        Object object = tag;
        if (object == null) {
            string2 = "null";
        } else if (object instanceof String) {
            string2 = (String)tag;
        } else {
            String string3 = tag.getClass().getSimpleName();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"tag.javaClass.simpleName");
        }
        String stringTag = string2;
        return "Chat:" + stringTag;
    }

    private final String getStackString(Throwable t) {
        StringWriter errors = new StringWriter();
        t.printStackTrace(new PrintWriter(errors));
        String string2 = errors.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"errors.toString()");
        return string2;
    }

    public ChatLoggerImpl(@NotNull ChatLogLevel level, @Nullable ChatLoggerHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.level = level;
        this.handler = handler2;
    }

    public /* synthetic */ ChatLoggerImpl(ChatLogLevel chatLogLevel, ChatLoggerHandler chatLoggerHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            chatLogLevel = ChatLogLevel.NOTHING;
        }
        if ((n & 2) != 0) {
            chatLoggerHandler = null;
        }
        this(chatLogLevel, chatLoggerHandler);
    }

    public ChatLoggerImpl() {
        this(null, null, 3, null);
    }
}

