/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications;

import com.google.firebase.messaging.RemoteMessage;
import io.getstream.chat.android.client.notifications.FirebaseMessageParser;
import io.getstream.chat.android.client.notifications.handler.ChatNotificationHandler;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/getstream/chat/android/client/notifications/FirebaseMessageParserImpl;", "Lio/getstream/chat/android/client/notifications/FirebaseMessageParser;", "handler", "Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;", "(Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;)V", "channelIdKey", "", "channelTypeKey", "getHandler", "()Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;", "messageIdKey", "isValid", "", "message", "Lcom/google/firebase/messaging/RemoteMessage;", "parse", "Lio/getstream/chat/android/client/notifications/FirebaseMessageParser$Data;", "verifyPayload", "stream-chat-android-client_release"})
public final class FirebaseMessageParserImpl
implements FirebaseMessageParser {
    private final String messageIdKey;
    private final String channelTypeKey;
    private final String channelIdKey;
    @NotNull
    private final ChatNotificationHandler handler;

    @Override
    public boolean isValid(@NotNull RemoteMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.verifyPayload(message);
    }

    @Override
    @NotNull
    public FirebaseMessageParser.Data parse(@NotNull RemoteMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object v = message.getData().get(this.messageIdKey);
        Intrinsics.checkNotNull(v);
        String messageId = (String)v;
        Object v2 = message.getData().get(this.channelIdKey);
        Intrinsics.checkNotNull(v2);
        String channelId = (String)v2;
        Object v3 = message.getData().get(this.channelTypeKey);
        Intrinsics.checkNotNull(v3);
        String channelType = (String)v3;
        return new FirebaseMessageParser.Data(messageId, channelType, channelId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean verifyPayload(RemoteMessage message) {
        boolean bl;
        Set keys = SetsKt.setOf((Object[])new String[]{this.messageIdKey, this.channelIdKey, this.channelTypeKey});
        if (!message.getData().keySet().containsAll(keys)) return false;
        Iterable $this$none$iv = keys;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            String key = (String)element$iv;
            boolean bl2 = false;
            CharSequence charSequence = (CharSequence)message.getData().get(key);
            boolean bl3 = false;
            boolean bl4 = false;
            if (charSequence == null) return false;
            if (charSequence.length() == 0) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    @NotNull
    public final ChatNotificationHandler getHandler() {
        return this.handler;
    }

    public FirebaseMessageParserImpl(@NotNull ChatNotificationHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        this.handler = handler2;
        this.messageIdKey = this.handler.getFirebaseMessageIdKey();
        this.channelTypeKey = this.handler.getFirebaseChannelTypeKey();
        this.channelIdKey = this.handler.getFirebaseChannelIdKey();
    }
}

