/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.notifications.handler;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.RingtoneManager;
import android.net.Uri;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import androidx.core.app.RemoteInput;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.RemoteMessage;
import io.getstream.chat.android.client.R;
import io.getstream.chat.android.client.events.ChatEvent;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.notifications.DeviceRegisteredListener;
import io.getstream.chat.android.client.notifications.FirebaseMessageParser;
import io.getstream.chat.android.client.notifications.FirebaseMessageParserImpl;
import io.getstream.chat.android.client.notifications.NotificationLoadDataListener;
import io.getstream.chat.android.client.notifications.handler.NotificationConfig;
import io.getstream.chat.android.client.receivers.NotificationMessageReceiver;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J8\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0017J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0013H\u0016J\b\u0010%\u001a\u00020\u0013H\u0016J\b\u0010&\u001a\u00020\u0013H\u0016J\b\u0010'\u001a\u00020\u0013H\u0016J\n\u0010(\u001a\u0004\u0018\u00010)H\u0016J\b\u0010*\u001a\u00020\u0013H\u0016J\b\u0010+\u001a\u00020,H\u0016J \u0010-\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020\u0013H\u0016J\b\u00101\u001a\u00020\u0013H\u0016J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u0002032\u0006\u00107\u001a\u000205H\u0002J\b\u00108\u001a\u00020\u0011H\u0002J\b\u00109\u001a\u00020\u0011H\u0016J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020;2\u0006\u0010?\u001a\u00020@H\u0016J0\u0010A\u001a\u0002052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010B\u001a\u00020\u00132\u0006\u0010C\u001a\u00020\u0013H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lio/getstream/chat/android/client/notifications/handler/ChatNotificationHandler;", "", "context", "Landroid/content/Context;", "config", "Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;", "(Landroid/content/Context;Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;)V", "getConfig", "()Lio/getstream/chat/android/client/notifications/handler/NotificationConfig;", "getContext", "()Landroid/content/Context;", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "buildErrorCaseNotification", "Landroid/app/Notification;", "buildNotification", "notificationId", "", "channelName", "", "messageText", "messageId", "channelType", "channelId", "createNotificationChannel", "Landroid/app/NotificationChannel;", "drawableToBitmap", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "getDataLoadListener", "Lio/getstream/chat/android/client/notifications/NotificationLoadDataListener;", "getDeviceRegisteredListener", "Lio/getstream/chat/android/client/notifications/DeviceRegisteredListener;", "getErrorCaseIntent", "Landroid/content/Intent;", "getErrorCaseNotificationContent", "getErrorCaseNotificationTitle", "getFirebaseChannelIdKey", "getFirebaseChannelTypeKey", "getFirebaseInstanceId", "Lcom/google/firebase/iid/FirebaseInstanceId;", "getFirebaseMessageIdKey", "getFirebaseMessageParser", "Lio/getstream/chat/android/client/notifications/FirebaseMessageParser;", "getNewMessageIntent", "getNotificationBuilder", "Landroidx/core/app/NotificationCompat$Builder;", "getNotificationChannelId", "getNotificationChannelName", "getReadAction", "Landroidx/core/app/NotificationCompat$Action;", "pendingIntent", "Landroid/app/PendingIntent;", "getReplyAction", "replyPendingIntent", "getRequestCode", "getSmallIcon", "onChatEvent", "", "event", "Lio/getstream/chat/android/client/events/ChatEvent;", "onFirebaseMessage", "message", "Lcom/google/firebase/messaging/RemoteMessage;", "preparePendingIntent", "type", "actionType", "stream-chat-android-client_release"})
public class ChatNotificationHandler {
    private final TaggedLogger logger;
    @NotNull
    private final Context context;
    @NotNull
    private final NotificationConfig config;

    public boolean onChatEvent(@NotNull ChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return false;
    }

    public boolean onFirebaseMessage(@NotNull RemoteMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return false;
    }

    @Nullable
    public DeviceRegisteredListener getDeviceRegisteredListener() {
        return null;
    }

    @Nullable
    public NotificationLoadDataListener getDataLoadListener() {
        return null;
    }

    @RequiresApi(api=26)
    @NotNull
    public NotificationChannel createNotificationChannel() {
        this.logger.logI("createNotificationChannel()");
        NotificationChannel notificationChannel = new NotificationChannel(this.getNotificationChannelId(), (CharSequence)this.getNotificationChannelName(), 3);
        boolean bl = false;
        boolean bl2 = false;
        NotificationChannel $this$apply = notificationChannel;
        boolean bl3 = false;
        $this$apply.setShowBadge(true);
        $this$apply.setImportance(4);
        $this$apply.enableLights(true);
        $this$apply.setLightColor(-65536);
        $this$apply.enableVibration(true);
        $this$apply.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
        return notificationChannel;
    }

    @NotNull
    public String getNotificationChannelId() {
        String string = this.context.getString(this.config.getNotificationChannelId());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(config.notificationChannelId)");
        return string;
    }

    @NotNull
    public String getNotificationChannelName() {
        String string = this.context.getString(this.config.getNotificationChannelName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(config.notificationChannelName)");
        return string;
    }

    public int getSmallIcon() {
        return this.config.getSmallIcon();
    }

    @NotNull
    public String getFirebaseMessageIdKey() {
        return this.config.getFirebaseMessageIdKey();
    }

    @NotNull
    public String getFirebaseChannelIdKey() {
        return this.config.getFirebaseChannelIdKey();
    }

    @NotNull
    public String getFirebaseChannelTypeKey() {
        return this.config.getFirebaseChannelTypeKey();
    }

    @NotNull
    public String getErrorCaseNotificationTitle() {
        String string = this.context.getString(this.config.getErrorCaseNotificationTitle());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(config\u2026rorCaseNotificationTitle)");
        return string;
    }

    @NotNull
    public String getErrorCaseNotificationContent() {
        String string = this.context.getString(this.config.getErrorCaseNotificationContent());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(config\u2026rCaseNotificationContent)");
        return string;
    }

    @NotNull
    public Notification buildErrorCaseNotification() {
        Uri defaultSoundUri = RingtoneManager.getDefaultUri((int)2);
        NotificationCompat.Builder notificationBuilder = this.getNotificationBuilder();
        PendingIntent intent = PendingIntent.getActivity((Context)this.context, (int)this.getRequestCode(), (Intent)this.getErrorCaseIntent(), (int)0x8000000);
        Notification notification = notificationBuilder.setContentTitle((CharSequence)this.getErrorCaseNotificationTitle()).setContentText((CharSequence)this.getErrorCaseNotificationContent()).setPriority(1).setCategory("msg").setShowWhen(true).setContentIntent(intent).setSound(defaultSoundUri).build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"notificationBuilder.setC\u2026Uri)\n            .build()");
        return notification;
    }

    @NotNull
    public Notification buildNotification(int notificationId, @NotNull String channelName, @NotNull String messageText, @NotNull String messageId, @NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
        Intrinsics.checkNotNullParameter((Object)messageText, (String)"messageText");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Uri defaultSoundUri = RingtoneManager.getDefaultUri((int)2);
        NotificationCompat.Builder notificationBuilder = this.getNotificationBuilder();
        PendingIntent intent = PendingIntent.getActivity((Context)this.context, (int)this.getRequestCode(), (Intent)this.getNewMessageIntent(messageId, channelType, channelId), (int)0x8000000);
        notificationBuilder.setContentTitle((CharSequence)channelName).setContentText((CharSequence)messageText).setPriority(1).setCategory("msg").setShowWhen(true).setContentIntent(intent).setSound(defaultSoundUri);
        NotificationCompat.Builder builder = notificationBuilder;
        boolean bl = false;
        boolean bl2 = false;
        NotificationCompat.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.addAction(this.getReadAction(this.preparePendingIntent(notificationId, messageId, channelId, channelType, "com.getstream.sdk.chat.READ")));
        $this$apply.addAction(this.getReplyAction(this.preparePendingIntent(notificationId, messageId, channelId, channelType, "com.getstream.sdk.chat.REPLY")));
        Notification notification = notificationBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"notificationBuilder.build()");
        return notification;
    }

    private final int getRequestCode() {
        return 1220999987;
    }

    @NotNull
    public Intent getNewMessageIntent(@NotNull String messageId, @NotNull String channelType, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)channelType, (String)"channelType");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        PackageManager packageManager = this.context.getPackageManager();
        Intrinsics.checkNotNull((Object)packageManager);
        Intent intent = packageManager.getLaunchIntentForPackage(this.context.getPackageName());
        Intrinsics.checkNotNull((Object)intent);
        return intent;
    }

    @NotNull
    public Intent getErrorCaseIntent() {
        PackageManager packageManager = this.context.getPackageManager();
        Intrinsics.checkNotNull((Object)packageManager);
        Intent intent = packageManager.getLaunchIntentForPackage(this.context.getPackageName());
        Intrinsics.checkNotNull((Object)intent);
        return intent;
    }

    @NotNull
    public FirebaseMessageParser getFirebaseMessageParser() {
        return new FirebaseMessageParserImpl(this);
    }

    private final Bitmap drawableToBitmap(Drawable drawable) {
        if (drawable instanceof BitmapDrawable) {
            Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"drawable.bitmap");
            return bitmap;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    private final NotificationCompat.Builder getNotificationBuilder() {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context, this.getNotificationChannelId()).setAutoCancel(true).setSmallIcon(this.getSmallIcon()).setDefaults(-1);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"NotificationCompat.Build\u2026cationCompat.DEFAULT_ALL)");
        return builder;
    }

    private final NotificationCompat.Action getReadAction(PendingIntent pendingIntent) {
        NotificationCompat.Action action = new NotificationCompat.Action.Builder(17301591, (CharSequence)this.context.getString(R.string.stream_chat_notification_read), pendingIntent).build();
        Intrinsics.checkNotNullExpressionValue((Object)action, (String)"NotificationCompat.Actio\u2026gIntent\n        ).build()");
        return action;
    }

    private final NotificationCompat.Action getReplyAction(PendingIntent replyPendingIntent) {
        RemoteInput remoteInput = new RemoteInput.Builder("text_reply").setLabel((CharSequence)this.context.getString(R.string.stream_chat_notification_type_hint)).build();
        Intrinsics.checkNotNullExpressionValue((Object)remoteInput, (String)"RemoteInput.Builder(Noti\u2026\n                .build()");
        RemoteInput remoteInput2 = remoteInput;
        NotificationCompat.Action action = new NotificationCompat.Action.Builder(17301584, (CharSequence)this.context.getString(R.string.stream_chat_notification_reply), replyPendingIntent).addRemoteInput(remoteInput2).setAllowGeneratedReplies(true).build();
        Intrinsics.checkNotNullExpressionValue((Object)action, (String)"NotificationCompat.Actio\u2026rue)\n            .build()");
        return action;
    }

    private final PendingIntent preparePendingIntent(int notificationId, String messageId, String channelId, String type, String actionType) {
        Intent notifyIntent;
        Intent intent = notifyIntent = new Intent(this.context, NotificationMessageReceiver.class);
        boolean bl = false;
        boolean bl2 = false;
        Intent $this$apply = intent;
        boolean bl3 = false;
        $this$apply.putExtra("notification_id", notificationId);
        $this$apply.putExtra("message_id", messageId);
        $this$apply.putExtra("id", channelId);
        $this$apply.putExtra("type", type);
        $this$apply.setAction(actionType);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)notifyIntent, (int)0x8000000);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"PendingIntent.getBroadca\u2026_UPDATE_CURRENT\n        )");
        return pendingIntent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public FirebaseInstanceId getFirebaseInstanceId() {
        if (!this.config.getUseProvidedFirebaseInstance()) return null;
        List list = FirebaseApp.getApps((Context)this.context);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"FirebaseApp.getApps(context)");
        Collection collection = list;
        boolean bl = false;
        if (collection.isEmpty()) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        FirebaseInstanceId firebaseInstanceId = FirebaseInstanceId.getInstance();
        return firebaseInstanceId;
    }

    @NotNull
    protected final Context getContext() {
        return this.context;
    }

    @NotNull
    public final NotificationConfig getConfig() {
        return this.config;
    }

    @JvmOverloads
    public ChatNotificationHandler(@NotNull Context context, @NotNull NotificationConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.config = config;
        this.logger = ChatLogger.Companion.get("ChatNotificationHandler");
    }

    public /* synthetic */ ChatNotificationHandler(Context context, NotificationConfig notificationConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            notificationConfig = new NotificationConfig(0, 0, 0, null, null, null, null, null, 0, 0, false, 2047, null);
        }
        this(context, notificationConfig);
    }

    @JvmOverloads
    public ChatNotificationHandler(@NotNull Context context) {
        this(context, null, 2, null);
    }
}

