/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.parser;

import androidx.annotation.VisibleForTesting;
import com.google.gson.Gson;
import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.errors.ChatErrorCode;
import io.getstream.chat.android.client.errors.ChatNetworkError;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.parser.ChatParser;
import io.getstream.chat.android.client.parser.ChatParserImpl;
import io.getstream.chat.android.client.parser.UrlQueryPayloadFactory;
import io.getstream.chat.android.client.socket.ErrorResponse;
import io.getstream.chat.android.client.utils.Result;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J-\u0010\u000f\u001a\u0002H\u0010\"\b\b\u0000\u0010\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J.\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0017\"\b\b\u0000\u0010\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0014H\u0016J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u0018\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u00020\u00068FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006 "}, d2={"Lio/getstream/chat/android/client/parser/ChatParserImpl;", "Lio/getstream/chat/android/client/parser/ChatParser;", "()V", "TAG", "", "gson", "Lcom/google/gson/Gson;", "getGson$annotations", "getGson", "()Lcom/google/gson/Gson;", "gson$delegate", "Lkotlin/Lazy;", "configRetrofit", "Lretrofit2/Retrofit$Builder;", "builder", "fromJson", "T", "", "raw", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "fromJsonOrError", "Lio/getstream/chat/android/client/utils/Result;", "toError", "Lio/getstream/chat/android/client/socket/ErrorResponse;", "body", "Lio/getstream/chat/android/client/errors/ChatNetworkError;", "okHttpResponse", "Lokhttp3/Response;", "toJson", "any", "stream-chat-android-client_release"})
public final class ChatParserImpl
implements ChatParser {
    private final String TAG;
    @NotNull
    private final Lazy gson$delegate;

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getGson$annotations() {
    }

    @NotNull
    public final Gson getGson() {
        Lazy lazy = this.gson$delegate;
        ChatParserImpl chatParserImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Gson)lazy.getValue();
    }

    @Override
    @NotNull
    public String toJson(@NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        String string2 = this.getGson().toJson(any);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gson.toJson(any)");
        return string2;
    }

    @Override
    @NotNull
    public <T> T fromJson(@NotNull String raw, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Object object = this.getGson().fromJson(raw, clazz);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(raw, clazz)");
        return (T)object;
    }

    @Override
    @NotNull
    public <T> Result<T> fromJsonOrError(@NotNull String raw, @NotNull Class<T> clazz) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        try {
            result = new Result(this.fromJson(raw, clazz), null);
        }
        catch (Throwable t) {
            result = new Result(null, new ChatError("fromJsonOrError error parsing of " + clazz + " into " + raw, t));
        }
        return result;
    }

    @Override
    @NotNull
    public ChatNetworkError toError(@NotNull Response okHttpResponse) {
        ChatNetworkError chatNetworkError;
        Intrinsics.checkNotNullParameter((Object)okHttpResponse, (String)"okHttpResponse");
        int statusCode = okHttpResponse.code();
        try {
            String body = okHttpResponse.peekBody(Long.MAX_VALUE).string();
            ErrorResponse error = this.toError(body);
            chatNetworkError = error == null ? ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, ChatErrorCode.NO_ERROR_BODY, null, statusCode, 2, null) : ChatNetworkError.Companion.create$default(ChatNetworkError.Companion, error.getCode(), error.getMessage(), statusCode, null, 8, null);
        }
        catch (Throwable t) {
            ChatLogger.Companion.getInstance().logE((Object)this.TAG, t);
            chatNetworkError = ChatNetworkError.Companion.create(ChatErrorCode.NETWORK_FAILED, t, statusCode);
        }
        return chatNetworkError;
    }

    @Override
    @NotNull
    public Retrofit.Builder configRetrofit(@NotNull Retrofit.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Retrofit.Builder builder2 = builder.addConverterFactory((Converter.Factory)new UrlQueryPayloadFactory(this.getGson())).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGson()));
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"builder\n            .add\u2026rterFactory.create(gson))");
        return builder2;
    }

    private final ErrorResponse toError(String body) {
        Object object = body;
        boolean bl = false;
        boolean bl2 = false;
        if (object == null || object.length() == 0) {
            return new ErrorResponse(0, "Body is null or empty", 0, 5, null);
        }
        try {
            object = this.fromJson(body, ErrorResponse.class);
        }
        catch (Throwable t) {
            ErrorResponse errorResponse = new ErrorResponse(0, null, 0, 7, null);
            boolean bl3 = false;
            boolean bl4 = false;
            ErrorResponse $this$apply = errorResponse;
            boolean bl5 = false;
            $this$apply.setMessage(body);
            object = errorResponse;
        }
        return object;
    }

    public ChatParserImpl() {
        String string2 = ChatParser.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ChatParser::class.java.simpleName");
        this.TAG = string2;
        this.gson$delegate = LazyKt.lazy((Function0)gson.2.INSTANCE);
    }
}

