/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.socket;

import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.parser.ChatParser;
import io.getstream.chat.android.client.socket.EventsParser;
import io.getstream.chat.android.client.socket.Socket;
import io.getstream.chat.android.client.token.TokenManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/getstream/chat/android/client/socket/SocketFactory;", "", "eventsParser", "Lio/getstream/chat/android/client/socket/EventsParser;", "parser", "Lio/getstream/chat/android/client/parser/ChatParser;", "tokenManager", "Lio/getstream/chat/android/client/token/TokenManager;", "(Lio/getstream/chat/android/client/socket/EventsParser;Lio/getstream/chat/android/client/parser/ChatParser;Lio/getstream/chat/android/client/token/TokenManager;)V", "httpClient", "Lokhttp3/OkHttpClient;", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "buildUrl", "", "endpoint", "apiKey", "user", "Lio/getstream/chat/android/client/models/User;", "buildUserDetailJson", "create", "Lio/getstream/chat/android/client/socket/Socket;", "Companion", "stream-chat-android-client_release"})
public final class SocketFactory {
    private final TaggedLogger logger;
    private final OkHttpClient httpClient;
    private final EventsParser eventsParser;
    private final ChatParser parser;
    private final TokenManager tokenManager;
    private static final String ANONYMOUS_USER_ID = "anon";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Socket create(@NotNull String endpoint, @NotNull String apiKey, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        String url = this.buildUrl(endpoint, apiKey, user);
        Request request = new Request.Builder().url(url).build();
        WebSocket newWebSocket = this.httpClient.newWebSocket(request, (WebSocketListener)this.eventsParser);
        this.logger.logI("new web socket: " + url);
        return new Socket(newWebSocket, this.parser);
    }

    private final String buildUrl(String endpoint, String apiKey, User user) {
        String string2;
        String json = this.buildUserDetailJson(user);
        try {
            String string3;
            String string4 = URLEncoder.encode(json, StandardCharsets.UTF_8.name());
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"URLEncoder.encode(json, \u2026ardCharsets.UTF_8.name())");
            json = string4;
            String baseWsUrl = endpoint + "connect?json=" + json + "&api_key=" + apiKey;
            if (user == null) {
                string3 = baseWsUrl + "&stream-auth-type=anonymous";
            } else {
                String token = this.tokenManager.getToken();
                string3 = baseWsUrl + "&authorization=" + token + "&stream-auth-type=jwt";
            }
            string2 = string3;
        }
        catch (Throwable throwable) {
            throw (Throwable)new UnsupportedEncodingException("Unable to encode user details json: " + json);
        }
        return string2;
    }

    private final String buildUserDetailJson(User user) {
        User user2 = user;
        if (user2 == null) {
            user2 = new User(ANONYMOUS_USER_ID, null, false, false, null, false, null, null, null, 0, 0, 0, null, null, null, null, 65534, null);
        }
        User user3 = user2;
        Map data = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"user_details", (Object)user3), TuplesKt.to((Object)"user_id", (Object)user3.getId()), TuplesKt.to((Object)"server_determines_connection_id", (Object)true), TuplesKt.to((Object)"X-STREAM-CLIENT", (Object)ChatClient.Companion.instance().getVersion())});
        return this.parser.toJson(data);
    }

    public SocketFactory(@NotNull EventsParser eventsParser, @NotNull ChatParser parser, @NotNull TokenManager tokenManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventsParser), (String)"eventsParser");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)tokenManager, (String)"tokenManager");
        this.eventsParser = eventsParser;
        this.parser = parser;
        this.tokenManager = tokenManager;
        String string2 = SocketFactory.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SocketFactory::class.java.simpleName");
        this.logger = ChatLogger.Companion.get(string2);
        this.httpClient = new OkHttpClient();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/client/socket/SocketFactory$Companion;", "", "()V", "ANONYMOUS_USER_ID", "", "stream-chat-android-client_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

