/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.client.parser.adapters;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.getstream.chat.android.client.errors.ChatParsingError;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.CustomObject;
import io.getstream.chat.android.client.parser.IgnoreDeserialisation;
import io.getstream.chat.android.client.parser.IgnoreSerialisation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/getstream/chat/android/client/parser/adapters/CustomObjectGsonAdapter;", "Lcom/google/gson/TypeAdapter;", "Lio/getstream/chat/android/client/models/CustomObject;", "gson", "Lcom/google/gson/Gson;", "clazz", "Ljava/lang/Class;", "(Lcom/google/gson/Gson;Ljava/lang/Class;)V", "read", "reader", "Lcom/google/gson/stream/JsonReader;", "setFieldOrError", "", "field", "Ljava/lang/reflect/Field;", "obj", "", "value", "name", "", "setFieldSafe", "", "tryToRestoreNullValue", "write", "writer", "Lcom/google/gson/stream/JsonWriter;", "Companion", "stream-chat-android-client_release"})
public final class CustomObjectGsonAdapter
extends TypeAdapter<CustomObject> {
    private final Gson gson;
    private final Class<?> clazz;
    @NotNull
    private static final TaggedLogger logger;
    public static final Companion Companion;

    public void write(@NotNull JsonWriter writer, @Nullable CustomObject obj) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        try {
            if (obj == null) {
                this.gson.getAdapter(HashMap.class).write(writer, null);
            } else {
                HashMap result = new HashMap();
                Map map = result;
                Map<String, Object> map2 = obj.getExtraData();
                boolean bl = false;
                map.putAll(map2);
                Field[] fieldArray = this.clazz.getDeclaredFields();
                int n = fieldArray.length;
                for (int i = 0; i < n; ++i) {
                    String name;
                    Field field;
                    Field field2 = field = fieldArray[i];
                    Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"field");
                    if (field2.isSynthetic() || field.getAnnotation(IgnoreSerialisation.class) != null) continue;
                    field.setAccessible(true);
                    Intrinsics.checkNotNullExpressionValue((Object)field.getName(), (String)"field.name");
                    SerializedName serializedName = field.getAnnotation(SerializedName.class);
                    if (serializedName != null) {
                        name = serializedName.value();
                    }
                    Object value = field.get(obj);
                    try {
                        ((Map)result).put(name, value);
                        continue;
                    }
                    catch (Exception e) {
                        throw (Throwable)new ChatParsingError("unable to set field " + name + " with value " + value);
                    }
                }
                this.gson.getAdapter(HashMap.class).write(writer, result);
            }
        }
        catch (Throwable e) {
            throw (Throwable)new ChatParsingError("custom object serialisation error of " + this.clazz, e);
        }
    }

    @Nullable
    public CustomObject read(@NotNull JsonReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        try {
            Object obj = this.clazz.newInstance();
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type io.getstream.chat.android.client.models.CustomObject");
            }
            CustomObject result = (CustomObject)obj;
            HashMap read = (HashMap)this.gson.getAdapter(HashMap.class).read(reader);
            if (read == null) {
                logger.logE("exception case when api returned null where it shouldn't: " + reader);
                return null;
            }
            HashMap map = read;
            Field[] fieldArray = this.clazz.getDeclaredFields();
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                String name;
                Field field;
                Field field2 = field = fieldArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"field");
                if (field2.isSynthetic() || field.getAnnotation(IgnoreDeserialisation.class) != null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)field.getName(), (String)"field.name");
                SerializedName serializedName = field.getAnnotation(SerializedName.class);
                if (serializedName != null) {
                    name = serializedName.value();
                }
                if (!map.containsKey(name)) continue;
                field.setAccessible(true);
                String rawValue = this.gson.toJson(map.remove(name));
                TypeToken typeToken = TypeToken.get((Type)field.getGenericType());
                TypeAdapter adapter = this.gson.getAdapter(typeToken);
                Object value = adapter.fromJson(rawValue);
                if (value == null) {
                    boolean restored = this.tryToRestoreNullValue(field, result);
                    if (restored) continue;
                    this.setFieldOrError(field, result, null, name);
                    continue;
                }
                this.setFieldOrError(field, result, value, name);
            }
            result.setExtraData(map);
            return result;
        }
        catch (Throwable e) {
            throw (Throwable)new ChatParsingError("custom object deserialisation error of " + this.clazz, e);
        }
    }

    private final void setFieldOrError(Field field, Object obj, Object value, String name) {
        try {
            field.set(obj, value);
        }
        catch (Throwable e) {
            throw (Throwable)new ChatParsingError("unable to set field " + name + " with value " + value);
        }
    }

    private final boolean tryToRestoreNullValue(Field field, Object obj) {
        Class<?> clazz = field.getType();
        return Intrinsics.areEqual(clazz, List.class) ? this.setFieldSafe(field, obj, new ArrayList()) : (Intrinsics.areEqual(clazz, Map.class) ? this.setFieldSafe(field, obj, new LinkedHashMap()) : (Intrinsics.areEqual(clazz, Integer.TYPE) ? this.setFieldSafe(field, obj, 0) : (Intrinsics.areEqual(clazz, Boolean.TYPE) ? this.setFieldSafe(field, obj, false) : (Intrinsics.areEqual(clazz, Float.TYPE) ? this.setFieldSafe(field, obj, Float.valueOf(0.0f)) : (Intrinsics.areEqual(clazz, String.class) ? this.setFieldSafe(field, obj, "") : false)))));
    }

    private final boolean setFieldSafe(Field field, Object obj, Object value) {
        boolean bl;
        try {
            field.set(obj, value);
            bl = true;
        }
        catch (Throwable e) {
            logger.logE("unable to set field " + field.getName() + " with value " + value);
            bl = false;
        }
        return bl;
    }

    public CustomObjectGsonAdapter(@NotNull Gson gson2, @NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter((Object)gson2, (String)"gson");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        this.gson = gson2;
        this.clazz = clazz;
    }

    static {
        Companion = new Companion(null);
        logger = ChatLogger.Companion.get("CustomObjectAdapter");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/getstream/chat/android/client/parser/adapters/CustomObjectGsonAdapter$Companion;", "", "()V", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "getLogger", "()Lio/getstream/chat/android/client/logger/TaggedLogger;", "stream-chat-android-client_release"})
    public static final class Companion {
        @NotNull
        public final TaggedLogger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

